/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.util.List;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.dataexport.CommonElementExporter;
import org.eclipse.fordiac.ide.model.dataexport.SubApplicationTypeExporter;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Comment;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ConnectionRoutingData;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerFBNElement;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceType;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceTypeFB;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.typelibrary.impl.SubAppTypeEntryImpl;

class FBNetworkExporter
extends CommonElementExporter {
    FBNetworkExporter(CommonElementExporter parent) {
        super(parent);
    }

    void createFBNetworkElement(FBNetwork fbNetwork) throws XMLStreamException {
        this.addStartElement(FBNetworkExporter.getMainElementName(fbNetwork));
        this.addFBNetworkElements(fbNetwork);
        this.addConnections((List<? extends Connection>)fbNetwork.getEventConnections(), "EventConnections", fbNetwork);
        this.addConnections((List<? extends Connection>)fbNetwork.getDataConnections(), "DataConnections", fbNetwork);
        this.addConnections((List<? extends Connection>)fbNetwork.getAdapterConnections(), "AdapterConnections", fbNetwork);
        this.addEndElement();
    }

    private static String getMainElementName(FBNetwork fbNetwork) {
        String elementName = "SubAppNetwork";
        if (fbNetwork.eContainer() instanceof FBType && !(fbNetwork.eContainer() instanceof SubAppType) || fbNetwork.eContainer() instanceof Resource || fbNetwork.eContainer() instanceof ResourceType) {
            elementName = "FBNetwork";
        }
        return elementName;
    }

    private void addFBNetworkElements(FBNetwork network) throws XMLStreamException {
        for (FBNetworkElement fbnElement : network.getNetworkElements()) {
            if (!FBNetworkExporter.isExportableErrorMarker(fbnElement)) continue;
            if (fbnElement instanceof Comment) {
                Comment comment = (Comment)fbnElement;
                this.addCommentElement(comment);
                continue;
            }
            this.addFBNetworkElement(fbnElement);
        }
    }

    protected void addFBNetworkElement(FBNetworkElement fbnElement) throws XMLStreamException {
        String nodeName = FBNetworkExporter.getFBNElementNodeName(fbnElement);
        if (nodeName != null) {
            EObject container;
            TypedSubApp tsa;
            this.addStartElement(nodeName);
            this.addFBNetworkElementXMLAttributes(fbnElement);
            this.addFBNetworkElementChildren(fbnElement);
            if (fbnElement instanceof TypedSubApp && !(tsa = (TypedSubApp)fbnElement).getVarConfigParams().isEmpty() && ((container = EcoreUtil.getRootContainer((EObject)tsa)) instanceof AutomationSystem || container instanceof SubAppType)) {
                this.addParamsConfig(tsa.getVarConfigParams());
            }
            this.addEndElement();
        }
    }

    private void addFBNetworkElementXMLAttributes(FBNetworkElement fbnElement) throws XMLStreamException {
        this.addNameAttribute(this.getFBNElementName(fbnElement));
        if (fbnElement.getType() != null) {
            this.addTypeAttribute(fbnElement.getType());
        }
        this.addCommentAttribute(fbnElement.getComment());
        this.addXYAttributes(fbnElement);
        if (fbnElement instanceof Group) {
            Group group = (Group)fbnElement;
            this.addGroupAttributes(group);
        }
    }

    protected String getFBNElementName(FBNetworkElement fbnElement) {
        return fbnElement.getName();
    }

    private void addCommentElement(Comment comment) throws XMLStreamException {
        boolean hasAttributes;
        boolean bl = hasAttributes = !comment.getAttributes().isEmpty();
        if (comment.isInGroup() || hasAttributes) {
            this.addStartElement("Comment");
        } else {
            this.addEmptyStartElement("Comment");
        }
        this.addCommentAttribute(comment.getComment());
        this.addXYAttributes(comment);
        this.getWriter().writeAttribute("width", FBNetworkExporter.formatPosOrSizeVal(comment.getWidth()));
        this.getWriter().writeAttribute("height", FBNetworkExporter.formatPosOrSizeVal(comment.getHeight()));
        if (comment.isInGroup()) {
            this.addGroupAttribute(comment.getGroup());
        }
        if (hasAttributes) {
            this.addAttributes((EList<Attribute>)comment.getAttributes());
        }
        if (comment.isInGroup() || hasAttributes) {
            this.addEndElement();
        }
    }

    private void addGroupAttributes(Group group) throws XMLStreamException {
        this.getWriter().writeAttribute("width", FBNetworkExporter.formatPosOrSizeVal(group.getWidth()));
        this.getWriter().writeAttribute("height", FBNetworkExporter.formatPosOrSizeVal(group.getHeight()));
        this.getWriter().writeAttribute("locked", Boolean.toString(group.isLocked()));
    }

    private void addFBNetworkElementChildren(FBNetworkElement fbnElement) throws XMLStreamException {
        if (FBNetworkExporter.isUntypedSubapp(fbnElement)) {
            this.createUntypedSubAppContents((SubApp)fbnElement);
        }
        if (fbnElement instanceof ConfigurableFB) {
            ConfigurableFB configFb = (ConfigurableFB)fbnElement;
            this.addAttributes(configFb.getConfigurationAsAttributes());
            this.addDependency(configFb.getDataType());
        }
        this.addAttributes((EList<Attribute>)fbnElement.getAttributes());
        if (!FBNetworkExporter.isUntypedSubapp(fbnElement) && fbnElement instanceof BlockFBNetworkElement) {
            BlockFBNetworkElement blockFbnEl = (BlockFBNetworkElement)fbnElement;
            this.addParamsConfig(blockFbnEl.getInterface());
        }
        if (fbnElement instanceof SubApp) {
            SubApp subApp = (SubApp)fbnElement;
            if (FBNetworkExporter.isUntypedSubapp(fbnElement)) {
                this.addSubappHeightAndWidthAttributes(subApp);
                if (subApp.isLocked()) {
                    this.addAttributeElement("locked", IecTypes.ElementaryTypes.BOOL, Boolean.toString(subApp.isLocked()), null);
                }
            }
        }
        if (fbnElement.isInGroup()) {
            this.addGroupAttribute(fbnElement.getGroup());
        }
    }

    private void addParamsConfig(InterfaceList il) throws XMLStreamException {
        Stream stream = il.getEventInputs().stream();
        stream = Stream.concat(stream, il.getInputVars().stream());
        stream = Stream.concat(stream, il.getInOutVars().stream());
        stream = Stream.concat(stream, il.getSockets().stream());
        stream = Stream.concat(stream, il.getEventOutputs().stream());
        stream = Stream.concat(stream, il.getOutputVars().stream());
        stream = Stream.concat(stream, il.getPlugs().stream());
        stream = Stream.concat(stream, il.getErrorMarker().stream());
        for (IInterfaceElement ie : stream.toList()) {
            this.addParam(ie);
        }
    }

    private void addSubappHeightAndWidthAttributes(SubApp subApp) throws XMLStreamException {
        if (subApp.getWidth() != 0.0) {
            this.addAttributeElement("width", IecTypes.ElementaryTypes.LREAL, FBNetworkExporter.formatPosOrSizeVal(subApp.getWidth()), null);
        }
        if (subApp.getHeight() != 0.0) {
            this.addAttributeElement("height", IecTypes.ElementaryTypes.LREAL, FBNetworkExporter.formatPosOrSizeVal(subApp.getHeight()), null);
        }
    }

    private static boolean isUntypedSubapp(FBNetworkElement fbnElement) {
        SubApp subApp;
        return fbnElement instanceof SubApp && !(subApp = (SubApp)fbnElement).isTyped();
    }

    private static String getFBNElementNodeName(FBNetworkElement fbnElement) {
        if (!(fbnElement.getType() instanceof AdapterType)) {
            if (fbnElement instanceof FB && !(fbnElement instanceof ResourceTypeFB)) {
                return "FB";
            }
            if (fbnElement instanceof ErrorMarkerFBNElement) {
                if (fbnElement.getTypeEntry() instanceof SubAppTypeEntryImpl) {
                    return "SubApp";
                }
                return "FB";
            }
            if (fbnElement instanceof SubApp) {
                return "SubApp";
            }
            if (fbnElement instanceof Group) {
                return "Group";
            }
        }
        return null;
    }

    private void createUntypedSubAppContents(SubApp element) throws XMLStreamException {
        new SubApplicationTypeExporter(this).addInterfaceList(element.getInterface());
        if (element.getSubAppNetwork() != null) {
            new FBNetworkExporter(this).createFBNetworkElement(element.getSubAppNetwork());
        }
    }

    protected void addConnections(List<? extends Connection> connections, String connectionElementName, FBNetwork fbNetwork) throws XMLStreamException {
        if (!connections.isEmpty()) {
            this.addStartElement(connectionElementName);
            for (Connection connection : connections) {
                this.addConnection(connection, fbNetwork);
            }
            this.addEndElement();
        }
    }

    private void addConnection(Connection connection, FBNetwork fbNetwork) throws XMLStreamException {
        boolean hasAttributes;
        boolean bl = hasAttributes = !connection.getAttributes().isEmpty();
        if (hasAttributes) {
            this.addStartElement("Connection");
        } else {
            this.addEmptyStartElement("Connection");
        }
        if (FBNetworkExporter.isExportableConnectionEndpoint(connection.getSource())) {
            this.getWriter().writeAttribute("Source", this.getConnectionEndpointIdentifier(connection.getSource(), fbNetwork));
        }
        if (FBNetworkExporter.isExportableConnectionEndpoint(connection.getDestination())) {
            this.getWriter().writeAttribute("Destination", this.getConnectionEndpointIdentifier(connection.getDestination(), fbNetwork));
        }
        this.addCommentAttribute(connection.getComment());
        this.addConnectionCoordinates(connection);
        if (hasAttributes) {
            this.addAttributes(connection.getAttributes());
            this.addEndElement();
        }
    }

    private static boolean isExportableConnectionEndpoint(IInterfaceElement endPoint) {
        return endPoint != null && FBNetworkExporter.isExportableErrorMarker(endPoint.getBlockFBNetworkElement()) && endPoint.eContainer() instanceof InterfaceList;
    }

    public static boolean isExportableErrorMarker(FBNetworkElement fbNetworkElement) {
        return !(fbNetworkElement instanceof ErrorMarkerFBNElement) || fbNetworkElement.getTypeEntry() != null;
    }

    private String getConnectionEndpointIdentifier(IInterfaceElement interfaceElement, FBNetwork fbNetwork) {
        Object retVal = "";
        if (interfaceElement.getBlockFBNetworkElement() != null && interfaceElement.getBlockFBNetworkElement().getFbNetwork() == fbNetwork) {
            retVal = this.getFBNElementName(interfaceElement.getBlockFBNetworkElement()) + ".";
        }
        retVal = (String)retVal + interfaceElement.getName();
        return retVal;
    }

    private void addConnectionCoordinates(Connection connection) throws XMLStreamException {
        ConnectionRoutingData routingData = connection.getRoutingData();
        if (routingData != null && !routingData.is1SegementData()) {
            this.getWriter().writeAttribute("dx1", FBNetworkExporter.formatPosOrSizeVal(routingData.getDx1()));
            if (routingData.is5SegementData()) {
                this.getWriter().writeAttribute("dx2", FBNetworkExporter.formatPosOrSizeVal(routingData.getDx2()));
                this.getWriter().writeAttribute("dy", FBNetworkExporter.formatPosOrSizeVal(routingData.getDy()));
            }
        }
    }

    private void addGroupAttribute(Group group) throws XMLStreamException {
        this.addAttributeElement("GroupName", IecTypes.ElementaryTypes.STRING, group.getName(), null);
    }
}

