/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.widgets;

import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.ui.widgets.ITypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.ImportContentProposal;
import org.eclipse.fordiac.ide.model.ui.widgets.TypeSelectionProposalProvider;
import org.eclipse.jface.fieldassist.ContentProposal;

public class ImportTypeSelectionProposalProvider
extends TypeSelectionProposalProvider {
    private final Supplier<? extends EObject> supplier;
    private final BiFunction<TypeLibrary, String, ? extends TypeEntry> typeResolver;

    public ImportTypeSelectionProposalProvider(Supplier<? extends EObject> supplier, BiFunction<TypeLibrary, String, ? extends TypeEntry> typeResolver, ITypeSelectionContentProvider contentProvider) {
        super(() -> TypeLibraryManager.INSTANCE.getTypeLibraryFromContext((EObject)supplier.get()), contentProvider);
        this.supplier = supplier;
        this.typeResolver = typeResolver;
    }

    public ImportTypeSelectionProposalProvider(Supplier<? extends EObject> supplier, BiFunction<TypeLibrary, String, ? extends TypeEntry> typeResolver, ITypeSelectionContentProvider contentProvider, Predicate<TypeEntry> additionalFilter) {
        super(() -> TypeLibraryManager.INSTANCE.getTypeLibraryFromContext((EObject)supplier.get()), contentProvider, additionalFilter);
        this.supplier = supplier;
        this.typeResolver = typeResolver;
    }

    @Override
    protected ContentProposal createProposal(TypeEntry typeEntry) {
        TypeEntry resolvedEntry = (TypeEntry)ImportHelper.resolveImport((String)typeEntry.getTypeName(), (EObject)this.supplier.get(), name -> this.typeResolver.apply(this.getTypeLibrary(), (String)name), name -> null);
        if (resolvedEntry == null) {
            return new ImportContentProposal(typeEntry.getTypeName(), typeEntry.getTypeName(), typeEntry.getFullTypeName(), typeEntry.getFullTypeName());
        }
        if (resolvedEntry == typeEntry) {
            return new ContentProposal(typeEntry.getTypeName(), typeEntry.getTypeName(), typeEntry.getFullTypeName());
        }
        return new ContentProposal(typeEntry.getFullTypeName(), typeEntry.getTypeName(), typeEntry.getFullTypeName());
    }
}

