/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval;

import java.util.Map;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.impl.EvaluatorFactoryRegistryImpl;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;

public interface EvaluatorFactory {
    public static final String DEFAULT_VARIANT = "default";

    default public boolean canHandle(Object source) {
        return true;
    }

    public Evaluator createEvaluator(Object var1, Variable<?> var2, Iterable<Variable<?>> var3, Evaluator var4);

    public static <T> Evaluator createEvaluator(T source, Class<? extends T> sourceClass, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        return EvaluatorFactory.createEvaluator(source, sourceClass, DEFAULT_VARIANT, context, variables, parent);
    }

    public static <T> Evaluator createEvaluator(T source, Class<? extends T> sourceClass, String variant, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        EvaluatorFactory factory = Registry.INSTANCE.getFactory(variant, sourceClass);
        if (factory != null) {
            return factory.createEvaluator(source, context, variables, parent);
        }
        return null;
    }

    public static interface Registry {
        public static final Registry INSTANCE = new EvaluatorFactoryRegistryImpl();

        public EvaluatorFactory getFactory(String var1, Class<?> var2);

        public EvaluatorFactory registerFactory(String var1, Class<?> var2, EvaluatorFactory var3);

        public Map<String, Map<Class<?>, EvaluatorFactory>> getVariantClassToFactoryMap();
    }
}

