/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.edit;

import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.fordiac.ide.model.commands.change.ChangeAttributeDeclarationCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeAttributeTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDataTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.commands.change.ConfigureFBCommand;
import org.eclipse.fordiac.ide.model.commands.change.UpdateFBTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.UpdateInternalFBCommand;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.edit.AbstractTypeEntryAdapter;
import org.eclipse.fordiac.ide.model.edit.ITypeEntryEditor;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.search.types.AttributeTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.search.types.BlockTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.search.types.DataTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.typelibrary.AttributeTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SubAppTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.part.FileEditorInput;

public class TypeEntryAdapter
extends AbstractTypeEntryAdapter {
    private INavigationLocation location;
    private boolean blockUpdates;

    public TypeEntryAdapter(ITypeEntryEditor editor, IPartService partService) {
        super(editor, partService);
    }

    @Override
    protected ITypeEntryEditor getEditor() {
        return (ITypeEntryEditor)super.getEditor();
    }

    @Override
    protected void checkEditorActivated() {
        super.checkEditorActivated();
        this.performLocationRestore();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.location != null) {
            this.location.dispose();
            this.location = null;
        }
    }

    @Override
    protected void reloadEditorType() {
        this.getEditor().reloadType();
    }

    /*
     * WARNING - void declaration
     */
    public void notifyChanged(Notification notification) {
        void feature;
        super.notifyChanged(notification);
        if (this.blockUpdates) {
            return;
        }
        Object object = notification.getFeature();
        if (!(object instanceof String)) {
            return;
        }
        String string = (String)object;
        switch (feature) {
            case "TYPE_ENTRY_FILE_CONTENT_FEATURE": {
                this.handleFileContentChange();
                break;
            }
            case "TYPE_ENTRY_FILE_FEATURE": {
                Object object2 = notification.getNewValue();
                if (!(object2 instanceof IFile)) break;
                IFile newFile = (IFile)object2;
                FileEditorInput newEditorInput = new FileEditorInput(newFile);
                Display.getDefault().execute(() -> {
                    if (!this.editorClosed() && !newEditorInput.equals((Object)this.getEditor().getEditorInput())) {
                        this.getEditor().setInput((IEditorInput)newEditorInput);
                    }
                });
                break;
            }
            case "TYPE_ENTRY_EDITOR_INSTANCE_UPDATE_FEATURE": {
                Assert.isTrue((boolean)(notification.getNotifier() instanceof TypeEntry));
                Assert.isTrue((boolean)(notification.getNewValue() instanceof TypeEntry));
                TypeEntry typeEntry = (TypeEntry)notification.getNewValue();
                this.handleDependencyUpdate(typeEntry);
                break;
            }
        }
    }

    public void setBlockUpdates(boolean blockupdates) {
        this.blockUpdates = blockupdates;
    }

    private void handleDependencyUpdate(TypeEntry typeEntry) {
        LibraryElement editedElement = (LibraryElement)this.getEditor().getAdapter(LibraryElement.class);
        if (editedElement != null) {
            Display.getDefault().asyncExec(() -> {
                if (this.editorClosed()) {
                    return;
                }
                if (typeEntry instanceof FBTypeEntry || typeEntry instanceof SubAppTypeEntry) {
                    this.handleBlockTypeDependencyUpdate(editedElement, typeEntry);
                }
                if (typeEntry instanceof DataTypeEntry) {
                    DataTypeEntry dtEntry = (DataTypeEntry)typeEntry;
                    TypeEntryAdapter.handleDataTypeEntryUpdate(editedElement, dtEntry);
                }
                if (typeEntry instanceof AttributeTypeEntry) {
                    AttributeTypeEntry atEntry = (AttributeTypeEntry)typeEntry;
                    TypeEntryAdapter.handleAttributeTypeEntryUpdate(editedElement, atEntry);
                }
            });
        }
    }

    private static void handleAttributeTypeEntryUpdate(LibraryElement editedElement, AttributeTypeEntry atEntry) {
        AttributeTypeInstanceSearch search = new AttributeTypeInstanceSearch(editedElement, atEntry);
        List result = search.performSearch();
        result.forEach(at -> {
            if (at instanceof ConfigurableObject) {
                ConfigurableObject co = (ConfigurableObject)at;
                Attribute attribute = co.getAttribute(atEntry.getTypeName());
                ChangeAttributeDeclarationCommand.forEntry((Attribute)attribute, (AttributeTypeEntry)atEntry).execute();
            }
        });
    }

    private void handleBlockTypeDependencyUpdate(LibraryElement editedElement, TypeEntry typeEntry) {
        BlockTypeInstanceSearch search = new BlockTypeInstanceSearch(editedElement, typeEntry);
        this.checkEditorLocation();
        search.performSearch().stream().filter(BlockFBNetworkElement.class::isInstance).map(BlockFBNetworkElement.class::cast).map(fbnEl -> {
            if (fbnEl instanceof FB) {
                FB fb = (FB)fbnEl;
                if (fbnEl.eContainer() == editedElement) {
                    return new UpdateInternalFBCommand(fb, typeEntry);
                }
            }
            if (fbnEl.isMapped() && fbnEl.getMapping().getTo() == fbnEl) {
                return null;
            }
            return new UpdateFBTypeCommand(fbnEl, typeEntry);
        }).filter(Objects::nonNull).filter(command -> command.canExecute()).forEach(command -> command.execute());
        if (this.isActiveEditor()) {
            this.performLocationRestore();
        }
    }

    private void checkEditorLocation() {
        ITypeEntryEditor iTypeEntryEditor;
        if (this.location == null && this.getEditor().getAdapter(FBNetwork.class) == null && this.getEditor().getAdapter(FBNetworkElement.class) != null && (iTypeEntryEditor = this.getEditor()) instanceof INavigationLocationProvider) {
            INavigationLocationProvider provider = (INavigationLocationProvider)iTypeEntryEditor;
            this.location = provider.createNavigationLocation();
        }
    }

    private static void handleDataTypeEntryUpdate(LibraryElement editedElement, DataTypeEntry dtEntry) {
        DataTypeInstanceSearch search = new DataTypeInstanceSearch(editedElement, dtEntry);
        AnyDerivedType dataType = dtEntry.getType();
        search.performSearch().stream().map(item -> {
            if (item instanceof Attribute) {
                Attribute attr = (Attribute)item;
                return ChangeAttributeTypeCommand.forDataType((Attribute)attr, (DataType)dataType);
            }
            if (item instanceof VarDeclaration) {
                VarDeclaration varDecl = (VarDeclaration)item;
                return ChangeDataTypeCommand.forDataType((IInterfaceElement)varDecl, (DataType)dataType);
            }
            if (item instanceof ConfigurableFB) {
                ConfigurableFB configFB = (ConfigurableFB)item;
                if (item instanceof StructManipulator) {
                    StructManipulator structMan = (StructManipulator)item;
                    if (dataType instanceof StructuredType) {
                        StructuredType struct = (StructuredType)dataType;
                        return new ChangeStructCommand(structMan, (DataType)struct);
                    }
                }
                return new ConfigureFBCommand(configFB, (DataType)dataType);
            }
            return null;
        }).filter(Objects::nonNull).filter(command -> command.canExecute()).forEach(command -> command.execute());
    }

    private void performLocationRestore() {
        if (this.location != null) {
            this.location.restoreLocation();
            this.location.dispose();
            this.location = null;
        }
    }
}

