/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.gef.commands.Command;

public class ChangeAttributeDeclarationTypeCommand
extends Command
implements ScopedCommand {
    private final AttributeDeclaration attributeDeclaration;
    private AnyDerivedType oldType;
    private AnyDerivedType newType;

    public ChangeAttributeDeclarationTypeCommand(AttributeDeclaration attributeDeclaration) {
        this.attributeDeclaration = Objects.requireNonNull(attributeDeclaration);
        this.createNewType();
    }

    private void createNewType() {
        if (this.attributeDeclaration.getType() instanceof StructuredType) {
            DirectlyDerivedType directlyDerivedType = DataFactory.eINSTANCE.createDirectlyDerivedType();
            directlyDerivedType.setBaseType((DataType)IecTypes.ElementaryTypes.STRING);
            directlyDerivedType.setInitialValue("");
            this.newType = directlyDerivedType;
        } else if (this.attributeDeclaration.getType() instanceof DirectlyDerivedType) {
            this.newType = DataFactory.eINSTANCE.createStructuredType();
        }
        this.newType.setName(this.attributeDeclaration.getName());
    }

    public final void execute() {
        this.oldType = this.attributeDeclaration.getType();
        this.attributeDeclaration.setType(this.newType);
    }

    public final void undo() {
        this.attributeDeclaration.setType(this.oldType);
    }

    public final void redo() {
        this.attributeDeclaration.setType(this.newType);
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.attributeDeclaration);
    }
}

