/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.builder;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.fordiac.ide.export.AbstractExporter;
import org.eclipse.fordiac.ide.export.IExportFilter;
import org.eclipse.fordiac.ide.export.Messages;
import org.eclipse.fordiac.ide.export.utils.ExportFilterUtil;
import org.eclipse.fordiac.ide.model.buildpath.Buildpath;
import org.eclipse.fordiac.ide.model.buildpath.BuildpathAttributes;
import org.eclipse.fordiac.ide.model.buildpath.SourceFolder;
import org.eclipse.fordiac.ide.model.buildpath.util.BuildpathUtil;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class ExportBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.fordiac.ide.export.builder";
    private static final String FORTE_NG_FILTER_ID = "org.eclipse.fordiac.ide.export.exportFilter.forteNg";
    private static final Set<String> fileTypes = Set.of("fbt", "adp", "dtp", "gcf");
    private boolean enableAutoExport;
    private String outputDirectory;
    private Optional<IConfigurationElement> exportFilterConfiguration;
    private Exporter exporter;
    List<IFile> exportees = new ArrayList<IFile>();

    protected void startupOnInitialize() {
        this.createOutputFolder();
        this.initializePreferences();
        this.addPreferenceListener();
        super.startupOnInitialize();
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IResourceDelta root = this.getDelta(this.getProject());
        if (!this.enableAutoExport || this.exporter == null || root == null) {
            return new IProject[0];
        }
        this.exportees.clear();
        this.addResourceDeltas(this.exportees, root);
        if (!this.exportees.isEmpty()) {
            this.exporter.exportElements(monitor, this.exportees);
        }
        return new IProject[0];
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        if (this.outputDirectory == null || this.outputDirectory.isEmpty()) {
            return;
        }
        IFolder folder = this.getProject().getFolder(this.outputDirectory);
        if (folder.exists()) {
            folder.accept(resource -> {
                IFolder root;
                if (resource instanceof IFolder && (root = (IFolder)resource).equals((Object)folder)) {
                    return true;
                }
                resource.delete(this.enableAutoExport, monitor);
                return true;
            });
        }
        super.clean(monitor);
    }

    private void initializePreferences() {
        this.enableAutoExport = this.getProjectPreferenceNode().getBoolean("ENABLE_TYPE_EXPORT", false);
        if (!this.enableAutoExport) {
            return;
        }
        this.outputDirectory = this.getProjectPreferenceNode().get("OUTPUT_FOLDER", "out");
        String exportFilterID = this.getProjectPreferenceNode().get("EXPORT_FILTER_ID", "");
        this.exportFilterConfiguration = ExportFilterUtil.getExportFilter(exportFilterID);
        this.updateExporter();
    }

    private void updateExporter() {
        if (this.exportFilterConfiguration.isPresent() && !this.outputDirectory.isEmpty()) {
            IFolder destinationDirectory = this.getProject().getFolder(this.outputDirectory);
            this.exporter = this.exportFilterConfiguration.get().getAttribute("id").equals(FORTE_NG_FILTER_ID) && destinationDirectory.exists() ? new Exporter(this.exportFilterConfiguration.get(), destinationDirectory.getLocation().toOSString(), true, true) : new Exporter(this.exportFilterConfiguration.get(), destinationDirectory.getLocation().toOSString(), true, false);
        }
    }

    private void addPreferenceListener() {
        this.getProjectPreferenceNode().addPreferenceChangeListener(evt -> {
            switch (evt.getKey()) {
                case "ENABLE_TYPE_EXPORT": {
                    this.enableAutoExport = this.getProjectPreferenceNode().getBoolean("ENABLE_TYPE_EXPORT", false);
                    break;
                }
                case "OUTPUT_FOLDER": {
                    this.outputDirectory = this.getProjectPreferenceNode().get("OUTPUT_FOLDER", "");
                    break;
                }
                case "EXPORT_FILTER_ID": {
                    this.exportFilterConfiguration = ExportFilterUtil.getExportFilter(this.getProjectPreferenceNode().get("EXPORT_FILTER_ID", ""));
                    break;
                }
            }
            this.updateExporter();
        });
    }

    private void addResourceDeltas(List<IFile> exportees, IResourceDelta deltas) {
        IResourceDelta[] iResourceDeltaArray = deltas.getAffectedChildren(260);
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file;
            IResourceDelta delta = iResourceDeltaArray[n2];
            IResource iResource = delta.getResource();
            if (iResource instanceof IFile && this.isExportable(file = (IFile)iResource)) {
                exportees.add(file);
            } else if (delta.getResource() instanceof IFolder) {
                this.addResourceDeltas(exportees, delta);
            }
            ++n2;
        }
    }

    private boolean isExportable(IFile file) {
        if (file.getFileExtension() != null && fileTypes.contains(file.getFileExtension())) {
            Buildpath buildpath = BuildpathUtil.loadBuildpath((IProject)this.getProject());
            Optional sourceFolder = BuildpathUtil.findSourceFolder((Buildpath)buildpath, (IResource)file);
            return sourceFolder.isPresent() && ExportBuilder.getExportAttributeValue((SourceFolder)sourceFolder.get());
        }
        return false;
    }

    private IEclipsePreferences getProjectPreferenceNode() {
        ProjectScope projectScope = new ProjectScope(this.getProject());
        return projectScope.getNode("org.eclipse.fordiac.ide.export");
    }

    private static boolean getExportAttributeValue(SourceFolder folder) {
        String attributeValue = BuildpathAttributes.getAttributeValue((List)folder.getAttributes(), (String)"export");
        return !attributeValue.isEmpty() && Boolean.parseBoolean(attributeValue);
    }

    private void createOutputFolder() {
        IFolder folder = this.getProject().getFolder("out");
        if (!folder.exists()) {
            try {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                FordiacLogHelper.logError((String)MessageFormat.format(Messages.ExportBuilder_CannotCreateDirectory, "out"));
            }
        }
        try {
            folder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
    }

    private class Exporter
    extends AbstractExporter {
        protected Exporter(IConfigurationElement filterConfig, String outputDirectory, boolean overwriteWithoutWarning, boolean enableCMakeLists) {
            super(filterConfig, outputDirectory, overwriteWithoutWarning, enableCMakeLists);
        }

        @Override
        protected void showErrorWarningSummary(IExportFilter filter) {
            filter.getErrors().stream().forEach(FordiacLogHelper::logError);
        }

        @Override
        protected void processError(String errorMessage) {
            FordiacLogHelper.logError((String)errorMessage);
        }

        @Override
        protected boolean exportIsCanceled(IProgressMonitor monitor) {
            return super.exportIsCanceled(monitor) || ExportBuilder.this.isInterrupted();
        }
    }
}

