/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.view.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.fordiac.ide.debug.ui.view.editparts.AbstractDebugInterfaceValueEditPart;
import org.eclipse.fordiac.ide.debug.ui.view.editparts.InterfaceValueEntity;
import org.eclipse.fordiac.ide.debug.ui.view.policies.InterfaceValueDirectEditPolicy;
import org.eclipse.fordiac.ide.gef.editparts.FigureCellEditorLocator;
import org.eclipse.fordiac.ide.gef.editparts.InitialValueDirectEditManager;
import org.eclipse.fordiac.ide.gef.editparts.LabelDirectEditManager;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.CellEditorLocator;

public class InterfaceValueEditPart
extends AbstractDebugInterfaceValueEditPart {
    public InterfaceValueEntity getModel() {
        return (InterfaceValueEntity)super.getModel();
    }

    @Override
    protected IFigure createFigure() {
        Label l = (Label)super.createFigure();
        l.setText(this.getModel().getVariable().getValue().toString());
        return l;
    }

    @Override
    protected void createEditPolicies() {
        if (this.getModel().getDebugTarget() != null) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new InterfaceValueDirectEditPolicy());
        }
    }

    @Override
    protected IInterfaceElement getInterfaceElement() {
        return this.getModel().getInterfaceElement();
    }

    public void performRequest(Request request) {
        if ((request.getType() == "direct edit" || request.getType() == "open") && this.getModel().getDebugTarget() != null) {
            this.performDirectEdit();
        } else {
            super.performRequest(request);
        }
    }

    private void performDirectEdit() {
        IInterfaceElement iInterfaceElement = this.getModel().getInterfaceElement();
        if (iInterfaceElement instanceof VarDeclaration) {
            VarDeclaration varDecl = (VarDeclaration)iInterfaceElement;
            new InitialValueDirectEditManager((GraphicalEditPart)this, (CellEditorLocator)new FigureCellEditorLocator((IFigure)this.getLabelFigure()), varDecl, this.getLabelFigure().getText()).show();
        } else {
            new LabelDirectEditManager((GraphicalEditPart)this, this.getLabelFigure()).show();
        }
    }

    public void updateValue() {
        if (this.isActive() && this.getFigure() != null) {
            this.getLabelFigure().setText(this.getModel().getVariable().toString());
            this.refreshVisuals();
        }
    }
}

