/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.replaydebugging.ui;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentLaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.typelibrary.SystemEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    public static final String ATTR_TRACE_PATH = "org.eclipse.fordiac.ide.debug.replaydebugging.ATTR_TRACE_PATH";
    private static final String ATTR_TRACE_PATH_DEFAULT = "";
    private static final String SELECT_PATH_DIALOG_TEXT = "Select trace directory";
    private static final String BROWSE_BUTTON_TEXT = "Browse Trace Path";
    private static final String GROUP_TEXT = "Select Components";
    private static final String SYSTEM_SELECTION_BUTTON_TEXT = "Browse System";
    private Text systemText;
    private CheckboxTreeViewer selectionTree;
    private Composite component;
    private Text tracerPathText;

    public void createControl(Composite parent) {
        this.component = new Composite(parent, 4);
        this.component.setLayout((Layout)new GridLayout(1, false));
        this.createPathSelectionComponent();
        this.createSelectionComponent();
    }

    private void createPathSelectionComponent() {
        final Composite pathSelectionComposite = new Composite(this.component, 4);
        pathSelectionComposite.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)pathSelectionComposite);
        Button browseButton = new Button(pathSelectionComposite, 8);
        browseButton.setText(BROWSE_BUTTON_TEXT);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(pathSelectionComposite.getShell());
                dialog.setText(LaunchConfigurationTab.SELECT_PATH_DIALOG_TEXT);
                String selected = dialog.open();
                if (selected != null) {
                    LaunchConfigurationTab.this.tracerPathText.setText(selected);
                }
            }
        });
        this.tracerPathText = new Text(pathSelectionComposite, 2048);
        this.tracerPathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.tracerPathText.addModifyListener(e -> this.updateLaunchConfigurationDialog());
    }

    protected void createSelectionComponent() {
        Group group = new Group(this.component, 2048);
        group.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)group);
        group.setText(GROUP_TEXT);
        Composite sytemSelectionComposite = new Composite((Composite)group, 0);
        sytemSelectionComposite.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)sytemSelectionComposite);
        Button systemButton = new Button(sytemSelectionComposite, 2048);
        systemButton.setText(SYSTEM_SELECTION_BUTTON_TEXT);
        systemButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleSystemButtonSelected()));
        this.systemText = new Text(sytemSelectionComposite, 2048);
        this.systemText.setEnabled(false);
        this.systemText.addModifyListener(e -> this.scheduleUpdateJob());
        this.systemText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.selectionTree = new CheckboxTreeViewer((Composite)group, 68354);
        this.selectionTree.setContentProvider((IContentProvider)new SelectionContentProvider());
        this.selectionTree.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new SelectionLabelProvider()));
        this.selectionTree.addCheckStateListener((ICheckStateListener)new SelectionCheckStateListener());
        this.selectionTree.setAutoExpandLevel(2);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.selectionTree.getTree());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(ATTR_TRACE_PATH, ATTR_TRACE_PATH_DEFAULT);
        configuration.removeAttribute("org.eclipse.fordiac.ide.deployment.debug.system");
        configuration.removeAttribute("org.eclipse.fordiac.ide.deployment.debug.selection");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.tracerPathText.setText(configuration.getAttribute(ATTR_TRACE_PATH, ATTR_TRACE_PATH_DEFAULT));
            this.systemText.setText(configuration.getAttribute("org.eclipse.fordiac.ide.deployment.debug.system", ATTR_TRACE_PATH_DEFAULT));
            AutomationSystem system = DeploymentLaunchConfigurationAttributes.getSystem((ILaunchConfiguration)configuration);
            this.selectionTree.setInput((Object)system);
            this.selectionTree.setCheckedElements(DeploymentLaunchConfigurationAttributes.getSelection((ILaunchConfiguration)configuration, (AutomationSystem)system).toArray());
        }
        catch (CoreException e) {
            this.systemText.setText(ATTR_TRACE_PATH_DEFAULT);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(ATTR_TRACE_PATH, this.tracerPathText.getText());
        configuration.setAttribute("org.eclipse.fordiac.ide.deployment.debug.system", this.systemText.getText());
        configuration.setAttribute("org.eclipse.fordiac.ide.deployment.debug.selection", Stream.of(this.selectionTree.getCheckedElements()).filter(INamedElement.class::isInstance).map(INamedElement.class::cast).map(INamedElement::getQualifiedName).collect(Collectors.toSet()));
    }

    public String getName() {
        return "Replay Debugging";
    }

    public Control getControl() {
        return this.component;
    }

    public void dispose() {
    }

    public String getErrorMessage() {
        return null;
    }

    public String getMessage() {
        return null;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.tracerPathText.getText() != null;
    }

    public boolean canSave() {
        return this.isValid(null);
    }

    public void launched(ILaunch launch) {
    }

    public Image getImage() {
        return null;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    private void handleSystemButtonSelected() {
        Object object;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        IResource initialResource = this.getSystemResource();
        if (initialResource != null) {
            dialog.setInitialSelection((Object)initialResource);
        }
        dialog.setAllowMultiple(false);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IResource resource = (IResource)Adapters.adapt((Object)element, IResource.class);
                try {
                    return LaunchConfigurationTab.this.filterTargetResource(resource);
                }
                catch (CoreException e) {
                    return false;
                }
            }
        });
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length > 0 && (object = result[0]) instanceof IResource) {
            IResource resource = (IResource)object;
            String resourceString = resource.getFullPath().toString();
            this.systemText.setText(resourceString);
            this.handleSystemUpdated();
        }
    }

    public IResource getSystemResource() {
        String systemString = this.systemText.getText();
        if (systemString != null && !systemString.isEmpty()) {
            return ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(systemString));
        }
        return null;
    }

    protected void handleSystemUpdated() {
        this.updateLaunchConfigurationDialog();
        AutomationSystem system = this.getSystem();
        this.selectionTree.setInput((Object)system);
        if (system == null) {
            return;
        }
        system.getSystemConfiguration().getDevices().forEach(device -> {
            boolean bl = this.selectionTree.setSubtreeChecked(device, true);
        });
    }

    protected boolean filterTargetResource(IResource resource) throws CoreException {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            return "SYS".equalsIgnoreCase(file.getFileExtension());
        }
        if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                if (this.filterTargetResource(child)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    public AutomationSystem getSystem() {
        IFile systemFile;
        TypeEntry typeEntry;
        IResource iResource = this.getSystemResource();
        if (iResource instanceof IFile && (typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(systemFile = (IFile)iResource)) instanceof SystemEntry) {
            SystemEntry systemEntry = (SystemEntry)typeEntry;
            return systemEntry.getSystem();
        }
        return null;
    }

    private class SelectionCheckStateListener
    implements ICheckStateListener {
        private SelectionCheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            LaunchConfigurationTab.this.selectionTree.setSubtreeChecked(element, event.getChecked());
            if (element instanceof Resource) {
                Resource resource = (Resource)element;
                if (!event.getChecked()) {
                    LaunchConfigurationTab.this.selectionTree.setChecked((Object)resource.eContainer(), false);
                }
            }
            LaunchConfigurationTab.this.updateLaunchConfigurationDialog();
        }
    }

    public static class SelectionContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof AutomationSystem) {
                AutomationSystem system = (AutomationSystem)inputElement;
                return system.getSystemConfiguration().getDevices().toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Device) {
                Device device = (Device)parentElement;
                return device.getResource().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof Resource) {
                Resource resource = (Resource)element;
                return resource.eContainer();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            Device device;
            return element instanceof Device && !(device = (Device)element).getResource().isEmpty();
        }
    }

    private static class SelectionLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private static final StyledString.Styler ERROR_STYLER = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.strikeout = true;
            }
        };

        private SelectionLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof INamedElement) {
                INamedElement namedElement = (INamedElement)element;
                return new StyledString(namedElement.getName(), (StyledString.Styler)(namedElement.eResource() == null ? ERROR_STYLER : null));
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof Device) {
                return FordiacImage.ICON_DEVICE.getImage();
            }
            if (element instanceof Resource) {
                Resource resource = (Resource)element;
                if (resource.isDeviceTypeResource()) {
                    return FordiacImage.ICON_FIRMWARE_RESOURCE.getImage();
                }
                return FordiacImage.ICON_RESOURCE.getImage();
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

