/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts.dialogs;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.Utils;
import org.eclipse.fordiac.ide.contractSpec.Unit;
import org.eclipse.fordiac.ide.contracts.EventOccurrence;
import org.eclipse.fordiac.ide.contracts.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EventOccurrencesDialog
extends MessageDialog {
    private static final int OK = 0;
    private static final int LOAD_FILE = 1;
    private static final int LOAD_EXAMPLE = 2;
    private final Shell parentShell;
    private Text inputText;
    private List<EventOccurrence> eventOccurrences;
    private String formatError;

    public EventOccurrencesDialog(Shell parentShell) {
        super(parentShell, Messages.EventOccurrence_Title, null, Messages.EventOccurrence_Info, 2, 0, new String[]{Messages.ContractCheck_OK, Messages.EventOccurrence_LoadFromFile, Messages.EventOccurrence_LoadExample, Messages.EventOccurrence_Cancel});
        this.parentShell = parentShell;
    }

    public List<EventOccurrence> getEventOccurrences() {
        return this.eventOccurrences;
    }

    protected Control createCustomArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(4, 4, true, false);
        this.inputText = new Text(parent, 578);
        this.inputText.setLayoutData((Object)gridData);
        gridData.heightHint = 10 * this.inputText.getLineHeight();
        return this.dialogArea;
    }

    private void loadFromFile() {
        FileDialog dialog = new FileDialog(this.parentShell);
        String fname = dialog.open();
        if (fname == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream fstream = new FileInputStream(fname);){
                String ftext = new String(fstream.readAllBytes());
                this.inputText.setText(ftext);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadExample() {
        this.inputText.setText("App.SubApp.Q 8ms\nApp.SubApp3.EO 10ns\nApp.SubApp2.EI 25us\nApp.SubApp.INIT 1s\nApp.SubApp.EI 6ms ID3\nApp.SubApp4.P 4ms SomeID\n");
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.eventOccurrences = this.createEOList(this.inputText.getText());
                if (this.formatError != null) {
                    MessageDialog.openError((Shell)this.parentShell, (String)Messages.EventOccurrence_Error_Title, (String)(Messages.EventOccurrence_Error_Info + this.formatError));
                    break;
                }
                super.buttonPressed(buttonId);
                break;
            }
            case 1: {
                this.loadFromFile();
                break;
            }
            case 2: {
                this.loadExample();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    private List<EventOccurrence> createEOList(String text) {
        this.formatError = null;
        ArrayList<EventOccurrence> eos = new ArrayList<EventOccurrence>();
        String[] lines = text.split("\n");
        int i = 0;
        while (i < lines.length) {
            if (!lines[i].isBlank()) {
                EventOccurrence eo = this.parseLine(lines[i], i);
                if (eo == null) {
                    return List.of();
                }
                eos.add(eo);
            }
            ++i;
        }
        return eos;
    }

    private EventOccurrence parseLine(String line, int lineIdx) {
        double value;
        Unit unit;
        String eventID;
        String[] parts = line.split(" ");
        if (parts.length == 2) {
            eventID = "";
        } else if (parts.length == 3) {
            eventID = parts[2].strip();
        } else {
            this.formatError = Messages.EventOccurrence_Format_Error_General.formatted(lineIdx);
            return null;
        }
        String eventName = parts[0].strip();
        String eventTime = parts[1].strip();
        if (eventTime.endsWith("ns")) {
            unit = Unit.NS;
        } else if (eventTime.endsWith("us")) {
            unit = Unit.US;
        } else if (eventTime.endsWith("ms")) {
            unit = Unit.MS;
        } else if (eventTime.endsWith("s")) {
            unit = Unit.S;
        } else {
            this.formatError = Messages.EventOccurrence_Format_Error_Time.formatted(lineIdx);
            return null;
        }
        String part = eventTime.substring(0, eventTime.length() - unit.getLiteral().length());
        try {
            value = Double.parseDouble(part);
        }
        catch (Exception e) {
            this.formatError = Messages.EventOccurrence_Format_Error_Number.formatted(lineIdx, part);
            return null;
        }
        if (value < 0.0) {
            this.formatError = Messages.EventOccurrence_Format_Error_Negative.formatted(lineIdx);
            return null;
        }
        double time = Utils.getInNs((double)value, (Unit)unit);
        return new EventOccurrence(eventName, time, eventID);
    }
}

