/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.Utils;
import org.eclipse.fordiac.ide.contractSpec.CausalRelation;
import org.eclipse.fordiac.ide.contractSpec.EventExpr;
import org.eclipse.fordiac.ide.contractSpec.EventSpec;
import org.eclipse.fordiac.ide.contractSpec.Interval;
import org.eclipse.fordiac.ide.contractSpec.RepetitionOptions;
import org.eclipse.fordiac.ide.contractSpec.TimeExpr;
import org.eclipse.fordiac.ide.contracts.CInterval;
import org.eclipse.fordiac.ide.contracts.ContractComponent;
import org.eclipse.fordiac.ide.contracts.Messages;
import org.eclipse.fordiac.ide.contracts.helpers.ContractUtils;

class ContractRule {
    private Type type;
    private boolean fulfilled;
    private ContractComponent owner;
    private List<String> inputs;
    private List<String> outputs;
    private CInterval interval;
    private CInterval offset;
    private double jitter;
    private boolean inputIsSequence;
    private boolean outputIsSequence;
    private boolean once;
    private SlidingWindow nOutOfM;
    private CausalRelation causalRelation;

    ContractRule(String event, CInterval interval) {
        this.type = Type.SINGLE_EVENT;
        this.interval = interval;
        this.outputs = List.of(event);
    }

    ContractRule(EventSpec event, Interval interval) {
        this(Type.SINGLE_EVENT, interval);
        this.setEventSingle(event);
    }

    ContractRule(String event, CInterval interval, CInterval offset, double jitter) {
        this.type = Type.REPETITION;
        this.interval = interval;
        this.outputs = List.of(event);
        this.offset = offset;
        this.jitter = jitter;
    }

    ContractRule(EventSpec event, Interval interval, RepetitionOptions options) {
        this(Type.REPETITION, interval);
        this.setEventSingle(event);
        this.jitter = 0.0;
        if (options != null) {
            if (options.getJitter() != null) {
                this.jitter = Utils.timeExpr2Ns((TimeExpr)options.getJitter().getTime()).orElse(0.0);
            }
            if (options.getOffset() != null && options.getOffset().getInterval() != null) {
                this.offset = new CInterval(options.getOffset().getInterval());
            }
        }
        if (this.offset == null) {
            this.offset = new CInterval('[', 0.0, 0.0, ']');
        }
    }

    ContractRule(Type type, EventExpr inputs, EventExpr outputs, Interval interval) {
        this(type, interval);
        this.setEventExpr(inputs, true);
        this.inputIsSequence = inputs.isSequence();
        this.setEventExpr(outputs, false);
        this.outputIsSequence = outputs.isSequence();
    }

    ContractRule(Type type, EventSpec input, EventSpec output, Interval interval) {
        this(type, interval);
        this.inputs = List.of(input.getPort().getName());
        this.outputs = List.of(output.getPort().getName());
    }

    private ContractRule(Type type, Interval interval) {
        this.type = type;
        this.interval = new CInterval(interval);
    }

    private void setEventSingle(EventSpec event) {
        if (event.getPort().getIsInput() != 0) {
            this.inputs = List.of(ContractRule.getEventName(event));
        } else {
            this.outputs = List.of(ContractRule.getEventName(event));
        }
    }

    private void setEventExpr(EventExpr expr, boolean isInput) {
        if (expr.getEvent() != null) {
            this.setEventSingle(expr.getEvent());
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (EventSpec eSpec : expr.getEvents().getEvents()) {
            names.add(eSpec.getPort().getName());
        }
        if (isInput) {
            this.inputs = names;
        } else {
            this.outputs = names;
        }
    }

    private static String getEventName(EventSpec event) {
        return event.getPort().getName();
    }

    boolean isAssumption() {
        return (this.type == Type.SINGLE_EVENT || this.type == Type.REPETITION) && this.outputs == null;
    }

    private List<String> getPortNames() {
        return this.isAssumption() ? this.getInputs() : this.getOutputs();
    }

    String getSinglePort() {
        return this.isAssumption() ? this.getInputs().getFirst() : this.getOutputs().getFirst();
    }

    public String toString() {
        return switch (this.type) {
            case Type.SINGLE_EVENT -> ContractUtils.createSingleEvent(this.getPortNames(), this.interval.toString());
            case Type.REPETITION -> {
                String o = this.offset.getLowerBound() == 0.0 && this.offset.getUpperBound() == 0.0 ? null : this.offset.toString();
                String j = this.jitter == 0.0 ? null : Utils.nsToString((double)this.jitter);
                yield ContractUtils.createRepetition(this.getPortNames(), this.interval.toString(), o, j);
            }
            case Type.REACTION -> ContractUtils.createReaction(this.inputs, this.outputs, this.inputIsSequence, this.outputIsSequence, this.interval.toString(), this.once, this.nOutOfM.n(), this.nOutOfM.outOf());
            case Type.AGE -> ContractUtils.createAge(this.inputs, this.outputs, this.inputIsSequence, this.outputIsSequence, this.interval.toString(), this.once, this.nOutOfM.n(), this.nOutOfM.outOf());
            case Type.CAUSAL_REACTION -> ContractUtils.createCausalReaction(this.inputs.get(0), this.outputs.get(0), this.interval.toString());
            case Type.CAUSAL_AGE -> ContractUtils.createCausalAge(this.inputs.get(0), this.outputs.get(0), this.interval.toString());
            default -> throw new MatchException(null, null);
        };
    }

    Type getType() {
        return this.type;
    }

    void setType(Type type) {
        this.type = type;
    }

    boolean isFulFilled() {
        return this.fulfilled;
    }

    void setFulFilled(boolean fulfilled) {
        this.fulfilled = fulfilled;
    }

    ContractComponent getOwner() {
        return this.owner;
    }

    void setOwner(ContractComponent owner) {
        this.owner = owner;
    }

    List<String> getInputs() {
        return this.inputs;
    }

    void setInputs(List<String> inputs) {
        this.inputs = inputs;
    }

    List<String> getOutputs() {
        return this.outputs;
    }

    void setOutputs(List<String> outputs) {
        this.outputs = outputs;
    }

    CInterval getInterval() {
        return this.interval;
    }

    void setInterval(CInterval interval) {
        this.interval = interval;
    }

    double getJitter() {
        return this.jitter;
    }

    void setJitter(double jitter) {
        this.jitter = jitter;
    }

    CInterval getOffset() {
        return this.offset;
    }

    void setOffset(CInterval offset) {
        this.offset = offset;
    }

    boolean inputIsSequence() {
        return this.inputIsSequence;
    }

    boolean outputIsSequence() {
        return this.outputIsSequence;
    }

    boolean isOnce() {
        return this.once;
    }

    void setOnce(boolean once) {
        this.once = once;
    }

    SlidingWindow getNOutOfM() {
        return this.nOutOfM;
    }

    void setNOutOfM(SlidingWindow nOutOfM) {
        this.nOutOfM = nOutOfM;
    }

    CausalRelation getCausalRelation() {
        return this.causalRelation;
    }

    void setCausalRelation(CausalRelation causalRelation) {
        this.causalRelation = causalRelation;
    }

    record SlidingWindow(int n, int outOf) {
    }

    static enum Type {
        SINGLE_EVENT,
        REPETITION,
        REACTION,
        AGE,
        CAUSAL_REACTION,
        CAUSAL_AGE;


        public String toString() {
            return switch (this) {
                case SINGLE_EVENT -> Messages.ContractRuleSingleEvent;
                case REPETITION -> Messages.ContractRuleRepetition;
                case REACTION -> Messages.ContractRuleReaction;
                case AGE -> Messages.ContractRuleAge;
                case CAUSAL_REACTION -> Messages.ContractRuleCausalReaction;
                case CAUSAL_AGE -> Messages.ContractRuleCausalAge;
                default -> throw new MatchException(null, null);
            };
        }
    }
}

