/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.gef.filters.AttributeFilter;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class InfoPropertySection
extends AbstractSection {
    private ConfigurableObject obj;
    private boolean checked = false;
    private static final int HORIZONTAL_INDENT = 10;
    private Composite parent;
    private Combo sortCombo;
    private Label numbConVal;
    private Label usedTypesVal;
    private Label subAppsVal;
    private Label instancesVal;
    private Font boldFont;
    private static final int SORT_BY_KEY = 1;
    private static final int SORT_BY_VALUE_ASC = 2;
    private static final int SORT_BY_VALUE_DESC = 3;
    private Group fbGroup;
    private final List<Label> fbTypeLabels = new ArrayList<Label>();
    private final List<Label> fbCountLabels = new ArrayList<Label>();

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.parent = parent;
        Color backgroundColor = new Color(255, 255, 255);
        parent.setBackground(backgroundColor);
        GridLayout parentLayout = new GridLayout(2, true);
        parent.setLayout((Layout)parentLayout);
        Group group = InfoPropertySection.createGroup(parent, Messages.InfoPropertySection_SystemInfo, backgroundColor);
        this.numbConVal = this.createLabelPair((Composite)group, Messages.InfoPropertySection_Number_Of_Connections_Label, backgroundColor);
        this.usedTypesVal = this.createLabelPair((Composite)group, Messages.InfoPropertySection_Number_Of_Used_Types_Label, backgroundColor);
        this.subAppsVal = this.createLabelPair((Composite)group, Messages.InfoPropertySection_Number_Of_Untyped_SubApps_Label, backgroundColor);
        this.instancesVal = this.createLabelPair((Composite)group, Messages.InfoPropertySection_Number_Of_All_Instances_Label, backgroundColor);
        this.createLabel((Composite)group, Messages.InfoPropertySection_CheckBox_Label, backgroundColor, false);
        this.createCheckBox(group);
        this.fbGroup = InfoPropertySection.createGroup(parent, Messages.InfoPropertySection_All_Types_And_Counts_Label, backgroundColor);
        this.fbGroup.setVisible(false);
        this.sortCombo = this.createCombo((Composite)this.fbGroup, Messages.InfoPropertySection_Combo_Text_SortBy, Messages.InfoPropertySection_Combo_Text_Name, Messages.InfoPropertySection_Combo_Text_CountASC, Messages.InfoPropertySection_Combo_Text_CountDESC);
    }

    public void dispose() {
        super.dispose();
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
    }

    private Combo createCombo(Composite parent, String ... content) {
        Combo comb = new Combo(parent, 12);
        comb.setItems(content);
        comb.select(0);
        comb.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InfoPropertySection.this.setInputInit();
            }
        });
        GridData comboGridData = new GridData(16384, 128, false, false);
        comboGridData.horizontalSpan = 2;
        comb.setLayoutData((Object)comboGridData);
        return comb;
    }

    private Button createCheckBox(Group g) {
        final Button check = new Button((Composite)g, 32);
        GridData checkGridData = new GridData(16384, 128, false, false);
        checkGridData.horizontalIndent = 10;
        check.setLayoutData((Object)checkGridData);
        check.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InfoPropertySection.this.checked = check.getSelection();
                InfoPropertySection.this.setInputInit();
            }
        });
        return check;
    }

    private static Group createGroup(Composite parent, String string, Color backgroundColor) {
        Group group = new Group(parent, 0);
        group.setText(string);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(16384, 128, false, true));
        group.setBackground(backgroundColor);
        return group;
    }

    private Label createLabelPair(Composite parent, String string, Color backgroundColor) {
        this.createLabel(parent, string, backgroundColor, true);
        return InfoPropertySection.createValueLabel(parent, backgroundColor);
    }

    private static Label createValueLabel(Composite parent, Color c) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)gridData);
        gridData.horizontalIndent = 10;
        label.setBackground(c);
        return label;
    }

    private Label createLabel(Composite parent, String text, Color c, boolean bold) {
        Label label = new Label(parent, 0);
        label.setBackground(c);
        label.setText(text);
        if (bold) {
            label.setFont(this.getBoldFont(parent));
        }
        return label;
    }

    private Font getBoldFont(Composite parent) {
        if (this.boldFont == null) {
            FontData[] fontData;
            FontData[] fontDataArray = fontData = parent.getFont().getFontData();
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData fd = fontDataArray[n2];
                fd.setStyle(1);
                ++n2;
            }
            this.boldFont = new Font((Device)parent.getDisplay(), fontData);
        }
        return this.boldFont;
    }

    protected EObject getType() {
        ConfigurableObject configurableObject;
        Object object = this.type;
        return object instanceof ConfigurableObject ? (configurableObject = (ConfigurableObject)object) : null;
    }

    protected Object getInputType(Object input) {
        EObject parsedObject = (EObject)AttributeFilter.parseObject((Object)input);
        if (parsedObject instanceof SubApp) {
            SubApp configurableObject = (SubApp)parsedObject;
            this.obj = configurableObject;
            return configurableObject;
        }
        if (parsedObject instanceof Application) {
            Application configurableObject2 = (Application)parsedObject;
            this.obj = configurableObject2;
            return configurableObject2;
        }
        return null;
    }

    protected void setInputCode() {
    }

    protected void setInputInit() {
        this.formatPage();
    }

    protected void performRefresh() {
    }

    private void formatPage() {
        int subapps;
        int noc;
        HashMap<String, Integer> fbs = new HashMap<String, Integer>();
        ConfigurableObject configurableObject = this.obj;
        if (configurableObject instanceof SubApp) {
            SubApp subApp = (SubApp)configurableObject;
            FBNetwork network = subApp.getSubAppNetwork();
            noc = this.numbOfCon(network, fbs);
            fbs = this.countFBInstances((Iterable<FBNetworkElement>)network.getNetworkElements(), fbs);
            subapps = this.processSubappElements((Iterable<FBNetworkElement>)network.getNetworkElements(), fbs);
        } else {
            ConfigurableObject configurableObject2 = this.obj;
            if (configurableObject2 instanceof Application) {
                Application application = (Application)configurableObject2;
                FBNetwork network = application.getFBNetwork();
                noc = this.numbOfCon(network, fbs);
                fbs = this.countFBInstances((Iterable<FBNetworkElement>)network.getNetworkElements(), fbs);
                subapps = this.processSubappElements((Iterable<FBNetworkElement>)network.getNetworkElements(), fbs);
            } else {
                throw new IllegalStateException("Unexpected object type: " + this.obj.getClass().getName());
            }
        }
        int instanceCount = fbs.values().stream().mapToInt(Integer::intValue).sum();
        int types = fbs.size();
        this.updateLabels(noc, types, fbs, subapps, instanceCount);
    }

    private HashMap<String, Integer> countFBInstances(Iterable<FBNetworkElement> networkElements, HashMap<String, Integer> fbs) {
        for (FBNetworkElement fe : networkElements) {
            if (fe.getTypeEntry() != null) {
                fbs.merge(fe.getTypeName(), 1, Integer::sum);
            }
            if (fe instanceof UntypedSubApp) {
                UntypedSubApp sa = (UntypedSubApp)fe;
                if (sa.getSubAppNetwork() == null) continue;
                this.countFBInstances((Iterable<FBNetworkElement>)sa.getSubAppNetwork().getNetworkElements(), fbs);
                continue;
            }
            if (!(fe instanceof TypedSubApp)) continue;
            TypedSubApp sb = (TypedSubApp)fe;
            if (!this.checked) continue;
            if (sb.getSubAppNetwork() == null) {
                sb.loadSubAppNetwork();
            }
            this.countFBInstances((Iterable<FBNetworkElement>)sb.getSubAppNetwork().getNetworkElements(), fbs);
        }
        return fbs;
    }

    private int numbOfCon(FBNetwork fbNetwork, HashMap<String, Integer> fbs) {
        int con = 0;
        if (fbNetwork != null) {
            con += fbNetwork.getAdapterConnections().size() + fbNetwork.getDataConnections().size() + fbNetwork.getEventConnections().size();
            for (FBNetworkElement fe : fbNetwork.getNetworkElements()) {
                if (fe instanceof UntypedSubApp) {
                    UntypedSubApp sa = (UntypedSubApp)fe;
                    con += this.numbOfCon(sa.getSubAppNetwork(), fbs);
                    continue;
                }
                if (!(fe instanceof UntypedSubApp)) continue;
                UntypedSubApp sa = (UntypedSubApp)fe;
                if (!this.checked) continue;
                con += this.numbOfCon(sa.getSubAppNetwork(), fbs);
            }
        }
        return con;
    }

    private int processSubappElements(Iterable<FBNetworkElement> elements, Map<String, Integer> fbs) {
        int subapps = 0;
        for (FBNetworkElement fe : elements) {
            if (fe instanceof UntypedSubApp) {
                UntypedSubApp se = (UntypedSubApp)fe;
                ++subapps;
                subapps += this.processSubappElements((Iterable<FBNetworkElement>)se.getSubAppNetwork().getNetworkElements(), fbs);
                continue;
            }
            if (!(fe instanceof TypedSubApp)) continue;
            TypedSubApp se = (TypedSubApp)fe;
            if (!this.checked) continue;
            ++subapps;
            subapps += this.processSubappElements((Iterable<FBNetworkElement>)se.loadSubAppNetwork().getNetworkElements(), fbs);
        }
        return subapps;
    }

    private void updateLabels(int noc, int types, HashMap<String, Integer> fbs, int subapps, int instanceCount) {
        this.numbConVal.setText(String.valueOf(noc));
        this.usedTypesVal.setText(String.valueOf(types));
        this.subAppsVal.setText(String.valueOf(subapps));
        this.instancesVal.setText(String.valueOf(instanceCount));
        this.parent.setRedraw(false);
        InfoPropertySection.resetLabel(this.fbTypeLabels);
        InfoPropertySection.resetLabel(this.fbCountLabels);
        if (!fbs.isEmpty()) {
            ArrayList<Map.Entry<String, Integer>> sortedEntries = new ArrayList<Map.Entry<String, Integer>>(fbs.entrySet());
            int sortSel = this.sortCombo.getSelectionIndex();
            switch (sortSel) {
                case 1: {
                    sortedEntries.sort(Map.Entry.comparingByKey());
                    break;
                }
                case 2: {
                    sortedEntries.sort(Map.Entry.comparingByValue());
                    break;
                }
                case 3: {
                    sortedEntries.sort(Map.Entry.comparingByValue(Comparator.reverseOrder()));
                    break;
                }
            }
            this.fbGroup.setVisible(true);
            for (Map.Entry entry : sortedEntries) {
                Label fbTypeLabel = this.createLabel((Composite)this.fbGroup, (String)entry.getKey() + ":", this.parent.getBackground(), true);
                this.fbTypeLabels.add(fbTypeLabel);
                Label fbCountLabel = InfoPropertySection.createValueLabel((Composite)this.fbGroup, this.parent.getBackground());
                fbCountLabel.setText(String.valueOf(entry.getValue()));
                this.fbCountLabels.add(fbCountLabel);
            }
        } else {
            this.fbGroup.setVisible(false);
        }
        this.parent.setRedraw(true);
        this.parent.layout(true, true);
    }

    private static void resetLabel(List<Label> list) {
        for (Label l : list) {
            l.dispose();
        }
        list.clear();
    }
}

