/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.figures;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.utilities.ExpandedInterfacePositionMap;

public class ExpandedSubappInterfaceLayout
extends ToolbarLayout {
    final ExpandedInterfacePositionMap positions;
    final boolean isInput;

    public ExpandedSubappInterfaceLayout(ExpandedInterfacePositionMap positions, boolean isInput) {
        super(false);
        this.positions = positions;
        this.isInput = isInput;
        this.setStretchMinorAxis(true);
        this.setSpacing(2);
        this.setMinorAlignment(2);
    }

    public void layout(IFigure parent) {
        if (this.positions.inputPositions == null || this.positions.outputPositions == null) {
            this.positions.calculate();
        }
        List children = parent.getChildren();
        int numChildren = children.size();
        Rectangle clientArea = this.transposer.t(parent.getClientArea());
        int wHint = parent.getClientArea((Rectangle)Rectangle.SINGLETON).width;
        int hHint = -1;
        int x = clientArea.x;
        int y = this.isInput ? this.positions.getInputUnconnectedStart() : this.positions.getOutputUnconnectedStart();
        y = y == Integer.MAX_VALUE ? clientArea.y : y;
        int i = 0;
        while (i < numChildren) {
            Rectangle newBounds;
            Integer entry;
            IFigure child = (IFigure)children.get(i);
            int prefHeight = this.transposer.t((Dimension)this.getChildPreferredSize((IFigure)child, (int)wHint, (int)-1)).height;
            Integer n = entry = this.isInput ? this.positions.inputPositions.get(child) : this.positions.outputPositions.get(child);
            if (entry == null) {
                newBounds = new Rectangle(x, this.getDirectPosition(child), 0, prefHeight);
            } else if (entry == Integer.MAX_VALUE) {
                newBounds = new Rectangle(x, y, 0, prefHeight);
                y += newBounds.height;
            } else {
                newBounds = new Rectangle(x, entry.intValue(), 0, prefHeight);
            }
            newBounds.width = clientArea.width;
            newBounds.x += clientArea.width - newBounds.width;
            child.setBounds(this.transposer.t(newBounds));
            ++i;
        }
    }

    private int getDirectPosition(IFigure child) {
        return this.positions.directPositions.getOrDefault(child, 0);
    }
}

