/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.internal.ui.views.memory.RenderingViewPane;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ResetMemoryBlockAction
implements IViewActionDelegate {
    private IViewPart fView;
    private final ArrayList<Object> fSelectedMB = new ArrayList();

    public void init(IViewPart view) {
        this.fView = view;
    }

    public void run(IAction action) {
        if (this.fSelectedMB.isEmpty()) {
            return;
        }
        boolean resetVisible = false;
        String resetPref = DebugUITools.getPreferenceStore().getString("org.eclipse.debug.ui.reset_memory_block");
        if (resetPref.equals("org.eclipse.debug.uiresetMemoryBlock.visible")) {
            resetVisible = true;
        }
        for (IMemoryBlock iMemoryBlock : this.fSelectedMB) {
            IMemoryRenderingContainer[] containers;
            IViewPart iViewPart = this.fView;
            if (!(iViewPart instanceof MemoryView)) continue;
            MemoryView memView = (MemoryView)iViewPart;
            IMemoryRenderingContainer[] iMemoryRenderingContainerArray = containers = memView.getMemoryRenderingContainers();
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                IMemoryRenderingContainer container = iMemoryRenderingContainerArray[n2];
                if (container instanceof RenderingViewPane) {
                    ((RenderingViewPane)container).resetRenderings(iMemoryBlock, resetVisible);
                }
                ++n2;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(!selection.isEmpty());
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection strucSel = (IStructuredSelection)selection;
            Object[] objs = strucSel.toArray();
            this.fSelectedMB.clear();
            Object[] objectArray = objs;
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof IMemoryBlock) {
                    this.fSelectedMB.add(obj);
                }
                if (obj instanceof IMemoryRendering) {
                    this.fSelectedMB.add(((IMemoryRendering)obj).getMemoryBlock());
                }
                ++n2;
            }
        }
    }
}

