/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.nodespacing.cellsystem;

import org.eclipse.elk.alg.common.nodespacing.cellsystem.Cell;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;

public class AtomicCell
extends Cell {
    private KVector minimumContentAreaSize = new KVector();

    public KVector getMinimumContentAreaSize() {
        return this.minimumContentAreaSize;
    }

    public void setMinimumContentAreaSize(KVector newMinimumContentAreaSize, boolean includesPadding) {
        if (includesPadding) {
            ElkPadding padding = this.getPadding();
            this.minimumContentAreaSize.x = newMinimumContentAreaSize.x - padding.left - padding.right;
            this.minimumContentAreaSize.y = newMinimumContentAreaSize.y - padding.top - padding.bottom;
        } else {
            this.minimumContentAreaSize.set(newMinimumContentAreaSize);
        }
    }

    @Override
    public double getMinimumWidth() {
        ElkPadding padding = this.getPadding();
        return this.minimumContentAreaSize.x + padding.left + padding.right;
    }

    @Override
    public double getMinimumHeight() {
        ElkPadding padding = this.getPadding();
        return this.minimumContentAreaSize.y + padding.top + padding.bottom;
    }
}

