/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.ServiceSequenceEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.figures.SequenceFigure;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.figures.ServiceFigure;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.helpers.ServiceSequenceSaveAndLoadHelper;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.policies.ChangeInterfaceNameEditPolicy;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.policies.TransactionLayoutEditPolicy;
import org.eclipse.fordiac.ide.gef.editparts.LabelDirectEditManager;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;

public class SequenceRootEditPart
extends AbstractGraphicalEditPart {
    private final Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            SequenceRootEditPart.this.refresh();
        }
    };

    public void activate() {
        if (!this.isActive()) {
            this.getCastedModel().eAdapters().add((Object)this.adapter);
        }
        super.activate();
    }

    public void deactivate() {
        if (this.isActive()) {
            this.getCastedModel().eAdapters().remove((Object)this.adapter);
        }
        super.deactivate();
    }

    protected IFigure createFigure() {
        return new ServiceFigure();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new TransactionLayoutEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ChangeInterfaceNameEditPolicy());
    }

    public boolean isLeft(DirectEditRequest request) {
        Point point = request.getLocation() == null ? new Point(request.getCellEditor().getControl().getLocation()) : request.getLocation().getCopy();
        this.getFigure().translateToRelative((Translatable)point);
        return point.x < this.getFigure().getClientArea().width / 2;
    }

    public DirectEditManager getManager(boolean isLeft) {
        Label l = isLeft ? ((ServiceFigure)this.getFigure()).getLeftLabel() : ((ServiceFigure)this.getFigure()).getRightLabel();
        return new LabelDirectEditManager((GraphicalEditPart)this, l);
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" && request instanceof DirectEditRequest) {
            this.performDirectEdit(this.isLeft((DirectEditRequest)request));
        } else {
            super.performRequest(request);
        }
    }

    private void performDirectEdit(boolean isLeft) {
        this.getManager(isLeft).show();
    }

    public Service getCastedModel() {
        return ((FBType)this.getModel()).getService();
    }

    public FBType getFBType() {
        return (FBType)this.getModel();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        ServiceFigure figure = (ServiceFigure)this.getFigure();
        if (this.getCastedModel() != null) {
            if (this.getCastedModel().getLeftInterface() != null) {
                figure.setLeftLabelText(this.getCastedModel().getLeftInterface() != null ? this.getCastedModel().getLeftInterface().getName() : "", this.getCastedModel().getLeftInterface().getComment());
            }
            if (this.getCastedModel().getRightInterface() != null) {
                figure.setRightLabelText(this.getCastedModel().getRightInterface() != null ? this.getCastedModel().getRightInterface().getName() : "", this.getCastedModel().getRightInterface().getComment());
            }
        }
    }

    protected List<ServiceSequence> getModelChildren() {
        return new ArrayList<ServiceSequence>((Collection<ServiceSequence>)this.getCastedModel().getServiceSequence());
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (childEditPart instanceof ServiceSequenceEditPart) {
            SequenceFigure child = (SequenceFigure)((GraphicalEditPart)childEditPart).getFigure();
            ServiceFigure thisFigure = (ServiceFigure)this.getFigure();
            GridData childData = new GridData(4, 0, true, false);
            thisFigure.getServiceSequenceContainer().add((IFigure)child, index);
            thisFigure.getServiceSequenceContainer().getLayoutManager().setConstraint((IFigure)child, (Object)childData);
        }
    }

    protected void removeChildVisual(EditPart childEditPart) {
        Object object;
        if (childEditPart instanceof ServiceSequenceEditPart && (object = childEditPart.getModel()) instanceof ServiceSequence) {
            ServiceSequence seq = (ServiceSequence)object;
            ServiceSequenceSaveAndLoadHelper.removeServiceSequenceFromFile(this.getFBType(), seq);
            SequenceFigure child = (SequenceFigure)((GraphicalEditPart)childEditPart).getFigure();
            ServiceFigure thisFigure = (ServiceFigure)this.getFigure();
            thisFigure.getServiceSequenceContainer().remove((IFigure)child);
        }
    }
}

