/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.bracketmatching;

import com.google.inject.Inject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.actions.IActionContributor;
import org.eclipse.xtext.ui.editor.bracketmatching.Messages;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;

public class GoToMatchingBracketAction
extends Action
implements IActionContributor {
    @Inject
    private ICharacterPairMatcher matcher;
    private XtextEditor editor;

    public GoToMatchingBracketAction() {
        super(Messages.GoToMatchingBracketAction_label);
        this.setId(GoToMatchingBracketAction.class.getName());
        this.setActionDefinitionId("org.eclipse.xtext.ui.GotToMatchingBracketAction");
    }

    public void run() {
        IRegion region;
        ITextSelection textSelection;
        IXtextDocument document = this.editor.getDocument();
        ISelection selection = this.editor.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection && (textSelection = (ITextSelection)selection).getLength() == 0 && (region = this.matcher.match((IDocument)document, textSelection.getOffset())) != null) {
            if (region.getOffset() + 1 == textSelection.getOffset()) {
                this.editor.selectAndReveal(region.getOffset() + region.getLength(), 0);
            } else {
                this.editor.selectAndReveal(region.getOffset() + 1, 0);
            }
        }
    }

    @Override
    public void contributeActions(XtextEditor editor) {
        this.editor = editor;
        this.setEnabled(true);
        editor.setAction(this.getId(), (IAction)this);
    }

    @Override
    public void editorDisposed(XtextEditor editor) {
    }
}

