/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.function.ToIntFunction;
import org.eclipse.nebula.widgets.grid.DataVisualizer;
import org.eclipse.nebula.widgets.grid.DefaultEmptyCellRenderer;
import org.eclipse.nebula.widgets.grid.FixedGridColumns;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridCellSpanManager;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.nebula.widgets.grid.GridDragSourceEffect;
import org.eclipse.nebula.widgets.grid.GridDropTargetEffect;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.nebula.widgets.grid.GridItemDataVisualizer;
import org.eclipse.nebula.widgets.grid.GridSelectionType;
import org.eclipse.nebula.widgets.grid.IRenderer;
import org.eclipse.nebula.widgets.grid.InsertMark;
import org.eclipse.nebula.widgets.grid.internal.DefaultBottomLeftRenderer;
import org.eclipse.nebula.widgets.grid.internal.DefaultColumnGroupHeaderRenderer;
import org.eclipse.nebula.widgets.grid.internal.DefaultDropPointRenderer;
import org.eclipse.nebula.widgets.grid.internal.DefaultEmptyColumnFooterRenderer;
import org.eclipse.nebula.widgets.grid.internal.DefaultEmptyColumnHeaderRenderer;
import org.eclipse.nebula.widgets.grid.internal.DefaultEmptyRowHeaderRenderer;
import org.eclipse.nebula.widgets.grid.internal.DefaultFocusRenderer;
import org.eclipse.nebula.widgets.grid.internal.DefaultInsertMarkRenderer;
import org.eclipse.nebula.widgets.grid.internal.DefaultRowHeaderRenderer;
import org.eclipse.nebula.widgets.grid.internal.DefaultTopLeftRenderer;
import org.eclipse.nebula.widgets.grid.internal.GridToolTip;
import org.eclipse.nebula.widgets.grid.internal.IScrollBarProxy;
import org.eclipse.nebula.widgets.grid.internal.NullScrollBarProxy;
import org.eclipse.nebula.widgets.grid.internal.ScrollBarProxyAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class Grid
extends Canvas {
    private Font defaultFont;
    private static final String ACC_COLUMN_DEFAULT_ACTION = "Click";
    private static final String ACC_ITEM_DEFAULT_ACTION = "Double Click";
    private static final String ACC_ITEM_ACTION_EXPAND = "Expand";
    private static final String ACC_ITEM_ACTION_COLLAPSE = "Collapse";
    private static final String ACC_TOGGLE_BUTTON_NAME = "Toggle Button";
    private static final int COLUMN_DRAG_ALPHA = 128;
    private static final int DROP_POINT_LOWER_OFFSET = 3;
    private static final int HORZ_SCROLL_INCREMENT = 5;
    private static final int COLUMN_RESIZER_THRESHOLD = 4;
    private static final int ROW_RESIZER_THRESHOLD = 3;
    private static final int MIN_COLUMN_HEADER_WIDTH = 20;
    private static final int MIN_ROW_HEADER_HEIGHT = 10;
    private boolean scrollValuesObsolete = false;
    private boolean visibleLinesBasedColumnPack = false;
    private final List<GridItem> items = new ArrayList<GridItem>();
    private final List<GridItem> rootItems = new ArrayList<GridItem>();
    private final List<GridItem> selectedItems = new ArrayList<GridItem>();
    private GridItem focusItem;
    private boolean cellSelectionEnabled = false;
    private boolean cellDragSelectionEnabled = true;
    private final List<Point> selectedCells = new ArrayList<Point>();
    private final List<Point> selectedCellsBeforeRangeSelect = new ArrayList<Point>();
    private boolean cellDragSelectionOccuring = false;
    private boolean cellRowDragSelectionOccuring = false;
    private boolean cellColumnDragSelectionOccuring = false;
    private boolean cellDragCTRL = false;
    private boolean followupCellSelectionEventOwed = false;
    private boolean cellSelectedOnLastMouseDown;
    private boolean cellRowSelectedOnLastMouseDown;
    private boolean cellColumnSelectedOnLastMouseDown;
    private GridColumn shiftSelectionAnchorColumn;
    private GridColumn focusColumn;
    private final List<GridColumn> selectedColumns = new ArrayList<GridColumn>();
    private GridColumn intendedFocusColumn;
    private final List<GridColumn> columns = new ArrayList<GridColumn>();
    private final List<GridColumn> displayOrderedColumns = new ArrayList<GridColumn>();
    private GridColumnGroup[] columnGroups = new GridColumnGroup[0];
    private IRenderer topLeftRenderer = new DefaultTopLeftRenderer();
    private IRenderer bottomLeftRenderer = new DefaultBottomLeftRenderer();
    private IRenderer rowHeaderRenderer = new DefaultRowHeaderRenderer();
    private IRenderer emptyColumnHeaderRenderer = new DefaultEmptyColumnHeaderRenderer();
    private IRenderer emptyColumnFooterRenderer = new DefaultEmptyColumnFooterRenderer();
    private GridCellRenderer emptyCellRenderer = new DefaultEmptyCellRenderer();
    private IRenderer emptyRowHeaderRenderer = new DefaultEmptyRowHeaderRenderer();
    private final IRenderer dropPointRenderer = new DefaultDropPointRenderer();
    private IRenderer focusRenderer = new DefaultFocusRenderer();
    private boolean rowHeaderVisible = false;
    private boolean columnHeadersVisible = false;
    private boolean columnFootersVisible = false;
    private GridSelectionType selectionType = GridSelectionType.SINGLE;
    private boolean selectionEnabled = true;
    private int itemHeight = 1;
    private boolean userModifiedItemHeight = false;
    private int rowHeaderWidth = 0;
    private int headerHeight = 0;
    private int footerHeight = 0;
    boolean hoveringOnColumnResizer = false;
    private GridColumn columnBeingResized;
    private boolean rowsResizeable = false;
    private boolean resizingColumn = false;
    private int resizingStartX = 0;
    private int resizingColumnStartWidth = 0;
    private boolean hoveringOnRowResizer = false;
    private GridItem rowBeingResized;
    private boolean resizingRow = false;
    private int resizingStartY;
    private int resizingRowStartHeight;
    private GridColumn columnBeingPushed;
    private boolean pushingColumn = false;
    private boolean pushingAndHovering = false;
    private int startHeaderPushX = 0;
    private int startHeaderDragX = 0;
    private int currentHeaderDragX = 0;
    private boolean draggingColumn = false;
    private GridColumn dragDropBeforeColumn = null;
    private GridColumn dragDropAfterColumn = null;
    private boolean dragDropPointValid = true;
    private GridItem hoveringItem;
    private GridColumn hoveringColumn;
    private GridColumn hoveringColumnHeader;
    private GridColumnGroup hoverColumnGroupHeader;
    private String hoveringDetail = "";
    private boolean hoveringOverText = false;
    private boolean linesVisible = true;
    private boolean treeLinesVisible = true;
    private Color lineColor;
    private IScrollBarProxy vScroll;
    private IScrollBarProxy hScroll;
    private int currentVisibleItems = 0;
    private GridItem shiftSelectionAnchorItem;
    private boolean columnScrolling = false;
    private int groupHeaderHeight;
    private Color cellHeaderSelectionBackground;
    private Listener disposeListener;
    private GridToolTip inplaceToolTip;
    private Color backgroundColor;
    private boolean disposing = false;
    private boolean isTree = false;
    boolean hasDifferingHeights = false;
    private boolean hasSpanning = false;
    int topIndex = -1;
    int bottomIndex = -1;
    int startColumnIndex = -1;
    int endColumnIndex = -1;
    private boolean bottomIndexShownCompletely = false;
    private String toolTipText = null;
    private boolean firstImageSet = false;
    private boolean inplaceTooltipCapture;
    private String displayedToolTipText;
    private static final int DRAG_SCROLL_AREA_HEIGHT = 12;
    private static final int SELECTION_DRAG_BORDER_THRESHOLD = 2;
    private boolean hoveringOnSelectionDragArea = false;
    private GridItem insertMarkItem = null;
    private GridColumn insertMarkColumn = null;
    private boolean insertMarkBefore = false;
    private final IRenderer insertMarkRenderer = new DefaultInsertMarkRenderer();
    private boolean sizeOnEveryItemImageChange;
    private boolean autoHeight = false;
    private boolean autoWidth = true;
    private boolean wordWrapRowHeader = false;
    private final DataVisualizer dataVisualizer;
    private Listener defaultKeyListener;
    private boolean defaultKeyListenerEnabled = true;
    private int[] columnOrders;
    private boolean moveOnTab = false;

    public DataVisualizer getDataVisualizer() {
        return this.dataVisualizer;
    }

    public void clearItems() {
        this.items.clear();
        this.rootItems.clear();
        this.deselectAll();
        this.redraw();
    }

    private static int checkStyle(int style) {
        int mask = 369625894;
        int newStyle = style & 0x16080B26;
        return newStyle |= 0x20000000;
    }

    public Grid(Composite parent, int style) {
        this(new GridItemDataVisualizer(Display.getCurrent().getSystemColor(1), Display.getCurrent().getSystemColor(2), null), parent, style);
    }

    public Grid(DataVisualizer dataVisualizer, Composite parent, int style) {
        super(parent, Grid.checkStyle(style));
        this.dataVisualizer = dataVisualizer;
        this.setData("DEFAULT_DRAG_SOURCE_EFFECT", (Object)new GridDragSourceEffect(this));
        this.setData("DEFAULT_DROP_TARGET_EFFECT", (Object)new GridDropTargetEffect(this));
        this.topLeftRenderer.setDisplay(this.getDisplay());
        this.bottomLeftRenderer.setDisplay(this.getDisplay());
        this.rowHeaderRenderer.setDisplay(this.getDisplay());
        this.emptyColumnHeaderRenderer.setDisplay(this.getDisplay());
        this.emptyColumnFooterRenderer.setDisplay(this.getDisplay());
        this.emptyCellRenderer.setDisplay(this.getDisplay());
        this.dropPointRenderer.setDisplay(this.getDisplay());
        this.focusRenderer.setDisplay(this.getDisplay());
        this.emptyRowHeaderRenderer.setDisplay(this.getDisplay());
        this.insertMarkRenderer.setDisplay(this.getDisplay());
        this.setForeground(this.getDisplay().getSystemColor(24));
        this.setLineColor(this.getDisplay().getSystemColor(22));
        if ((style & 2) != 0) {
            this.selectionType = GridSelectionType.MULTI;
        }
        if (this.getVerticalBar() != null) {
            this.getVerticalBar().setVisible(false);
            this.vScroll = new ScrollBarProxyAdapter(this.getVerticalBar());
        } else {
            this.vScroll = new NullScrollBarProxy();
        }
        if (this.getHorizontalBar() != null) {
            this.getHorizontalBar().setVisible(false);
            this.hScroll = new ScrollBarProxyAdapter(this.getHorizontalBar());
        } else {
            this.hScroll = new NullScrollBarProxy();
        }
        this.scrollValuesObsolete = true;
        this.initListeners();
        this.initAccessible();
        this.estimate(sizingGC -> {
            int n = this.itemHeight = sizingGC.getFontMetrics().getHeight() + 2;
        });
        RGB sel = this.getDisplay().getSystemColor(26).getRGB();
        RGB white = this.getDisplay().getSystemColor(1).getRGB();
        RGB cellSel = this.blend(sel, white, 50);
        this.cellHeaderSelectionBackground = new Color(cellSel);
        this.setDragDetect(false);
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.backgroundColor == null) {
            return this.getDisplay().getSystemColor(25);
        }
        return this.backgroundColor;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this.backgroundColor = color;
        this.dataVisualizer.setDefaultBackground(color);
        this.redraw();
    }

    public Color getCellHeaderSelectionBackground() {
        this.checkWidget();
        return this.cellHeaderSelectionBackground;
    }

    public void setCellHeaderSelectionBackground(Color cellSelectionBackground) {
        this.checkWidget();
        this.cellHeaderSelectionBackground = cellSelectionBackground;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener((EventListener)listener, new int[]{13, 14});
    }

    public void addTreeListener(TreeListener listener) {
        this.addTypedListener((EventListener)listener, new int[]{17, 18});
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point prefSize = null;
        if (wHint == -1 || hHint == -1) {
            prefSize = this.getTableSize();
            prefSize.x += 2 * this.getBorderWidth();
            prefSize.y += 2 * this.getBorderWidth();
        }
        int x = 0;
        int y = 0;
        if (wHint == -1) {
            x += prefSize.x;
            if (this.getVerticalBar() != null) {
                x += this.getVerticalBar().getSize().x;
            }
        } else {
            x = wHint;
        }
        if (hHint == -1) {
            y += prefSize.y;
            if (this.getHorizontalBar() != null) {
                y += this.getHorizontalBar().getSize().y;
            }
        } else {
            y = hHint;
        }
        return new Point(x, y);
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index < 0 || index > this.items.size() - 1) {
            return;
        }
        GridItem item = this.items.get(index);
        if (!this.cellSelectionEnabled) {
            if (this.selectedItems.contains((Object)item)) {
                this.selectedItems.remove((Object)item);
            }
        } else {
            this.deselectCells(this.getCells(item));
        }
        this.redraw();
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        int i = start;
        while (i <= end) {
            if (i >= 0) {
                if (i > this.items.size() - 1) break;
                GridItem item = this.items.get(i);
                if (!this.cellSelectionEnabled) {
                    if (this.selectedItems.contains((Object)item)) {
                        this.selectedItems.remove((Object)item);
                    }
                } else {
                    this.deselectCells(this.getCells(item));
                }
            }
            ++i;
        }
        this.redraw();
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int j = nArray[n2];
            if (j >= 0 && j < this.items.size()) {
                GridItem item = this.items.get(j);
                if (!this.cellSelectionEnabled) {
                    if (this.selectedItems.contains((Object)item)) {
                        this.selectedItems.remove((Object)item);
                    }
                } else {
                    this.deselectCells(this.getCells(item));
                }
            }
            ++n2;
        }
        this.redraw();
    }

    public void deselectAll() {
        this.checkWidget();
        if (!this.cellSelectionEnabled) {
            this.selectedItems.clear();
            this.redraw();
        } else {
            this.deselectAllCells();
        }
    }

    public GridColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index > this.getColumnCount() - 1) {
            SWT.error((int)6);
        }
        return this.columns.get(index);
    }

    public GridColumn getColumn(Point point) {
        return this.getColumn(null, point);
    }

    private GridColumn getColumn(GridItem item, Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error((int)4);
        }
        GridColumn overThis = null;
        int x2 = 0;
        if (this.rowHeaderVisible) {
            if (point.x <= this.rowHeaderWidth) {
                return null;
            }
            x2 += this.rowHeaderWidth;
        }
        x2 -= this.getHScrollSelectionInPixels();
        for (GridColumn column : this.displayOrderedColumns) {
            if (!column.isVisible()) continue;
            if (point.x >= x2 && point.x < x2 + column.getWidth()) {
                overThis = column;
                break;
            }
            x2 += column.getWidth();
        }
        if (overThis == null) {
            return null;
        }
        if (this.hasSpanning) {
            if (item == null) {
                item = this.getItem(point);
            }
            if (item != null) {
                int displayColIndex = this.displayOrderedColumns.indexOf((Object)overThis);
                int i = 0;
                while (i < displayColIndex) {
                    int colIndex;
                    int span;
                    if (this.displayOrderedColumns.get(i).isVisible() && i + (span = item.getColumnSpan(colIndex = this.displayOrderedColumns.get((int)i).index)) >= displayColIndex) {
                        overThis = this.displayOrderedColumns.get(i);
                        break;
                    }
                    ++i;
                }
            }
        }
        return overThis;
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columns.size();
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.columnOrders == null) {
            this.columnOrders = new int[this.columns.size()];
            int i = 0;
            for (GridColumn col : this.displayOrderedColumns) {
                this.columnOrders[i] = col.index;
                ++i;
            }
        }
        return this.columnOrders;
    }

    public int getColumnGroupCount() {
        this.checkWidget();
        return this.columnGroups.length;
    }

    public GridColumnGroup[] getColumnGroups() {
        this.checkWidget();
        GridColumnGroup[] newArray = new GridColumnGroup[this.columnGroups.length];
        System.arraycopy(this.columnGroups, 0, newArray, 0, this.columnGroups.length);
        return newArray;
    }

    public GridColumnGroup getColumnGroup(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnGroups.length) {
            SWT.error((int)6);
        }
        return this.columnGroups[index];
    }

    public void setColumnOrder(int[] order) {
        int n;
        this.checkWidget();
        if (order == null) {
            SWT.error((int)4);
        }
        if (order.length != this.displayOrderedColumns.size()) {
            SWT.error((int)5);
        }
        boolean[] seen = new boolean[this.displayOrderedColumns.size()];
        int i = 0;
        while (i < order.length) {
            if (order[i] < 0 || order[i] >= this.displayOrderedColumns.size()) {
                SWT.error((int)5);
            }
            if (seen[order[i]]) {
                SWT.error((int)5);
            }
            seen[order[i]] = true;
            ++i;
        }
        if (this.columnGroups.length != 0) {
            GridColumnGroup currentGroup = null;
            int colsInGroup = 0;
            int[] nArray = order;
            int n2 = order.length;
            n = 0;
            while (n < n2) {
                int element = nArray[n];
                GridColumn col = this.getColumn(element);
                if (currentGroup != null) {
                    if (col.getColumnGroup() != currentGroup && colsInGroup > 0) {
                        SWT.error((int)5);
                    } else if (--colsInGroup <= 0) {
                        currentGroup = null;
                    }
                } else if (col.getColumnGroup() != null) {
                    currentGroup = col.getColumnGroup();
                    colsInGroup = currentGroup.getColumns().length - 1;
                }
                ++n;
            }
        }
        GridColumn[] cols = this.getColumns();
        this.displayOrderedColumns.clear();
        int[] nArray = order;
        n = order.length;
        int n3 = 0;
        while (n3 < n) {
            int element = nArray[n3];
            this.displayOrderedColumns.add(cols[element]);
            ++n3;
        }
        this.clearDisplayOrderedCache();
    }

    private void clearDisplayOrderedCache() {
        this.columnOrders = null;
    }

    public GridColumn[] getColumns() {
        this.checkWidget();
        return this.columns.toArray(new GridColumn[this.columns.size()]);
    }

    public GridCellRenderer getEmptyCellRenderer() {
        this.checkWidget();
        return this.emptyCellRenderer;
    }

    public IRenderer getEmptyColumnHeaderRenderer() {
        this.checkWidget();
        return this.emptyColumnHeaderRenderer;
    }

    public IRenderer getEmptyColumnFooterRenderer() {
        this.checkWidget();
        return this.emptyColumnFooterRenderer;
    }

    public IRenderer getEmptyRowHeaderRenderer() {
        this.checkWidget();
        return this.emptyRowHeaderRenderer;
    }

    protected IScrollBarProxy getHorizontalScrollBarProxy() {
        this.checkWidget();
        return this.hScroll;
    }

    protected IScrollBarProxy getVerticalScrollBarProxy() {
        this.checkWidget();
        return this.vScroll;
    }

    public IRenderer getFocusRenderer() {
        this.checkWidget();
        return this.focusRenderer;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return this.headerHeight;
    }

    public Font getFont() {
        if (this.defaultFont == null) {
            this.defaultFont = super.getFont();
        }
        return this.defaultFont;
    }

    public int getFooterHeight() {
        this.checkWidget();
        return this.footerHeight;
    }

    public int getGroupHeaderHeight() {
        this.checkWidget();
        return this.groupHeaderHeight;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return this.columnHeadersVisible;
    }

    public boolean getFooterVisible() {
        this.checkWidget();
        return this.columnFootersVisible;
    }

    public GridItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            SWT.error((int)6);
        }
        return this.items.get(index);
    }

    public GridItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error((int)4);
        }
        if (point.x < 0 || point.x > this.getClientArea().width) {
            return null;
        }
        Point p = new Point(point.x, point.y);
        int y2 = 0;
        if (this.columnHeadersVisible) {
            if (p.y <= this.headerHeight) {
                return null;
            }
            y2 += this.headerHeight;
        }
        GridItem itemToReturn = null;
        int row = this.getTopIndex();
        while (row < this.items.size() && y2 <= this.getClientArea().height) {
            GridItem currItem = this.items.get(row);
            if (currItem.isVisible()) {
                int currItemHeight = currItem.getHeight();
                if (p.y >= y2 && p.y < y2 + currItemHeight + 1) {
                    itemToReturn = currItem;
                    break;
                }
                y2 += currItemHeight + 1;
            }
            ++row;
        }
        if (this.hasSpanning && itemToReturn != null) {
            int itemIndex = this.getIndexOfItem(itemToReturn);
            GridColumn gridColumn = this.getColumn(itemToReturn, point);
            int displayColIndex = this.displayOrderedColumns.indexOf((Object)gridColumn);
            int indexNextItemToCheck = 0;
            int i = 0;
            while (i < itemIndex) {
                GridItem gridItem;
                if (i >= indexNextItemToCheck && (gridItem = this.getItem(i)).isVisible()) {
                    int span = gridItem.getRowSpan(displayColIndex);
                    if (i + span >= itemIndex) {
                        itemToReturn = gridItem;
                        break;
                    }
                    indexNextItemToCheck = i + span + 1;
                }
                ++i;
            }
        }
        return itemToReturn;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.size();
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.itemHeight;
    }

    public void setItemHeight(int height) {
        this.checkWidget();
        if (height < 1) {
            SWT.error((int)5);
        }
        this.itemHeight = height;
        this.userModifiedItemHeight = true;
        for (GridItem item : this.items) {
            item.setHeight(height);
        }
        this.hasDifferingHeights = false;
        this.setScrollValuesObsolete();
        this.redraw();
    }

    public boolean getRowsResizeable() {
        this.checkWidget();
        return this.rowsResizeable;
    }

    public void setRowsResizeable(boolean rowsResizeable) {
        this.checkWidget();
        this.rowsResizeable = rowsResizeable;
    }

    public GridItem[] getItems() {
        this.checkWidget();
        return this.items.toArray(new GridItem[this.items.size()]);
    }

    public int getIndexOfItem(GridItem item) {
        this.checkWidget();
        return item.getRowIndex();
    }

    public Color getLineColor() {
        this.checkWidget();
        return this.lineColor;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return this.linesVisible;
    }

    public boolean getTreeLinesVisible() {
        this.checkWidget();
        return this.treeLinesVisible;
    }

    public GridItem getNextVisibleItem(GridItem item) {
        this.checkWidget();
        int index = item.getRowIndex();
        if (this.items.size() == index + 1) {
            return null;
        }
        GridItem nextItem = this.items.get(index + 1);
        while (!nextItem.isVisible()) {
            if (this.items.size() == ++index + 1) {
                return null;
            }
            nextItem = this.items.get(index + 1);
        }
        return nextItem;
    }

    public GridItem getPreviousVisibleItem(GridItem item) {
        this.checkWidget();
        int index = 0;
        if (item == null) {
            index = this.items.size();
        } else {
            index = item.getRowIndex();
            if (index <= 0) {
                return null;
            }
        }
        GridItem prevItem = this.items.get(index - 1);
        while (!prevItem.isVisible()) {
            if (--index == 0) {
                return null;
            }
            prevItem = this.items.get(index - 1);
        }
        return prevItem;
    }

    public GridColumn getPreviousVisibleColumn(GridColumn column) {
        this.checkWidget();
        int index = this.displayOrderedColumns.indexOf((Object)column);
        if (index == 0) {
            return null;
        }
        GridColumn previous = this.displayOrderedColumns.get(--index);
        while (!previous.isVisible()) {
            if (index == 0) {
                return null;
            }
            previous = this.displayOrderedColumns.get(--index);
        }
        return previous;
    }

    public GridColumn getNextVisibleColumn(GridColumn column) {
        this.checkWidget();
        int index = this.displayOrderedColumns.indexOf((Object)column);
        if (index == this.displayOrderedColumns.size() - 1) {
            return null;
        }
        GridColumn next = this.displayOrderedColumns.get(++index);
        while (!next.isVisible()) {
            if (index == this.displayOrderedColumns.size() - 1) {
                return null;
            }
            next = this.displayOrderedColumns.get(++index);
        }
        return next;
    }

    public int getRootItemCount() {
        this.checkWidget();
        return this.rootItems.size();
    }

    public GridItem[] getRootItems() {
        this.checkWidget();
        return this.rootItems.toArray(new GridItem[this.rootItems.size()]);
    }

    public GridItem getRootItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.rootItems.size()) {
            SWT.error((int)6);
        }
        return this.rootItems.get(index);
    }

    public IRenderer getRowHeaderRenderer() {
        this.checkWidget();
        return this.rowHeaderRenderer;
    }

    public GridItem[] getSelection() {
        this.checkWidget();
        if (!this.cellSelectionEnabled) {
            return this.selectedItems.toArray(new GridItem[this.selectedItems.size()]);
        }
        Vector<GridItem> items = new Vector<GridItem>();
        int itemCount = this.getItemCount();
        for (Point cell : this.selectedCells) {
            GridItem item;
            if (cell.y < 0 || cell.y >= itemCount || items.contains((Object)(item = this.getItem(cell.y)))) continue;
            items.add(item);
        }
        return items.toArray(new GridItem[0]);
    }

    public int getSelectionCount() {
        this.checkWidget();
        if (!this.cellSelectionEnabled) {
            return this.selectedItems.size();
        }
        Vector<GridItem> items = new Vector<GridItem>();
        for (Point cell : this.selectedCells) {
            GridItem item = this.getItem(cell.y);
            if (items.contains((Object)item)) continue;
            items.add(item);
        }
        return items.size();
    }

    public int getCellSelectionCount() {
        this.checkWidget();
        return this.selectedCells.size();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if (!this.cellSelectionEnabled) {
            if (this.selectedItems.size() == 0) {
                return -1;
            }
            return this.selectedItems.get(0).getRowIndex();
        }
        if (this.selectedCells.size() == 0) {
            return -1;
        }
        return this.selectedCells.get((int)0).y;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        if (!this.cellSelectionEnabled) {
            int[] indices = new int[this.selectedItems.size()];
            int i = 0;
            for (GridItem item : this.selectedItems) {
                indices[i] = item.getRowIndex();
                ++i;
            }
            return indices;
        }
        Vector<GridItem> selectedRows = new Vector<GridItem>();
        for (Point cell : this.selectedCells) {
            GridItem item = this.getItem(cell.y);
            if (selectedRows.contains((Object)item)) continue;
            selectedRows.add(item);
        }
        int[] indices = new int[selectedRows.size()];
        int i = 0;
        for (GridItem item : selectedRows) {
            indices[i] = item.getRowIndex();
            ++i;
        }
        return indices;
    }

    public int getTopIndex() {
        this.checkWidget();
        if (this.topIndex != -1) {
            return this.topIndex;
        }
        if (!this.vScroll.getVisible()) {
            this.topIndex = 0;
        } else {
            int firstVisibleIndex = this.vScroll.getSelection();
            if (this.isTree) {
                Iterator<GridItem> itemsIter = this.items.iterator();
                int row = firstVisibleIndex + 1;
                while (row > 0 && itemsIter.hasNext()) {
                    GridItem item = itemsIter.next();
                    if (!item.isVisible() || --row != 0) continue;
                    firstVisibleIndex = item.getRowIndex();
                }
            }
            this.topIndex = firstVisibleIndex;
        }
        return this.topIndex;
    }

    int getBottomIndex() {
        this.checkWidget();
        if (this.bottomIndex != -1) {
            return this.bottomIndex;
        }
        if (this.items.size() == 0) {
            this.bottomIndex = 0;
        } else if (this.getVisibleGridHeight() < 1) {
            this.bottomIndex = this.getTopIndex();
        } else {
            RowRange range = this.getRowRange(this.getTopIndex(), this.getVisibleGridHeight(), false, false);
            this.bottomIndex = range.endIndex;
            this.bottomIndexShownCompletely = range.height <= this.getVisibleGridHeight();
        }
        return this.bottomIndex;
    }

    private RowRange getRowRange(int startIndex, int endIndex) {
        if (startIndex == -1) {
            while (++startIndex < this.items.size() && !this.items.get(startIndex).isVisible()) {
            }
            if (startIndex == this.items.size()) {
                return null;
            }
        }
        if (endIndex == -1) {
            endIndex = this.items.size();
            while (--endIndex >= 0 && !this.items.get(endIndex).isVisible()) {
            }
            if (endIndex == -1) {
                return null;
            }
        }
        if (startIndex < 0 || endIndex < 0 || startIndex >= this.items.size() || endIndex >= this.items.size() || endIndex < startIndex || !this.items.get(startIndex).isVisible() || !this.items.get(endIndex).isVisible()) {
            SWT.error((int)5);
        }
        RowRange range = new RowRange();
        range.startIndex = startIndex;
        range.endIndex = endIndex;
        if (this.isTree || this.hasDifferingHeights) {
            int idx = startIndex;
            while (idx <= endIndex) {
                GridItem currItem = this.items.get(idx);
                if (currItem.isVisible()) {
                    if (range.rows > 0) {
                        ++range.height;
                    }
                    range.height += currItem.getHeight();
                    ++range.rows;
                }
                ++idx;
            }
        } else {
            range.rows = range.endIndex - range.startIndex + 1;
            range.height = (this.itemHeight + 1) * range.rows - 1;
        }
        return range;
    }

    private RowRange getRowRange(int startIndex, int availableHeight, boolean forceEndCompletelyInside, boolean inverse) {
        if (startIndex == -1) {
            if (!inverse) {
                while (++startIndex < this.items.size() && !this.items.get(startIndex).isVisible()) {
                }
                if (startIndex == this.items.size()) {
                    return null;
                }
            } else {
                startIndex = this.items.size();
                while (--startIndex >= 0 && !this.items.get(startIndex).isVisible()) {
                }
                if (startIndex == -1) {
                    return null;
                }
            }
        }
        if (startIndex < 0 || startIndex >= this.items.size() || !this.items.get(startIndex).isVisible()) {
            SWT.error((int)5);
        }
        RowRange range = new RowRange();
        if (availableHeight <= 0) {
            range.startIndex = startIndex;
            range.endIndex = startIndex;
            range.rows = 0;
            range.height = 0;
            return range;
        }
        if (this.isTree || this.hasDifferingHeights) {
            int otherIndex = startIndex;
            int consumedItems = 0;
            int consumedHeight = 0;
            ++consumedItems;
            consumedHeight += this.items.get(otherIndex).getHeight();
            while (consumedHeight + 2 <= availableHeight) {
                GridItem nextItem;
                int nextIndex = otherIndex;
                do {
                    if (!inverse) {
                        ++nextIndex;
                        continue;
                    }
                    --nextIndex;
                } while ((nextItem = nextIndex >= 0 && nextIndex < this.items.size() ? this.items.get(nextIndex) : null) != null && !nextItem.isVisible());
                if (nextItem == null || forceEndCompletelyInside && consumedHeight + 1 + nextItem.getHeight() > availableHeight) break;
                ++consumedItems;
                ++consumedHeight;
                consumedHeight += nextItem.getHeight();
                otherIndex = nextIndex;
            }
            range.startIndex = !inverse ? startIndex : otherIndex;
            range.endIndex = !inverse ? otherIndex : startIndex;
            range.rows = consumedItems;
            range.height = consumedHeight;
        } else {
            int otherIndex;
            int availableRows = (availableHeight + 1) / (this.itemHeight + 1);
            if ((this.itemHeight + 1) * range.rows - 1 + 1 < availableHeight && !forceEndCompletelyInside) {
                ++availableRows;
            }
            if ((otherIndex = startIndex + (availableRows - 1) * (!inverse ? 1 : -1)) < 0) {
                otherIndex = 0;
            }
            if (otherIndex >= this.items.size()) {
                otherIndex = this.items.size() - 1;
            }
            range.startIndex = !inverse ? startIndex : otherIndex;
            range.endIndex = !inverse ? otherIndex : startIndex;
            range.rows = range.endIndex - range.startIndex + 1;
            range.height = (this.itemHeight + 1) * range.rows - 1;
        }
        return range;
    }

    int getGridHeight() {
        RowRange range = this.getRowRange(-1, -1);
        return range != null ? range.height : 0;
    }

    int getVisibleGridHeight() {
        return this.getClientArea().height - (this.columnHeadersVisible ? this.headerHeight : 0) - (this.columnFootersVisible ? this.footerHeight : 0);
    }

    int getVisibleGridWidth() {
        return this.getClientArea().width - (this.rowHeaderVisible ? this.rowHeaderWidth : 0);
    }

    public IRenderer getTopLeftRenderer() {
        this.checkWidget();
        return this.topLeftRenderer;
    }

    public IRenderer getBottomLeftRenderer() {
        this.checkWidget();
        return this.bottomLeftRenderer;
    }

    public int indexOf(GridColumn column) {
        this.checkWidget();
        if (column == null) {
            SWT.error((int)4);
        }
        if (column.getParent() != this) {
            return -1;
        }
        return column.index;
    }

    public int indexOf(GridItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error((int)4);
        }
        if (item.getParent() != this) {
            return -1;
        }
        return this.items.indexOf((Object)item);
    }

    public boolean isRowHeaderVisible() {
        this.checkWidget();
        return this.rowHeaderVisible;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            return false;
        }
        if (!this.cellSelectionEnabled) {
            return this.isSelected(this.items.get(index));
        }
        for (Point cell : this.selectedCells) {
            if (cell.y != index) continue;
            return true;
        }
        return false;
    }

    public boolean isSelected(GridItem item) {
        this.checkWidget();
        if (!this.cellSelectionEnabled) {
            return this.selectedItems.contains((Object)item);
        }
        int index = item.getRowIndex();
        if (index == -1) {
            return false;
        }
        for (Point cell : this.selectedCells) {
            if (cell.y != index) continue;
            return true;
        }
        return false;
    }

    public boolean isCellSelected(Point cell) {
        this.checkWidget();
        if (cell == null) {
            SWT.error((int)4);
        }
        return this.selectedCells.contains(cell);
    }

    public void remove(int index) {
        this.checkWidget();
        if (index < 0 || index > this.items.size() - 1) {
            SWT.error((int)6);
        }
        GridItem item = this.items.get(index);
        item.dispose();
        this.redraw();
    }

    public void remove(int start, int end) {
        this.checkWidget();
        int i = end;
        while (i >= start) {
            if (i < 0 || i > this.items.size() - 1) {
                SWT.error((int)6);
            }
            GridItem item = this.items.get(i);
            item.dispose();
            --i;
        }
        this.redraw();
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        GridItem[] removeThese = new GridItem[indices.length];
        int i = 0;
        while (i < indices.length) {
            int j = indices[i];
            if (j < this.items.size() && j >= 0) {
                removeThese[i] = this.items.get(j);
            } else {
                SWT.error((int)6);
            }
            ++i;
        }
        GridItem[] gridItemArray = removeThese;
        int n = removeThese.length;
        int n2 = 0;
        while (n2 < n) {
            GridItem item = gridItemArray[n2];
            item.dispose();
            ++n2;
        }
        this.redraw();
    }

    @Deprecated
    public void removeAll() {
        this.checkWidget();
        while (this.items.size() > 0) {
            this.items.get(0).dispose();
        }
        this.deselectAll();
        this.redraw();
    }

    public void disposeAllItems() {
        GridItem[] items;
        this.checkWidget();
        GridItem[] gridItemArray = items = this.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            GridItem gridItem = gridItemArray[n2];
            gridItem.disposeOnly();
            ++n2;
        }
        this.clearItems();
        this.scrollValuesObsolete = true;
        this.topIndex = -1;
        this.bottomIndex = -1;
        this.currentVisibleItems = 0;
        this.updateColumnSelection();
        this.focusItem = null;
        this.selectedItems.clear();
        this.redraw();
        this.updateScrollbars();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.removeTypedListener(13, (EventListener)listener);
        this.removeTypedListener(14, (EventListener)listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.removeTypedListener(17, (EventListener)listener);
        this.removeTypedListener(18, (EventListener)listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (!this.selectionEnabled) {
            return;
        }
        if (index < 0 || index >= this.items.size()) {
            return;
        }
        GridItem item = this.items.get(index);
        if (!this.cellSelectionEnabled) {
            if (this.selectionType == GridSelectionType.MULTI && this.selectedItems.contains((Object)item)) {
                return;
            }
            if (this.selectionType == GridSelectionType.SINGLE) {
                this.selectedItems.clear();
            }
            this.selectedItems.add(item);
        } else {
            this.selectCells(this.getCells(item));
        }
        this.redraw();
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (!this.selectionEnabled) {
            return;
        }
        if (this.selectionType == GridSelectionType.SINGLE && start != end) {
            return;
        }
        if (!this.cellSelectionEnabled && this.selectionType == GridSelectionType.SINGLE) {
            this.selectedItems.clear();
        }
        int i = start;
        while (i <= end) {
            if (i >= 0) {
                if (i > this.items.size() - 1) break;
                GridItem item = this.items.get(i);
                if (!this.cellSelectionEnabled) {
                    if (!this.selectedItems.contains((Object)item)) {
                        this.selectedItems.add(item);
                    }
                } else {
                    this.selectCells(this.getCells(item));
                }
            }
            ++i;
        }
        this.redraw();
    }

    public void select(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        if (!this.selectionEnabled) {
            return;
        }
        if (this.selectionType == GridSelectionType.SINGLE && indices.length > 1) {
            return;
        }
        if (!this.cellSelectionEnabled && this.selectionType == GridSelectionType.SINGLE) {
            this.selectedItems.clear();
        }
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int j = nArray[n2];
            if (j >= 0 && j < this.items.size()) {
                GridItem item = this.items.get(j);
                if (!this.cellSelectionEnabled) {
                    if (!this.selectedItems.contains((Object)item)) {
                        this.selectedItems.add(item);
                    }
                } else {
                    this.selectCells(this.getCells(item));
                }
            }
            ++n2;
        }
        this.redraw();
    }

    public void selectAll() {
        this.checkWidget();
        if (!this.selectionEnabled) {
            return;
        }
        if (this.selectionType == GridSelectionType.SINGLE) {
            return;
        }
        if (this.cellSelectionEnabled) {
            this.selectAllCells();
            return;
        }
        this.selectedItems.clear();
        this.selectedItems.addAll(this.items);
        this.redraw();
    }

    public void setEmptyCellRenderer(GridCellRenderer emptyCellRenderer) {
        this.checkWidget();
        emptyCellRenderer.setDisplay(this.getDisplay());
        this.emptyCellRenderer = emptyCellRenderer;
    }

    public void setEmptyColumnHeaderRenderer(IRenderer emptyColumnHeaderRenderer) {
        this.checkWidget();
        emptyColumnHeaderRenderer.setDisplay(this.getDisplay());
        this.emptyColumnHeaderRenderer = emptyColumnHeaderRenderer;
    }

    public void setEmptyColumnFooterRenderer(IRenderer emptyColumnFooterRenderer) {
        this.checkWidget();
        emptyColumnFooterRenderer.setDisplay(this.getDisplay());
        this.emptyColumnFooterRenderer = emptyColumnFooterRenderer;
    }

    public void setEmptyRowHeaderRenderer(IRenderer emptyRowHeaderRenderer) {
        this.checkWidget();
        emptyRowHeaderRenderer.setDisplay(this.getDisplay());
        this.emptyRowHeaderRenderer = emptyRowHeaderRenderer;
    }

    protected void setHorizontalScrollBarProxy(IScrollBarProxy scroll) {
        this.checkWidget();
        if (this.getHorizontalBar() != null) {
            return;
        }
        this.hScroll = scroll;
        this.hScroll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Grid.this.onScrollSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void setlVerticalScrollBarProxy(IScrollBarProxy scroll) {
        this.checkWidget();
        if (this.getVerticalBar() != null) {
            return;
        }
        this.vScroll = scroll;
        this.vScroll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Grid.this.onScrollSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void setFocusRenderer(IRenderer focusRenderer) {
        this.checkWidget();
        this.focusRenderer = focusRenderer;
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        this.columnHeadersVisible = show;
        this.redraw();
    }

    public void setFooterVisible(boolean show) {
        this.checkWidget();
        this.columnFootersVisible = show;
        this.redraw();
    }

    public void setLineColor(Color lineColor) {
        this.checkWidget();
        this.lineColor = lineColor;
    }

    public void setLinesVisible(boolean linesVisible) {
        this.checkWidget();
        this.linesVisible = linesVisible;
        this.redraw();
    }

    public void setTreeLinesVisible(boolean treeLinesVisible) {
        this.checkWidget();
        this.treeLinesVisible = treeLinesVisible;
        this.redraw();
    }

    public void setRowHeaderRenderer(IRenderer rowHeaderRenderer) {
        this.checkWidget();
        rowHeaderRenderer.setDisplay(this.getDisplay());
        this.rowHeaderRenderer = rowHeaderRenderer;
    }

    public void setRowHeaderVisible(boolean show) {
        this.setRowHeaderVisible(show, 1);
    }

    public void setRowHeaderVisible(boolean show, int minWidth) {
        this.checkWidget();
        this.rowHeaderVisible = show;
        this.setColumnScrolling(true);
        if (show && this.isAutoWidth()) {
            this.computeRowHeaderWidth(minWidth);
        }
        this.redraw();
    }

    public void setSelection(int index) {
        this.checkWidget();
        if (!this.selectionEnabled) {
            return;
        }
        if (index >= 0 && index < this.items.size()) {
            if (!this.cellSelectionEnabled) {
                this.selectedItems.clear();
                this.selectedItems.add(this.items.get(index));
                this.redraw();
            } else {
                this.selectedCells.clear();
                this.selectCells(this.getCells(this.items.get(index)));
            }
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        if (!this.selectionEnabled) {
            return;
        }
        if (this.selectionType == GridSelectionType.SINGLE && start != end) {
            return;
        }
        if (!this.cellSelectionEnabled) {
            this.selectedItems.clear();
        } else {
            this.selectedCells.clear();
        }
        int i = start;
        while (i <= end) {
            if (i >= 0) {
                if (i > this.items.size() - 1) break;
                GridItem item = this.items.get(i);
                if (!this.cellSelectionEnabled) {
                    this.selectedItems.add(item);
                } else {
                    this.selectCells(this.getCells(item));
                }
            }
            ++i;
        }
        this.redraw();
    }

    public boolean isVisibleLinesColumnPack() {
        return this.visibleLinesBasedColumnPack;
    }

    public void setVisibleLinesColumnPack(boolean visibleLinesBasedColumnPack) {
        this.visibleLinesBasedColumnPack = visibleLinesBasedColumnPack;
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (!this.selectionEnabled) {
            return;
        }
        if (this.selectionType == GridSelectionType.SINGLE && indices.length > 1) {
            return;
        }
        if (!this.cellSelectionEnabled) {
            this.selectedItems.clear();
        } else {
            this.selectedCells.clear();
        }
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int j = nArray[n2];
            if (j >= 0) {
                if (j > this.items.size() - 1) break;
                GridItem item = this.items.get(j);
                if (!this.cellSelectionEnabled) {
                    this.selectedItems.add(item);
                } else {
                    this.selectCells(this.getCells(item));
                }
            }
            ++n2;
        }
        this.redraw();
    }

    public void setSelection(GridItem[] _items) {
        this.checkWidget();
        if (!this.selectionEnabled) {
            return;
        }
        if (_items == null) {
            SWT.error((int)4);
        }
        if (this.selectionType == GridSelectionType.SINGLE && _items.length > 1) {
            return;
        }
        if (!this.cellSelectionEnabled) {
            this.selectedItems.clear();
        } else {
            this.selectedCells.clear();
        }
        GridItem[] gridItemArray = _items;
        int n = _items.length;
        int n2 = 0;
        while (n2 < n) {
            GridItem item = gridItemArray[n2];
            if (item != null) {
                if (item.isDisposed()) {
                    SWT.error((int)5);
                }
                if (item.getParent() == this) {
                    if (!this.cellSelectionEnabled) {
                        this.selectedItems.add(item);
                    } else {
                        this.selectCells(this.getCells(item));
                    }
                }
            }
            ++n2;
        }
        this.redraw();
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            return;
        }
        GridItem item = this.items.get(index);
        if (!item.isVisible()) {
            return;
        }
        if (!this.vScroll.getVisible()) {
            return;
        }
        int vScrollAmount = 0;
        int i = 0;
        while (i < index) {
            if (this.items.get(i).isVisible()) {
                ++vScrollAmount;
            }
            ++i;
        }
        this.vScroll.setSelection(vScrollAmount);
        this.topIndex = -1;
        this.bottomIndex = -1;
        this.redraw();
    }

    public void setTopLeftRenderer(IRenderer topLeftRenderer) {
        this.checkWidget();
        topLeftRenderer.setDisplay(this.getDisplay());
        this.topLeftRenderer = topLeftRenderer;
    }

    public void setBottomLeftRenderer(IRenderer bottomLeftRenderer) {
        this.checkWidget();
        bottomLeftRenderer.setDisplay(this.getDisplay());
        this.bottomLeftRenderer = bottomLeftRenderer;
    }

    public void showColumn(GridColumn col) {
        this.checkWidget();
        if (!col.isVisible()) {
            GridColumnGroup group;
            group.setExpanded(!(group = col.getColumnGroup()).getExpanded());
            if (group.getExpanded()) {
                group.notifyListeners(17, new Event());
            } else {
                group.notifyListeners(18, new Event());
            }
        }
        if (!this.hScroll.getVisible()) {
            return;
        }
        int x = this.getColumnHeaderXPosition(col);
        int firstVisibleX = 0;
        if (this.rowHeaderVisible) {
            firstVisibleX = this.rowHeaderWidth;
        }
        if (x >= firstVisibleX && x + col.getWidth() <= firstVisibleX + this.getClientArea().width - firstVisibleX) {
            return;
        }
        if (!this.getColumnScrolling()) {
            if (x < firstVisibleX) {
                this.hScroll.setSelection(this.getHScrollSelectionInPixels() - (firstVisibleX - x));
            } else if (col.getWidth() > this.getClientArea().width - firstVisibleX) {
                this.hScroll.setSelection(this.getHScrollSelectionInPixels() + x - firstVisibleX);
            } else {
                this.hScroll.setSelection(this.getHScrollSelectionInPixels() + (x -= this.getClientArea().width - firstVisibleX - col.getWidth()) - firstVisibleX);
            }
        } else if (x < firstVisibleX || col.getWidth() > this.getClientArea().width - firstVisibleX) {
            int sel = this.displayOrderedColumns.indexOf((Object)col);
            this.hScroll.setSelection(sel);
        } else {
            int availableWidth = this.getClientArea().width - firstVisibleX - col.getWidth();
            GridColumn prevCol = this.getPreviousVisibleColumn(col);
            GridColumn currentScrollTo = col;
            while (true) {
                if (prevCol == null || prevCol.getWidth() > availableWidth) {
                    int sel = this.displayOrderedColumns.indexOf((Object)currentScrollTo);
                    this.hScroll.setSelection(sel);
                    break;
                }
                availableWidth -= prevCol.getWidth();
                currentScrollTo = prevCol;
                prevCol = this.getPreviousVisibleColumn(prevCol);
            }
        }
        this.redraw();
    }

    boolean isShown(GridItem item) {
        this.checkWidget();
        if (!item.isVisible()) {
            return false;
        }
        int itemIndex = item.getRowIndex();
        if (itemIndex == -1) {
            SWT.error((int)5);
        }
        int firstVisibleIndex = this.getTopIndex();
        int lastVisibleIndex = this.getBottomIndex();
        return itemIndex >= firstVisibleIndex && itemIndex < lastVisibleIndex || itemIndex == lastVisibleIndex && this.bottomIndexShownCompletely;
    }

    public void showItem(GridItem item) {
        int newTopIndex;
        this.checkWidget();
        this.updateScrollbars();
        if (this.getVisibleGridHeight() < 1) {
            return;
        }
        if (this.isShown(item)) {
            return;
        }
        if (!item.isVisible()) {
            GridItem parent = item.getParentItem();
            do {
                if (parent.isExpanded()) continue;
                parent.setExpanded(true);
                parent.fireEvent(17);
            } while ((parent = parent.getParentItem()) != null);
        }
        if ((newTopIndex = item.getRowIndex()) >= this.getBottomIndex()) {
            RowRange range = this.getRowRange(newTopIndex, this.getVisibleGridHeight(), true, true);
            newTopIndex = range.startIndex;
        }
        this.setTopIndex(newTopIndex);
    }

    public void showSelection() {
        this.checkWidget();
        if (this.scrollValuesObsolete) {
            this.updateScrollbars();
        }
        if (!this.cellSelectionEnabled) {
            if (this.selectedItems.size() == 0) {
                return;
            }
            this.showItem(this.selectedItems.get(0));
        } else {
            if (this.selectedCells.size() == 0) {
                return;
            }
            this.showItem(this.getItem(this.selectedCells.get((int)0).y));
            this.showColumn(this.getColumn(this.selectedCells.get((int)0).x));
        }
    }

    public void setSelectionEnabled(boolean selectionEnabled) {
        this.checkWidget();
        if (!selectionEnabled) {
            this.selectedItems.clear();
            this.redraw();
        }
        this.selectionEnabled = selectionEnabled;
    }

    public boolean getSelectionEnabled() {
        this.checkWidget();
        return this.selectionEnabled;
    }

    private void computeHeaderHeight(GC gc) {
        int colHeaderHeight = 0;
        for (GridColumn column : this.columns) {
            colHeaderHeight = Math.max(column.getHeaderHeight(gc), colHeaderHeight);
        }
        int groupHeight = 0;
        GridColumnGroup[] gridColumnGroupArray = this.columnGroups;
        int n = this.columnGroups.length;
        int n2 = 0;
        while (n2 < n) {
            GridColumnGroup group = gridColumnGroupArray[n2];
            groupHeight = Math.max(group.getHeaderRenderer().computeSize((GC)gc, (int)-1, (int)-1, (Object)((Object)group)).y, groupHeight);
            ++n2;
        }
        this.headerHeight = colHeaderHeight + groupHeight;
        this.groupHeaderHeight = groupHeight;
    }

    private void computeHeaderHeight() {
        this.estimate(this::computeHeaderHeight);
    }

    private void computeFooterHeight(GC gc) {
        int colFooterHeight = 0;
        for (GridColumn column : this.columns) {
            colFooterHeight = Math.max(column.getFooterHeight(gc), colFooterHeight);
        }
        this.footerHeight = colFooterHeight;
    }

    private int computeItemHeight(GridItem item, GC gc) {
        int height = 1;
        if (this.columns.size() == 0 || this.items.size() == 0) {
            return height;
        }
        for (GridColumn column : this.columns) {
            column.getCellRenderer().setColumn(column.index);
            height = Math.max(height, column.getCellRenderer().computeSize((GC)gc, (int)-1, (int)-1, (Object)((Object)item)).y);
        }
        if (this.rowHeaderVisible && this.rowHeaderRenderer != null) {
            height = Math.max(height, this.rowHeaderRenderer.computeSize((GC)gc, (int)-1, (int)-1, (Object)((Object)item)).y);
        }
        return height <= 0 ? 16 : height;
    }

    private int computeItemHeight(GridItem item) {
        return this.estimateWithResult(sizingGC -> this.computeItemHeight(item, (GC)sizingGC));
    }

    private int getColumnHeaderXPosition(GridColumn column) {
        if (!column.isVisible()) {
            return -1;
        }
        int x = 0;
        x -= this.getHScrollSelectionInPixels();
        if (this.rowHeaderVisible) {
            x += this.rowHeaderWidth;
        }
        for (GridColumn column2 : this.displayOrderedColumns) {
            if (!column2.isVisible()) continue;
            if (column2 == column) break;
            x += column2.getWidth();
        }
        return x;
    }

    private int getHScrollSelectionInPixels() {
        int selection = this.hScroll.getSelection();
        if (this.columnScrolling) {
            int pixels = 0;
            int i = 0;
            while (i < selection) {
                GridColumn gridColumn = this.displayOrderedColumns.get(i);
                if (gridColumn.isVisible()) {
                    pixels += gridColumn.getWidth();
                } else if (selection < this.displayOrderedColumns.size() - 1) {
                    ++selection;
                }
                ++i;
            }
            selection = pixels;
        }
        return selection;
    }

    private Point getTableSize() {
        int x = 0;
        int y = 0;
        if (this.columnHeadersVisible) {
            y += this.headerHeight;
        }
        if (this.columnFootersVisible) {
            y += this.footerHeight;
        }
        y += this.getGridHeight();
        if (this.rowHeaderVisible) {
            x += this.rowHeaderWidth;
        }
        for (GridColumn column : this.columns) {
            if (!column.isVisible()) continue;
            x += column.getWidth();
        }
        return new Point(x, y);
    }

    private boolean handleColumnDragging(int x) {
        GridColumn local_dragDropBeforeColumn = null;
        GridColumn local_dragDropAfterColumn = null;
        int x2 = 1;
        if (this.rowHeaderVisible) {
            x2 += this.rowHeaderWidth + 1;
        }
        GridColumn previousVisibleCol = null;
        boolean nextVisibleColumnIsBeforeCol = false;
        GridColumn firstVisibleCol = null;
        GridColumn lastVisibleCol = null;
        if (x < (x2 -= this.getHScrollSelectionInPixels())) {
            for (GridColumn column : this.displayOrderedColumns) {
                if (!column.isVisible()) continue;
                local_dragDropBeforeColumn = column;
                break;
            }
            local_dragDropAfterColumn = null;
        } else {
            for (GridColumn column : this.displayOrderedColumns) {
                if (!column.isVisible()) continue;
                if (firstVisibleCol == null) {
                    firstVisibleCol = column;
                }
                lastVisibleCol = column;
                if (nextVisibleColumnIsBeforeCol) {
                    local_dragDropBeforeColumn = column;
                    nextVisibleColumnIsBeforeCol = false;
                }
                if (x >= x2 && x <= x2 + column.getWidth()) {
                    if (x <= x2 + column.getWidth() / 2) {
                        local_dragDropBeforeColumn = column;
                        local_dragDropAfterColumn = previousVisibleCol;
                    } else {
                        local_dragDropAfterColumn = column;
                        nextVisibleColumnIsBeforeCol = true;
                    }
                }
                x2 += column.getWidth();
                previousVisibleCol = column;
            }
            if (local_dragDropBeforeColumn == null) {
                local_dragDropAfterColumn = lastVisibleCol;
            }
        }
        this.currentHeaderDragX = x;
        if (local_dragDropBeforeColumn != this.dragDropBeforeColumn || this.dragDropBeforeColumn == null && this.dragDropAfterColumn == null) {
            this.dragDropPointValid = true;
            if (this.columnGroups.length != 0) {
                if (this.columnBeingPushed.getColumnGroup() == null) {
                    if (local_dragDropBeforeColumn != null && local_dragDropAfterColumn != null && local_dragDropBeforeColumn.getColumnGroup() != null && local_dragDropBeforeColumn.getColumnGroup() == local_dragDropAfterColumn.getColumnGroup()) {
                        this.dragDropPointValid = false;
                    }
                } else if (!(local_dragDropBeforeColumn != null && local_dragDropBeforeColumn.getColumnGroup() == this.columnBeingPushed.getColumnGroup() || local_dragDropAfterColumn != null && local_dragDropAfterColumn.getColumnGroup() == this.columnBeingPushed.getColumnGroup())) {
                    this.dragDropPointValid = false;
                }
            } else {
                this.dragDropPointValid = true;
            }
        }
        this.dragDropBeforeColumn = local_dragDropBeforeColumn;
        this.dragDropAfterColumn = local_dragDropAfterColumn;
        Rectangle clientArea = this.getClientArea();
        this.redraw(clientArea.x, clientArea.y, clientArea.width, clientArea.height, false);
        return true;
    }

    private void handleColumnDrop() {
        this.draggingColumn = false;
        if (this.dragDropBeforeColumn != this.columnBeingPushed && this.dragDropAfterColumn != this.columnBeingPushed && (this.columnGroups.length == 0 || this.dragDropPointValid)) {
            int notifyFrom;
            int notifyTo = notifyFrom = this.displayOrderedColumns.indexOf((Object)this.columnBeingPushed);
            this.displayOrderedColumns.remove((Object)this.columnBeingPushed);
            if (this.dragDropBeforeColumn == null) {
                notifyTo = this.displayOrderedColumns.size();
                this.displayOrderedColumns.add(this.columnBeingPushed);
            } else if (this.dragDropAfterColumn == null) {
                this.displayOrderedColumns.add(0, this.columnBeingPushed);
                notifyFrom = 0;
            } else {
                int insertAtIndex = 0;
                if (this.columnGroups.length != 0) {
                    if (this.dragDropBeforeColumn.getColumnGroup() == this.columnBeingPushed.getColumnGroup()) {
                        insertAtIndex = this.displayOrderedColumns.indexOf((Object)this.dragDropBeforeColumn);
                    } else if (this.dragDropAfterColumn.getColumnGroup() == this.columnBeingPushed.getColumnGroup()) {
                        insertAtIndex = this.displayOrderedColumns.indexOf((Object)this.dragDropAfterColumn) + 1;
                    } else if (this.dragDropBeforeColumn.getColumnGroup() == null) {
                        insertAtIndex = this.displayOrderedColumns.indexOf((Object)this.dragDropBeforeColumn);
                    } else {
                        GridColumnGroup beforeGroup = this.dragDropBeforeColumn.getColumnGroup();
                        insertAtIndex = this.displayOrderedColumns.indexOf((Object)this.dragDropBeforeColumn);
                        while (insertAtIndex > 0 && this.displayOrderedColumns.get(insertAtIndex - 1).getColumnGroup() == beforeGroup) {
                            --insertAtIndex;
                        }
                    }
                } else {
                    insertAtIndex = this.displayOrderedColumns.indexOf((Object)this.dragDropBeforeColumn);
                }
                this.displayOrderedColumns.add(insertAtIndex, this.columnBeingPushed);
                notifyFrom = Math.min(notifyFrom, insertAtIndex);
                notifyTo = Math.max(notifyTo, insertAtIndex);
            }
            int i = notifyFrom;
            while (i <= notifyTo) {
                this.displayOrderedColumns.get(i).fireMoved();
                ++i;
            }
            this.clearDisplayOrderedCache();
        }
        this.redraw();
    }

    private boolean handleColumnHeaderHoverWhilePushing(int x, int y) {
        GridColumn overThis = this.overColumnHeader(x, y);
        if (overThis == this.columnBeingPushed != this.pushingAndHovering) {
            this.pushingAndHovering = overThis == this.columnBeingPushed;
            this.redraw();
        }
        if (this.columnBeingPushed.getMoveable() && this.pushingAndHovering && Math.abs(this.startHeaderPushX - x) > 3) {
            this.pushingColumn = false;
            this.columnBeingPushed.getHeaderRenderer().setMouseDown(false);
            this.columnBeingPushed.getHeaderRenderer().setHover(false);
            this.draggingColumn = true;
            this.columnBeingPushed.getHeaderRenderer().setMouseDown(false);
            this.startHeaderDragX = x;
            this.dragDropAfterColumn = null;
            this.dragDropBeforeColumn = null;
            this.dragDropPointValid = true;
            this.handleColumnDragging(x);
        }
        return true;
    }

    private boolean handleColumnGroupHeaderClick(int x, int y) {
        if (!this.columnHeadersVisible) {
            return false;
        }
        GridColumnGroup overThis = this.overColumnGroupHeader(x, y);
        if (overThis == null) {
            return false;
        }
        int headerX = 0;
        if (this.rowHeaderVisible) {
            headerX += this.rowHeaderWidth;
        }
        int width = 0;
        boolean firstCol = false;
        for (GridColumn col : this.displayOrderedColumns) {
            if (col.getColumnGroup() == overThis && col.isVisible()) {
                firstCol = true;
                width += col.getWidth();
            }
            if (firstCol || !col.isVisible()) continue;
            headerX += col.getWidth();
        }
        overThis.getHeaderRenderer().setBounds(headerX - this.getHScrollSelectionInPixels(), 0, width, this.groupHeaderHeight);
        return overThis.getHeaderRenderer().notify(3, new Point(x, y), (Object)overThis);
    }

    private boolean handleColumnHeaderPush(int x, int y) {
        GridColumn overThis;
        boolean clickOnScrollBar;
        if (!this.columnHeadersVisible) {
            return false;
        }
        ScrollBar verticalBar = this.getVerticalBar();
        boolean bl = clickOnScrollBar = x >= this.getClientArea().width;
        if (clickOnScrollBar && verticalBar != null && verticalBar.isVisible()) {
            verticalBar.setSelection(verticalBar.getSelection() - verticalBar.getIncrement());
        }
        if ((overThis = this.overColumnHeader(x, y)) == null) {
            return false;
        }
        this.columnBeingPushed = overThis;
        this.columnBeingPushed.getHeaderRenderer().setMouseDown(true);
        this.columnBeingPushed.getHeaderRenderer().setHover(true);
        this.pushingAndHovering = true;
        this.redraw();
        this.startHeaderPushX = x;
        this.pushingColumn = true;
        this.setCapture(true);
        return true;
    }

    private boolean handleColumnFooterPush(int x, int y) {
        if (!this.columnFootersVisible) {
            return false;
        }
        return this.overColumnFooter(x, y) != null;
    }

    private void handleColumnResizerDragging(int x) {
        int newWidth = this.resizingColumnStartWidth + x - this.resizingStartX;
        if (newWidth < 20) {
            newWidth = 20;
        }
        if (this.columnScrolling) {
            int maxWidth = this.getClientArea().width;
            if (this.rowHeaderVisible) {
                maxWidth -= this.rowHeaderWidth;
            }
            if (newWidth > maxWidth) {
                newWidth = maxWidth;
            }
        }
        if (newWidth == this.columnBeingResized.getWidth()) {
            return;
        }
        this.columnBeingResized.setWidth(newWidth, false);
        this.scrollValuesObsolete = true;
        Rectangle clientArea = this.getClientArea();
        this.redraw(clientArea.x, clientArea.y, clientArea.width, clientArea.height, false);
        this.columnBeingResized.fireResized();
        this.fireColumnsMoved();
    }

    void fireColumnsMoved() {
        int index = this.displayOrderedColumns.indexOf((Object)this.columnBeingResized) + 1;
        while (index < this.displayOrderedColumns.size()) {
            GridColumn col = this.displayOrderedColumns.get(index);
            if (col.isVisible()) {
                col.fireMoved();
            }
            ++index;
        }
    }

    void handlePacked(GridColumn column) {
        int index = 0;
        if (this.getHorizontalBar() != null && !this.getHorizontalBar().isVisible()) {
            index = this.displayOrderedColumns.indexOf((Object)column);
        }
        while (index < this.displayOrderedColumns.size()) {
            GridColumn col = this.displayOrderedColumns.get(index);
            if (col.isVisible()) {
                col.fireMoved();
            }
            ++index;
        }
    }

    private void handleRowResizerDragging(int y) {
        int newHeight = this.resizingRowStartHeight + y - this.resizingStartY;
        if (newHeight < 10) {
            newHeight = 10;
        }
        if (newHeight > this.getClientArea().height) {
            newHeight = this.getClientArea().height;
        }
        if (this.rowBeingResized == null || newHeight == this.rowBeingResized.getHeight()) {
            return;
        }
        Event e = new Event();
        e.item = this.rowBeingResized;
        e.widget = this;
        e.detail = newHeight;
        this.rowBeingResized.notifyListeners(11, e);
        if (!e.doit) {
            return;
        }
        newHeight = e.detail;
        if (newHeight < 10) {
            newHeight = 10;
        }
        if (newHeight > this.getClientArea().height) {
            newHeight = this.getClientArea().height;
        }
        this.rowBeingResized.setHeight(newHeight);
        this.scrollValuesObsolete = true;
        Rectangle clientArea = this.getClientArea();
        this.redraw(clientArea.x, clientArea.y, clientArea.width, clientArea.height, false);
    }

    private boolean handleHoverOnColumnResizer(int x, int y) {
        boolean over = false;
        if (y <= this.headerHeight) {
            int x2 = 0;
            if (this.rowHeaderVisible) {
                x2 += this.rowHeaderWidth;
            }
            x2 -= this.getHScrollSelectionInPixels();
            int extraFill = this.getExtraFill();
            for (GridColumn column : this.displayOrderedColumns) {
                if (!column.isVisible() || (x2 += column.getWidth(extraFill)) < x - 4 || x2 > x + 4) continue;
                if (!column.getResizeable() || column.getColumnGroup() != null && y <= this.groupHeaderHeight && column != column.getColumnGroup().getLastVisibleColumn()) break;
                over = true;
                this.columnBeingResized = column;
                break;
            }
        }
        if (over != this.hoveringOnColumnResizer) {
            if (over) {
                this.setCursor(this.getDisplay().getSystemCursor(9));
            } else {
                this.columnBeingResized = null;
                this.setCursor(null);
            }
            this.hoveringOnColumnResizer = over;
        }
        return over;
    }

    private boolean handleHoverOnRowResizer(int x, int y) {
        this.rowBeingResized = null;
        boolean over = false;
        if (x <= this.rowHeaderWidth) {
            int y2 = 0;
            if (this.columnHeadersVisible) {
                y2 += this.headerHeight;
            }
            int row = this.getTopIndex();
            while (row < this.items.size() && y2 <= this.getClientArea().height) {
                GridItem currItem = this.items.get(row);
                if (currItem.isVisible()) {
                    if ((y2 += currItem.getHeight() + 1) >= y - 3 && y2 <= y + 3) {
                        over = true;
                        this.rowBeingResized = currItem;
                    } else if (this.rowBeingResized != null) break;
                }
                ++row;
            }
        }
        if (over != this.hoveringOnRowResizer) {
            if (over) {
                this.setCursor(this.getDisplay().getSystemCursor(7));
            } else {
                this.rowBeingResized = null;
                this.setCursor(null);
            }
            this.hoveringOnRowResizer = over;
        }
        return over;
    }

    public Point getCell(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error((int)4);
        }
        if (point.x < 0 || point.x > this.getClientArea().width) {
            return null;
        }
        GridItem item = this.getItem(point);
        GridColumn column = this.getColumn(point);
        if (item != null && column != null) {
            return new Point(column.index, item.getRowIndex());
        }
        return null;
    }

    private void onPaint(PaintEvent event) {
        FixedGridColumns fixed;
        int firstVisibleIndex;
        InsertMark insertMark = new InsertMark();
        GridCellSpanManager cellSpanManager = new GridCellSpanManager();
        GC gc = event.gc;
        Rectangle originalClipping = gc.getClipping();
        gc.setBackground(this.getBackground());
        Point controlSize = this.getSize();
        this.drawBackground(gc, 0, 0, controlSize.x, controlSize.y);
        if (this.scrollValuesObsolete) {
            this.updateScrollbars();
            this.scrollValuesObsolete = false;
        }
        int y = 0;
        int extraFill = this.getExtraFill(controlSize);
        if (this.columnHeadersVisible) {
            this.paintHeader(gc, extraFill);
            y += this.headerHeight;
        }
        Rectangle clientArea = this.getClientArea();
        int availableHeight = clientArea.height - y;
        int visibleRows = availableHeight / this.itemHeight + 1;
        if (this.items.size() > 0 && availableHeight > 0) {
            RowRange range = this.getRowRange(this.getTopIndex(), availableHeight, false, false);
            visibleRows = range.height >= availableHeight ? range.rows : range.rows + (availableHeight - range.height) / this.itemHeight + 1;
        }
        int firstItemToDraw = firstVisibleIndex = this.getTopIndex();
        List<GridColumn> cols = this.displayOrderedColumns;
        if (this.hasSpanning) {
            int rowIndex = 0;
            while (rowIndex < firstVisibleIndex && rowIndex < this.items.size()) {
                int colIndex = 0;
                int maxRowSpanForItem = 0;
                for (GridColumn column : cols) {
                    if (!column.isVisible()) {
                        ++colIndex;
                        continue;
                    }
                    int rowSpan = this.items.get(rowIndex).getRowSpan(colIndex);
                    maxRowSpanForItem = rowSpan > maxRowSpanForItem ? rowSpan : maxRowSpanForItem;
                    ++colIndex;
                }
                if (rowIndex + maxRowSpanForItem >= firstVisibleIndex) {
                    firstItemToDraw = rowIndex;
                    break;
                }
                rowIndex += maxRowSpanForItem;
                ++rowIndex;
            }
            rowIndex = firstItemToDraw;
            while (rowIndex < firstVisibleIndex && rowIndex < this.items.size()) {
                GridItem itemForRow = this.items.get(rowIndex);
                if (itemForRow.isVisible()) {
                    y = y - itemForRow.getHeight() - 1;
                }
                ++rowIndex;
            }
        }
        int hscroll = this.getHScrollSelectionInPixels();
        this.paintRows(cols, false, firstItemToDraw, visibleRows, hscroll, cellSpanManager, gc, originalClipping, y, clientArea, firstVisibleIndex, insertMark, extraFill);
        if (this.draggingColumn && (this.dragDropAfterColumn != null || this.dragDropBeforeColumn != null) && this.dragDropAfterColumn != this.columnBeingPushed && this.dragDropBeforeColumn != this.columnBeingPushed && this.dragDropPointValid) {
            int x = this.dragDropBeforeColumn != null ? this.getColumnHeaderXPosition(this.dragDropBeforeColumn) : this.getColumnHeaderXPosition(this.dragDropAfterColumn) + this.dragDropAfterColumn.getWidth();
            Point size = this.dropPointRenderer.computeSize(gc, -1, -1, null);
            if ((x -= size.x / 2) < 0) {
                x = 0;
            }
            this.dropPointRenderer.setBounds(x - 1, this.headerHeight + 3, size.x, size.y);
            this.dropPointRenderer.paint(gc, null);
        }
        if ((fixed = this.getFixedGridColumns()).hasColumns() && hscroll > fixed.offset()) {
            this.paintRows(fixed.columns(), true, firstItemToDraw, visibleRows, 0, cellSpanManager, gc, originalClipping, y, clientArea, firstVisibleIndex, insertMark, extraFill);
        }
        if (insertMark.posFound) {
            Rectangle rect = new Rectangle(this.rowHeaderVisible ? this.rowHeaderWidth : 0, this.columnHeadersVisible ? this.headerHeight : 0, clientArea.width, clientArea.height);
            gc.setClipping(originalClipping.intersection(rect));
            this.insertMarkRenderer.paint(gc, new Rectangle(insertMark.posX1, insertMark.posY, insertMark.posX2 - insertMark.posX1, 0));
        }
        if (this.columnFootersVisible) {
            this.paintFooter(gc);
        }
    }

    private FixedGridColumns getFixedGridColumns() {
        ArrayList<GridColumn> fixedColumns = new ArrayList<GridColumn>();
        int fixedOffset = 0;
        for (GridColumn gridColumn : this.displayOrderedColumns) {
            if (gridColumn.isFixed()) {
                fixedColumns.add(gridColumn);
                continue;
            }
            if (!fixedColumns.isEmpty()) continue;
            fixedOffset += gridColumn.getWidth();
        }
        return new FixedGridColumns(fixedColumns, fixedOffset);
    }

    private void paintRows(List<GridColumn> cols, boolean fixed, int firstRow, int visibleRows, int hScroll, GridCellSpanManager cellSpanManager, GC gc, Rectangle originalClipping, int y, Rectangle clientArea, int firstVisibleIndex, InsertMark insertMark, int extraFill) {
        int row = firstRow;
        int columnCount = cols.size();
        int i = 0;
        while (i < visibleRows + firstVisibleIndex - firstRow) {
            int x = -hScroll;
            GridItem item = null;
            if (row < this.items.size()) {
                item = this.items.get(row);
                while (!item.isVisible() && row < this.items.size() - 1) {
                    item = this.items.get(++row);
                }
            }
            if (item != null && !item.isVisible()) {
                item = null;
            }
            if (item != null) {
                boolean cellInRowSelected = false;
                if (this.rowHeaderVisible) {
                    x += this.rowHeaderWidth;
                }
                int focusY = y;
                int colIndex = 0;
                for (GridColumn column : cols) {
                    boolean skipCell = cellSpanManager.skipCell(colIndex, row);
                    int indexOfColumn = column.index;
                    if (!column.isVisible()) {
                        ++colIndex;
                        if (!skipCell) continue;
                        cellSpanManager.consumeCell(colIndex, row);
                        continue;
                    }
                    Point cellSize = item.getCellSize(indexOfColumn, extraFill);
                    int width = cellSize.x;
                    if (!skipCell) {
                        int nrRowsToSpan = item.getRowSpan(indexOfColumn);
                        int nrColumnsToSpan = item.getColumnSpan(indexOfColumn);
                        if (nrRowsToSpan > 0 || nrColumnsToSpan > 0) {
                            cellSpanManager.addCellSpanInfo(colIndex, row, nrColumnsToSpan, nrRowsToSpan);
                        }
                        if (x + width >= 0 && x < clientArea.width) {
                            int cellInHeaderDelta;
                            Point sizeOfColumn = cellSize;
                            column.getCellRenderer().setBounds(x, y, width, sizeOfColumn.y);
                            int n = cellInHeaderDelta = this.columnHeadersVisible ? this.headerHeight - y : 0;
                            if (cellInHeaderDelta > 0) {
                                cellRect = new Rectangle(x - 1, y + cellInHeaderDelta, width + 1, sizeOfColumn.y + 2 - cellInHeaderDelta);
                                gc.setClipping(originalClipping.intersection(cellRect));
                            } else {
                                cellRect = new Rectangle(x - 1, y - 1, width + 1, sizeOfColumn.y + 2);
                                gc.setClipping(originalClipping.intersection(cellRect));
                            }
                            column.getCellRenderer().setRow(i + 1);
                            column.getCellRenderer().setSelected(this.selectedItems.contains((Object)item));
                            column.getCellRenderer().setFocus(this.isFocusControl());
                            column.getCellRenderer().setRowFocus(this.focusItem == item);
                            column.getCellRenderer().setCellFocus(this.cellSelectionEnabled && this.focusItem == item && this.focusColumn == column);
                            column.getCellRenderer().setRowHover(this.hoveringItem == item);
                            column.getCellRenderer().setColumnHover(this.hoveringColumn == column);
                            column.getCellRenderer().setColumn(indexOfColumn);
                            if (this.selectedCells.contains(new Point(indexOfColumn, row))) {
                                column.getCellRenderer().setCellSelected(true);
                                cellInRowSelected = true;
                            } else {
                                column.getCellRenderer().setCellSelected(false);
                            }
                            if (this.hoveringItem == item && this.hoveringColumn == column) {
                                column.getCellRenderer().setHoverDetail(this.hoveringDetail);
                            } else {
                                column.getCellRenderer().setHoverDetail("");
                            }
                            column.getCellRenderer().paint(gc, (Object)item);
                            gc.setClipping(null);
                            if (!(insertMark.posFound || this.insertMarkItem != item || this.insertMarkColumn != null && this.insertMarkColumn != column)) {
                                insertMark.posY = y - 1;
                                if (!this.insertMarkBefore) {
                                    insertMark.posY += item.getHeight() + 1;
                                }
                                insertMark.posX1 = x;
                                if (column.isTree()) {
                                    insertMark.posX1 += Math.min(width, column.getCellRenderer().getTextBounds((GridItem)item, (boolean)false).x);
                                }
                                insertMark.posX2 = this.insertMarkColumn == null ? clientArea.x + clientArea.width : x + width;
                                insertMark.posFound = true;
                            }
                        }
                    } else {
                        cellSpanManager.consumeCell(colIndex, row);
                    }
                    if (x > clientArea.width) break;
                    x += column.getWidth(extraFill);
                    ++colIndex;
                }
                if (x < clientArea.width) {
                    if (insertMark.posFound && this.insertMarkColumn == null) {
                        insertMark.posX2 = x;
                    }
                    if (!fixed) {
                        this.emptyCellRenderer.setSelected(this.selectedItems.contains((Object)item));
                        this.emptyCellRenderer.setFocus(this.isFocusControl());
                        this.emptyCellRenderer.setRow(i + 1);
                        this.emptyCellRenderer.setBounds(x, y, clientArea.width - x + 1, item.getHeight());
                        this.emptyCellRenderer.setColumn(columnCount);
                        this.emptyCellRenderer.paint(gc, (Object)item);
                    }
                }
                x = 0;
                if (this.rowHeaderVisible) {
                    if (!this.cellSelectionEnabled) {
                        this.rowHeaderRenderer.setSelected(this.selectedItems.contains((Object)item));
                    } else {
                        this.rowHeaderRenderer.setSelected(cellInRowSelected);
                    }
                    if (!this.columnHeadersVisible || y >= this.headerHeight) {
                        this.rowHeaderRenderer.setBounds(0, y, this.rowHeaderWidth, item.getHeight() + 1);
                        this.rowHeaderRenderer.paint(gc, (Object)item);
                    }
                    x += this.rowHeaderWidth;
                }
                if (this.isFocusControl() && !this.cellSelectionEnabled && item == this.focusItem && this.focusRenderer != null) {
                    int focusX = 0;
                    if (this.rowHeaderVisible) {
                        focusX = this.rowHeaderWidth;
                    }
                    this.focusRenderer.setBounds(focusX, focusY - 1, clientArea.width - focusX - 1, item.getHeight() + 1);
                    this.focusRenderer.paint(gc, (Object)item);
                }
                y += item.getHeight() + 1;
            } else {
                if (this.rowHeaderVisible) {
                    x += this.rowHeaderWidth;
                }
                if (!fixed) {
                    this.emptyCellRenderer.setBounds(x, y, clientArea.width - x, this.itemHeight);
                    this.emptyCellRenderer.setFocus(false);
                    this.emptyCellRenderer.setSelected(false);
                    this.emptyCellRenderer.setRow(i + 1);
                }
                for (GridColumn column : cols) {
                    if (!column.isVisible()) continue;
                    int width = column.getWidth(extraFill);
                    if (x + width >= 0 && !fixed) {
                        this.emptyCellRenderer.setBounds(x, y, width, this.itemHeight);
                        this.emptyCellRenderer.setColumn(column.index);
                        this.emptyCellRenderer.paint(gc, (Object)this);
                    }
                    if (x > clientArea.width) break;
                    x += width;
                }
                if (x < clientArea.width && !fixed) {
                    this.emptyCellRenderer.setBounds(x, y, clientArea.width - x + 1, this.itemHeight);
                    this.emptyCellRenderer.setColumn(columnCount);
                    this.emptyCellRenderer.paint(gc, (Object)this);
                }
                x = 0;
                if (this.rowHeaderVisible) {
                    if (!fixed) {
                        this.emptyRowHeaderRenderer.setBounds(x, y, this.rowHeaderWidth, this.itemHeight + 1);
                        this.emptyRowHeaderRenderer.paint(gc, (Object)this);
                    }
                    x += this.rowHeaderWidth;
                }
                y += this.itemHeight + 1;
            }
            ++row;
            ++i;
        }
    }

    private GridColumn overColumnHeader(int x, int y) {
        GridColumn col = null;
        if (y <= this.headerHeight && y > 0 && (col = this.getColumn(new Point(x, y))) != null && col.getColumnGroup() != null && y <= this.groupHeaderHeight) {
            return null;
        }
        return col;
    }

    private GridColumn overColumnFooter(int x, int y) {
        if (y >= this.getClientArea().height - this.footerHeight) {
            return this.getColumn(new Point(x, y));
        }
        return null;
    }

    private GridColumnGroup overColumnGroupHeader(int x, int y) {
        GridColumn col;
        GridColumnGroup group = null;
        if (y <= this.groupHeaderHeight && y > 0 && (col = this.getColumn(new Point(x, y))) != null) {
            group = col.getColumnGroup();
        }
        return group;
    }

    private void paintHeader(GC gc, int extraFill) {
        int x = 0;
        boolean hasFixedColumns = false;
        int firstFixed = 0;
        int hScroll = this.getHScrollSelectionInPixels();
        x -= hScroll;
        if (this.rowHeaderVisible) {
            x += this.rowHeaderWidth;
        }
        GridColumnGroup previousPaintedGroup = null;
        for (GridColumn column : this.displayOrderedColumns) {
            if (x > this.getClientArea().width) break;
            if (!column.isVisible()) continue;
            if (!hasFixedColumns) {
                if (column.isFixed()) {
                    hasFixedColumns = true;
                } else {
                    firstFixed += column.getWidth();
                }
            }
            previousPaintedGroup = this.paintColumnHeaderWithGroup(column, x, gc, previousPaintedGroup, extraFill);
            x += column.getWidth(extraFill);
        }
        if (x < this.getClientArea().width) {
            this.emptyColumnHeaderRenderer.setBounds(x, 0, this.getClientArea().width - x, this.headerHeight);
            this.emptyColumnHeaderRenderer.paint(gc, null);
        }
        x = 0;
        if (this.rowHeaderVisible) {
            this.topLeftRenderer.setBounds(0, 0, this.rowHeaderWidth, this.headerHeight);
            this.topLeftRenderer.paint(gc, (Object)this);
            x += this.rowHeaderWidth;
        }
        if (this.draggingColumn) {
            int y;
            gc.setAlpha(128);
            this.columnBeingPushed.getHeaderRenderer().setSelected(false);
            int height = 0;
            if (this.columnBeingPushed.getColumnGroup() != null) {
                height = this.headerHeight - this.groupHeaderHeight;
                y = this.groupHeaderHeight;
            } else {
                height = this.headerHeight;
                y = 0;
            }
            this.columnBeingPushed.getHeaderRenderer().setBounds(this.getColumnHeaderXPosition(this.columnBeingPushed) + this.currentHeaderDragX - this.startHeaderDragX, y, this.columnBeingPushed.getWidth(), height);
            this.columnBeingPushed.getHeaderRenderer().paint(gc, (Object)this.columnBeingPushed);
            this.columnBeingPushed.getHeaderRenderer().setSelected(false);
            gc.setAlpha(-1);
            gc.setAdvanced(false);
        } else if (hasFixedColumns && hScroll > firstFixed) {
            x = 0;
            if (this.rowHeaderVisible) {
                x += this.rowHeaderWidth;
            }
            previousPaintedGroup = null;
            for (GridColumn column : this.displayOrderedColumns) {
                if (x > this.getClientArea().width) break;
                if (!column.isVisible() || !column.isFixed()) continue;
                previousPaintedGroup = this.paintColumnHeaderWithGroup(column, x, gc, previousPaintedGroup, extraFill);
                x += column.getWidth();
            }
        }
    }

    int getExtraFill() {
        return this.getExtraFill(this.getSize());
    }

    int getExtraFill(Point size) {
        int totalWidth = this.rowHeaderVisible ? this.rowHeaderWidth : 0;
        int fillColumns = 0;
        for (GridColumn column : this.displayOrderedColumns) {
            if (!column.isVisible()) continue;
            totalWidth += column.getWidth();
            if (!column.isFill()) continue;
            ++fillColumns;
        }
        if (fillColumns == 0) {
            return 0;
        }
        return Math.max(size.x - totalWidth, 0) / fillColumns;
    }

    private GridColumnGroup paintColumnHeaderWithGroup(GridColumn column, int x, GC gc, GridColumnGroup previousPaintedGroup, int extraFill) {
        int y;
        int height;
        GridColumnGroup group = column.getColumnGroup();
        int width = column.getWidth(extraFill);
        if (group != null) {
            if (group != previousPaintedGroup) {
                GridColumn nextCol = null;
                if (this.displayOrderedColumns.indexOf((Object)column) + 1 < this.displayOrderedColumns.size()) {
                    nextCol = this.displayOrderedColumns.get(this.displayOrderedColumns.indexOf((Object)column) + 1);
                }
                while (nextCol != null && nextCol.getColumnGroup() == group) {
                    if ((!nextCol.getColumnGroup().getExpanded() || nextCol.isDetail()) && (nextCol.getColumnGroup().getExpanded() || nextCol.isSummary()) && nextCol.isVisible()) {
                        width += nextCol.getWidth(extraFill);
                    }
                    nextCol = this.displayOrderedColumns.indexOf((Object)nextCol) + 1 < this.displayOrderedColumns.size() ? this.displayOrderedColumns.get(this.displayOrderedColumns.indexOf((Object)nextCol) + 1) : null;
                }
                boolean selected = true;
                int i = 0;
                while (i < group.getColumns().length) {
                    GridColumn col = group.getColumns()[i];
                    if (col.isVisible() && (column.getMoveable() || !this.selectedColumns.contains((Object)col))) {
                        selected = false;
                        break;
                    }
                    ++i;
                }
                group.getHeaderRenderer().setSelected(selected);
                group.getHeaderRenderer().setHover(this.hoverColumnGroupHeader == group);
                group.getHeaderRenderer().setHoverDetail(this.hoveringDetail);
                group.getHeaderRenderer().setBounds(x, 0, width, this.groupHeaderHeight);
                group.getHeaderRenderer().paint(gc, (Object)group);
                previousPaintedGroup = group;
            }
            height = this.headerHeight - this.groupHeaderHeight;
            y = this.groupHeaderHeight;
        } else {
            height = this.headerHeight;
            y = 0;
        }
        GridHeaderRenderer renderer = column.getHeaderRenderer();
        if (this.pushingColumn) {
            renderer.setHover(this.columnBeingPushed == column && this.pushingAndHovering);
        } else {
            renderer.setHover(this.hoveringColumnHeader == column);
        }
        renderer.setHoverDetail(this.hoveringDetail);
        renderer.setBounds(x, y, width, height);
        if (this.cellSelectionEnabled) {
            renderer.setSelected(this.selectedColumns.contains((Object)column));
        }
        if (x + width >= 0) {
            renderer.paint(gc, (Object)column);
        }
        return previousPaintedGroup;
    }

    private void paintFooter(GC gc) {
        int x = 0;
        int y = 0;
        x -= this.getHScrollSelectionInPixels();
        if (this.rowHeaderVisible) {
            x += this.rowHeaderWidth;
        }
        for (GridColumn column : this.displayOrderedColumns) {
            if (x > this.getClientArea().width) break;
            int height = 0;
            if (!column.isVisible()) continue;
            height = this.footerHeight;
            y = this.getClientArea().height - height;
            column.getFooterRenderer().setBounds(x, y, column.getWidth(), height);
            if (x + column.getWidth() >= 0) {
                column.getFooterRenderer().paint(gc, (Object)column);
            }
            x += column.getWidth();
        }
        if (x < this.getClientArea().width) {
            this.emptyColumnFooterRenderer.setBounds(x, this.getClientArea().height - this.footerHeight, this.getClientArea().width - x, this.footerHeight);
            this.emptyColumnFooterRenderer.paint(gc, null);
        }
        if (this.rowHeaderVisible) {
            this.bottomLeftRenderer.setBounds(0, this.getClientArea().height - this.footerHeight, this.rowHeaderWidth, this.footerHeight);
            this.bottomLeftRenderer.paint(gc, (Object)this);
            x += this.rowHeaderWidth;
        }
    }

    private void updateScrollbars() {
        Point preferredSize = this.getTableSize();
        Rectangle clientArea = this.getClientArea();
        int doublePass = 1;
        while (doublePass <= 2) {
            if (preferredSize.y > clientArea.height) {
                this.vScroll.setVisible(true);
            } else {
                this.vScroll.setVisible(false);
                this.vScroll.setValues(0, 0, 1, 1, 1, 1);
            }
            if (preferredSize.x > clientArea.width) {
                this.hScroll.setVisible(true);
            } else {
                this.hScroll.setVisible(false);
                this.hScroll.setValues(0, 0, 1, 1, 1, 1);
            }
            clientArea = this.getClientArea();
            ++doublePass;
        }
        if (this.vScroll.getVisible()) {
            int max = this.currentVisibleItems;
            int thumb = 1;
            if (!this.hasDifferingHeights) {
                thumb = (this.getVisibleGridHeight() + 1) / (this.itemHeight + 1);
            } else if (this.getVisibleGridHeight() >= 1) {
                RowRange range = this.getRowRange(-1, this.getVisibleGridHeight(), true, true);
                max -= range.rows - 1;
            }
            int selection = Math.min(this.vScroll.getSelection(), max);
            this.vScroll.setValues(selection, 0, max, thumb, 1, thumb);
        }
        if (this.hScroll.getVisible()) {
            if (!this.columnScrolling) {
                hiddenArea = preferredSize.x - clientArea.width + 1;
                int selection = Math.min(this.hScroll.getSelection(), hiddenArea - 1);
                this.hScroll.setValues(selection, 0, hiddenArea + clientArea.width - 1, clientArea.width, 5, clientArea.width);
            } else {
                hiddenArea = preferredSize.x - clientArea.width + 1;
                int max = 0;
                int i = 0;
                while (hiddenArea > 0 && i < this.getColumnCount()) {
                    GridColumn col = this.displayOrderedColumns.get(i);
                    ++i;
                    if (!col.isVisible()) continue;
                    hiddenArea -= col.getWidth();
                    ++max;
                }
                ++max;
                int visCols = 0;
                for (GridColumn element : this.columns) {
                    if (!element.isVisible()) continue;
                    ++visCols;
                }
                max = Math.min(visCols, max);
                int selection = Math.min(this.hScroll.getSelection(), max);
                this.hScroll.setValues(selection, 0, max, 1, 1, 1);
            }
        }
    }

    private Event updateSelection(GridItem item, int stateMask) {
        Rectangle clientArea;
        if (!this.selectionEnabled) {
            return null;
        }
        Event selectionEvent = null;
        if (this.selectionType == GridSelectionType.SINGLE) {
            if (this.selectedItems.contains((Object)item)) {
                if ((stateMask & SWT.MOD1) == SWT.MOD1) {
                    this.selectedItems.clear();
                }
            } else {
                this.selectedItems.clear();
                this.selectedItems.add(item);
            }
            clientArea = this.getClientArea();
            this.redraw(clientArea.x, clientArea.y, clientArea.width, clientArea.height, false);
            selectionEvent = new Event();
            selectionEvent.item = item;
        } else if (this.selectionType == GridSelectionType.MULTI) {
            boolean shift = false;
            boolean ctrl = false;
            if ((stateMask & SWT.MOD2) == SWT.MOD2) {
                shift = true;
            }
            if ((stateMask & SWT.MOD1) == SWT.MOD1) {
                ctrl = true;
            }
            if (!shift && !ctrl) {
                if (this.selectedItems.size() == 1 && this.selectedItems.contains((Object)item)) {
                    return null;
                }
                this.selectedItems.clear();
                this.selectedItems.add(item);
                Rectangle clientArea2 = this.getClientArea();
                this.redraw(clientArea2.x, clientArea2.y, clientArea2.width, clientArea2.height, false);
                this.shiftSelectionAnchorItem = null;
                selectionEvent = new Event();
                selectionEvent.item = item;
            } else if (shift) {
                if (this.shiftSelectionAnchorItem == null) {
                    this.shiftSelectionAnchorItem = this.focusItem;
                }
                boolean maintainAnchorSelection = false;
                if (!ctrl) {
                    if (this.selectedItems.contains((Object)this.shiftSelectionAnchorItem)) {
                        maintainAnchorSelection = true;
                    }
                    this.selectedItems.clear();
                }
                int anchorIndex = this.items.indexOf((Object)this.shiftSelectionAnchorItem);
                int itemIndex = item.getRowIndex();
                int min = 0;
                int max = 0;
                if (anchorIndex < itemIndex) {
                    min = maintainAnchorSelection ? anchorIndex : anchorIndex + 1;
                    max = itemIndex;
                } else {
                    max = maintainAnchorSelection ? anchorIndex : anchorIndex - 1;
                    min = itemIndex;
                }
                int i = min;
                while (i <= max) {
                    if (!this.selectedItems.contains((Object)this.items.get(i)) && this.items.get(i).isVisible()) {
                        this.selectedItems.add(this.items.get(i));
                    }
                    ++i;
                }
                Rectangle clientArea3 = this.getClientArea();
                this.redraw(clientArea3.x, clientArea3.y, clientArea3.width, clientArea3.height, false);
                selectionEvent = new Event();
            } else if (ctrl) {
                if (this.selectedItems.contains((Object)item)) {
                    this.selectedItems.remove((Object)item);
                } else {
                    this.selectedItems.add(item);
                }
                Rectangle clientArea4 = this.getClientArea();
                this.redraw(clientArea4.x, clientArea4.y, clientArea4.width, clientArea4.height, false);
                this.shiftSelectionAnchorItem = null;
                selectionEvent = new Event();
                selectionEvent.item = item;
            }
        }
        clientArea = this.getClientArea();
        this.redraw(clientArea.x, clientArea.y, clientArea.width, clientArea.height, false);
        return selectionEvent;
    }

    private Event updateCellSelection(Point newCell, int stateMask, boolean dragging, boolean reverseDuplicateSelections) {
        Vector<Point> v = new Vector<Point>();
        v.add(newCell);
        return this.updateCellSelection(v, stateMask, dragging, reverseDuplicateSelections);
    }

    private Event updateCellSelection(Vector<Point> newCells, int stateMask, boolean dragging, boolean reverseDuplicateSelections) {
        boolean shift = false;
        boolean ctrl = false;
        if ((stateMask & SWT.MOD2) == SWT.MOD2) {
            shift = true;
        } else {
            this.shiftSelectionAnchorColumn = null;
            this.shiftSelectionAnchorItem = null;
        }
        if ((stateMask & SWT.MOD1) == SWT.MOD1) {
            ctrl = true;
        }
        if (!shift && !ctrl) {
            if (newCells.equals(this.selectedCells)) {
                return null;
            }
            this.selectedCells.clear();
            for (Point newCell : newCells) {
                this.addToCellSelection(newCell);
            }
        } else if (shift) {
            Point newCell = newCells.get(0);
            if (this.focusColumn == null || this.focusItem == null) {
                return null;
            }
            this.shiftSelectionAnchorColumn = this.getColumn(newCell.x);
            this.shiftSelectionAnchorItem = this.getItem(newCell.y);
            if (ctrl) {
                this.selectedCells.clear();
                this.addCellstThatDoNotAlreadyExist(this.selectedCells, this.selectedCellsBeforeRangeSelect);
            } else {
                this.selectedCells.clear();
            }
            GridColumn currentColumn = this.focusColumn;
            GridItem currentItem = this.focusItem;
            GridColumn endColumn = this.getColumn(newCell.x);
            GridItem endItem = this.getItem(newCell.y);
            Point newRange = this.getSelectionRange(currentItem, currentColumn, endItem, endColumn);
            currentColumn = this.getColumn(newRange.x);
            endColumn = this.getColumn(newRange.y);
            GridColumn startCol = currentColumn;
            if (currentItem.getRowIndex() > endItem.getRowIndex()) {
                GridItem temp = currentItem;
                currentItem = endItem;
                endItem = temp;
            }
            boolean firstLoop = true;
            do {
                if (!firstLoop) {
                    currentItem = this.getNextVisibleItem(currentItem);
                }
                firstLoop = false;
                boolean firstLoop2 = true;
                currentColumn = startCol;
                do {
                    int index;
                    if (!firstLoop2 && (currentColumn = (index = this.displayOrderedColumns.indexOf((Object)currentColumn) + 1) < this.displayOrderedColumns.size() ? this.getVisibleColumn_DegradeRight(currentItem, this.displayOrderedColumns.get(index)) : null) != null && this.displayOrderedColumns.indexOf((Object)currentColumn) > this.displayOrderedColumns.indexOf((Object)endColumn)) {
                        currentColumn = null;
                    }
                    firstLoop2 = false;
                    if (currentColumn == null) continue;
                    Point cell = new Point(currentColumn.index, currentItem.getRowIndex());
                    this.addToCellSelection(cell);
                } while (currentColumn != endColumn && currentColumn != null);
            } while (currentItem != endItem);
        } else if (ctrl) {
            boolean reverse = reverseDuplicateSelections;
            if (!this.selectedCells.containsAll(newCells)) {
                reverse = false;
            }
            if (dragging) {
                this.selectedCells.clear();
                this.addCellstThatDoNotAlreadyExist(this.selectedCells, this.selectedCellsBeforeRangeSelect);
            }
            if (reverse) {
                this.selectedCells.removeAll(newCells);
            } else {
                for (Point newCell : newCells) {
                    this.addToCellSelection(newCell);
                }
            }
        }
        this.updateColumnSelection();
        Event e = new Event();
        if (dragging) {
            e.detail = 1;
            this.followupCellSelectionEventOwed = true;
        }
        Rectangle clientArea = this.getClientArea();
        this.redraw(clientArea.x, clientArea.y, clientArea.width, clientArea.height, false);
        return e;
    }

    private void addCellstThatDoNotAlreadyExist(List<Point> sourceList, List<Point> itemsToBeAdded) {
        if (itemsToBeAdded.size() > 0) {
            for (Point cell : itemsToBeAdded) {
                if (sourceList.contains(cell)) continue;
                sourceList.add(cell);
            }
        }
    }

    private void addToCellSelection(Point newCell) {
        if (newCell.x < 0 || newCell.x >= this.columns.size()) {
            return;
        }
        if (newCell.y < 0 || newCell.y >= this.items.size()) {
            return;
        }
        if (this.getColumn(newCell.x).getCellSelectionEnabled()) {
            Iterator<Point> it = this.selectedCells.iterator();
            boolean found = false;
            while (it.hasNext()) {
                Point p = it.next();
                if (!newCell.equals((Object)p)) continue;
                found = true;
                break;
            }
            if (!found) {
                if (this.selectionType == GridSelectionType.SINGLE && this.selectedCells.size() > 0) {
                    return;
                }
                this.selectedCells.add(newCell);
            }
        }
    }

    void updateColumnSelection() {
        this.selectedColumns.clear();
        for (Point cell : this.selectedCells) {
            this.selectedColumns.add(this.getColumn(cell.x));
        }
    }

    private void initListeners() {
        this.disposeListener = this::onDispose;
        this.addListener(12, this.disposeListener);
        this.addPaintListener(this::onPaint);
        this.addListener(11, e -> this.onResize());
        if (this.getVerticalBar() != null) {
            this.getVerticalBar().addListener(13, e -> this.onScrollSelection());
        }
        if (this.getHorizontalBar() != null) {
            this.getHorizontalBar().addListener(13, e -> this.onScrollSelection());
        }
        this.defaultKeyListener = this::onKeyDown;
        this.addListener(1, this.defaultKeyListener);
        this.addTraverseListener(e -> {
            if (this.moveOnTab) {
                e.doit = false;
                if (this.selectedItems.isEmpty()) {
                    this.select(0);
                    return;
                }
                if (this.selectedItems.size() == 1) {
                    int index = this.getSelectionIndex();
                    if (16 == e.detail) {
                        this.select(index == this.getItemCount() - 1 ? 0 : index + 1);
                    } else if (8 == e.detail) {
                        this.select(index == 0 ? this.getItemCount() - 1 : index - 1);
                    }
                    return;
                }
                return;
            }
            e.doit = true;
        });
        this.addListener(8, this::onMouseDoubleClick);
        this.addListener(3, this::onMouseDown);
        this.addListener(4, this::onMouseUp);
        this.addMouseMoveListener(this::onMouseMove);
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                Grid.this.onMouseExit(e);
            }

            public void mouseHover(MouseEvent e) {
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                Grid.this.onFocusIn();
                Grid.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                Grid.this.redraw();
            }
        });
        this.addListener(37, this::onMouseWheel);
    }

    public void disableDefaultKeyListener() {
        if (this.defaultKeyListenerEnabled) {
            this.removeListener(1, this.defaultKeyListener);
        }
        this.defaultKeyListenerEnabled = false;
    }

    public void enableDefaultKeyListener() {
        if (!this.defaultKeyListenerEnabled) {
            this.addListener(1, this.defaultKeyListener);
        }
        this.defaultKeyListenerEnabled = true;
    }

    private void onFocusIn() {
        if (!this.items.isEmpty() && this.focusItem == null) {
            this.focusItem = this.items.get(0);
        }
    }

    private void onDispose(Event event) {
        this.removeListener(12, this.disposeListener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.disposing = true;
        this.cellHeaderSelectionBackground.dispose();
        for (GridItem item : this.items) {
            item.dispose();
        }
        GridColumnGroup[] gridColumnGroupArray = this.columnGroups;
        int n = this.columnGroups.length;
        int n2 = 0;
        while (n2 < n) {
            GridColumnGroup columnGroup = gridColumnGroupArray[n2];
            columnGroup.dispose();
            ++n2;
        }
        for (GridColumn col : this.columns) {
            col.dispose();
        }
    }

    private void onMouseWheel(Event e) {
        if (this.vScroll.getVisible()) {
            this.vScroll.handleMouseWheel(e);
            if (this.getVerticalBar() == null) {
                e.doit = false;
            }
        } else if (this.hScroll.getVisible()) {
            this.hScroll.handleMouseWheel(e);
            if (this.getHorizontalBar() == null) {
                e.doit = false;
            }
        }
    }

    private void onMouseDown(Event e) {
        if ((this.getStyle() & 0x80000) != 524288) {
            this.forceFocus();
        }
        this.hideToolTip();
        Event selectionEvent = null;
        this.cellSelectedOnLastMouseDown = false;
        this.cellRowSelectedOnLastMouseDown = false;
        this.cellColumnSelectedOnLastMouseDown = false;
        if (this.hoveringOnColumnResizer) {
            if (e.button == 1) {
                this.resizingColumn = true;
                this.resizingStartX = e.x;
                this.resizingColumnStartWidth = this.columnBeingResized.getWidth();
            }
            return;
        }
        if (this.rowsResizeable && this.hoveringOnRowResizer) {
            if (e.button == 1) {
                this.resizingRow = true;
                this.resizingStartY = e.y;
                this.resizingRowStartHeight = this.rowBeingResized.getHeight();
            }
            return;
        }
        if (e.button == 1 && this.handleColumnHeaderPush(e.x, e.y)) {
            return;
        }
        if (e.button == 1 && this.handleColumnGroupHeaderClick(e.x, e.y)) {
            return;
        }
        if (e.button == 1 && this.handleColumnFooterPush(e.x, e.y)) {
            return;
        }
        GridItem item = this.getItem(new Point(e.x, e.y));
        if (e.button == 1 && item != null && this.handleCellClick(item, e.x, e.y)) {
            return;
        }
        if (this.isListening(29) && (this.cellSelectionEnabled && this.hoveringOnSelectionDragArea || !this.cellSelectionEnabled && item != null && this.selectedItems.contains((Object)item)) && this.dragDetect(e)) {
            return;
        }
        if (item != null) {
            if (this.cellSelectionEnabled) {
                GridColumn col = this.getColumn(new Point(e.x, e.y));
                boolean isSelectedCell = false;
                if (col != null) {
                    isSelectedCell = this.selectedCells.contains(new Point(col.index, item.getRowIndex()));
                }
                if (e.button == 1 || e.button == 3 && col != null && !isSelectedCell) {
                    if (col != null) {
                        selectionEvent = this.updateCellSelection(new Point(col.index, item.getRowIndex()), e.stateMask, false, true);
                        boolean bl = this.cellSelectedOnLastMouseDown = this.getCellSelectionCount() > 0;
                        if (e.stateMask != SWT.MOD2) {
                            this.focusColumn = col;
                            this.focusItem = item;
                        }
                        this.showItem(item);
                        this.redraw();
                    } else if (this.rowHeaderVisible && e.x <= this.rowHeaderWidth) {
                        boolean shift = (e.stateMask & SWT.MOD2) != 0;
                        boolean ctrl = false;
                        if (!shift) {
                            ctrl = (e.stateMask & SWT.MOD1) != 0;
                        }
                        Vector<Point> cells = new Vector<Point>();
                        if (shift) {
                            this.getCells(item, this.focusItem, cells);
                        } else {
                            this.getCells(item, cells);
                        }
                        int newStateMask = 0;
                        if (ctrl) {
                            newStateMask = SWT.MOD1;
                        }
                        selectionEvent = this.updateCellSelection(cells, newStateMask, shift, ctrl);
                        boolean bl = this.cellRowSelectedOnLastMouseDown = this.getCellSelectionCount() > 0;
                        if (!shift) {
                            this.focusColumn = this.getColumn(new Point(this.rowHeaderWidth + 1, e.y));
                            this.focusItem = item;
                        }
                        this.showItem(item);
                        this.redraw();
                    }
                    this.intendedFocusColumn = this.focusColumn;
                }
            } else {
                if (e.button == 2 || e.button > 3) {
                    return;
                }
                if (e.button == 3 && this.selectionType == GridSelectionType.MULTI) {
                    if ((e.stateMask & SWT.MOD2) == SWT.MOD2) {
                        return;
                    }
                    if ((e.stateMask & SWT.MOD1) == SWT.MOD1) {
                        return;
                    }
                    if (this.selectedItems.contains((Object)item)) {
                        return;
                    }
                }
                selectionEvent = this.updateSelection(item, e.stateMask);
                this.focusItem = item;
                this.showItem(item);
                this.redraw();
            }
        } else if (e.button == 1 && this.rowHeaderVisible && e.x <= this.rowHeaderWidth && e.y < this.headerHeight) {
            if (this.items.size() == 0) {
                return;
            }
            if (this.cellSelectionEnabled) {
                selectionEvent = this.selectAllCellsInternal();
                this.focusColumn = this.getColumn(new Point(this.rowHeaderWidth + 1, 1));
            } else {
                selectionEvent = this.selectAllRowsInternal();
            }
            this.focusItem = this.getItem(this.getTopIndex());
        } else if (this.cellSelectionEnabled && e.button == 1 && this.columnHeadersVisible && e.y <= this.headerHeight) {
            GridColumn col = this.getColumn(new Point(e.x, e.y));
            if (col == null) {
                return;
            }
            if (this.getItemCount() == 0) {
                return;
            }
            Vector<Point> cells = new Vector<Point>();
            GridColumnGroup group = col.getColumnGroup();
            if (group != null && e.y < this.groupHeaderHeight) {
                this.getCells(group, cells);
            } else {
                this.getCells(col, cells);
            }
            selectionEvent = this.updateCellSelection(cells, e.stateMask, false, true);
            this.cellColumnSelectedOnLastMouseDown = this.getCellSelectionCount() > 0;
            GridItem newFocusItem = this.getItem(0);
            while (newFocusItem != null && this.getSpanningColumn(newFocusItem, col) != null) {
                newFocusItem = this.getNextVisibleItem(newFocusItem);
            }
            if (newFocusItem != null) {
                this.focusColumn = col;
                this.focusItem = newFocusItem;
            }
            this.showColumn(col);
            this.redraw();
        }
        if (selectionEvent != null) {
            selectionEvent.stateMask = e.stateMask;
            selectionEvent.button = e.button;
            selectionEvent.item = item;
            selectionEvent.x = e.x;
            selectionEvent.y = e.y;
            this.notifyListeners(13, selectionEvent);
            if (!this.cellSelectionEnabled && this.isListening(29)) {
                this.dragDetect(e);
            }
        }
    }

    private void onMouseDoubleClick(Event e) {
        if (e.button != 1) {
            return;
        }
        if (this.hoveringOnColumnResizer) {
            this.columnBeingResized.pack();
            this.columnBeingResized.fireResized();
            int index = this.displayOrderedColumns.indexOf((Object)this.columnBeingResized) + 1;
            while (index < this.displayOrderedColumns.size()) {
                GridColumn col = this.displayOrderedColumns.get(index);
                if (col.isVisible()) {
                    col.fireMoved();
                }
                ++index;
            }
            this.resizingColumn = false;
            this.handleHoverOnColumnResizer(e.x, e.y);
            e.doit = false;
            return;
        }
        if (this.rowsResizeable && this.hoveringOnRowResizer) {
            List<GridItem> sel = Arrays.asList(this.getSelection());
            if (sel.contains((Object)this.rowBeingResized)) {
                for (GridItem element : sel) {
                    element.pack();
                }
                this.redraw();
            } else {
                this.rowBeingResized.pack();
            }
            this.resizingRow = false;
            this.handleHoverOnRowResizer(e.x, e.y);
            e.doit = false;
            return;
        }
        if (e.y < this.headerHeight && this.columnHeadersVisible) {
            e.doit = false;
            return;
        }
        GridItem item = this.getItem(new Point(e.x, e.y));
        if (item != null) {
            if (this.isListening(14)) {
                Event newEvent = new Event();
                newEvent.item = item;
                this.notifyListeners(14, newEvent);
            } else if (item.getItemCount() > 0) {
                item.setExpanded(!item.isExpanded());
                if (item.isExpanded()) {
                    item.fireEvent(17);
                } else {
                    item.fireEvent(18);
                }
            }
        }
    }

    private void onMouseUp(Event e) {
        this.cellSelectedOnLastMouseDown = false;
        if (this.resizingColumn) {
            this.resizingColumn = false;
            this.handleHoverOnColumnResizer(e.x, e.y);
            return;
        }
        if (this.resizingRow) {
            this.resizingRow = false;
            this.handleHoverOnRowResizer(e.x, e.y);
            return;
        }
        if (this.pushingColumn) {
            this.pushingColumn = false;
            this.columnBeingPushed.getHeaderRenderer().setMouseDown(false);
            this.columnBeingPushed.getHeaderRenderer().setHover(false);
            this.redraw();
            if (this.pushingAndHovering) {
                this.columnBeingPushed.fireListeners();
            }
            this.setCapture(false);
            return;
        }
        if (this.draggingColumn) {
            this.handleColumnDrop();
            return;
        }
        if (this.cellDragSelectionOccuring || this.cellRowDragSelectionOccuring || this.cellColumnDragSelectionOccuring) {
            this.cellDragSelectionOccuring = false;
            this.cellRowDragSelectionOccuring = false;
            this.cellColumnDragSelectionOccuring = false;
            this.setCursor(null);
            if (this.followupCellSelectionEventOwed) {
                Event se = new Event();
                se.button = e.button;
                se.item = this.getItem(new Point(e.x, e.y));
                se.stateMask = e.stateMask;
                se.x = e.x;
                se.y = e.y;
                this.notifyListeners(13, se);
                this.followupCellSelectionEventOwed = false;
            }
        }
    }

    private void onMouseMove(MouseEvent e) {
        if (this.inplaceTooltipCapture && (e.x < 0 || e.y < 0 || e.x >= this.getBounds().width || e.y >= this.getBounds().height)) {
            this.setCapture(false);
            this.inplaceTooltipCapture = false;
            return;
        }
        Event selectionEvent = null;
        if ((e.stateMask & 0x80000) == 0) {
            this.handleHovering(e.x, e.y);
        } else {
            if (this.draggingColumn) {
                this.handleColumnDragging(e.x);
                return;
            }
            if (this.resizingColumn) {
                this.handleColumnResizerDragging(e.x);
                return;
            }
            if (this.resizingRow) {
                this.handleRowResizerDragging(e.y);
                return;
            }
            if (this.pushingColumn) {
                this.handleColumnHeaderHoverWhilePushing(e.x, e.y);
                return;
            }
            if (this.cellSelectionEnabled) {
                int ctrlFlag;
                if (this.cellDragSelectionEnabled && !this.cellDragSelectionOccuring && this.cellSelectedOnLastMouseDown) {
                    this.cellDragSelectionOccuring = true;
                    this.setCursor(this.getDisplay().getSystemCursor(2));
                    boolean bl = this.cellDragCTRL = (e.stateMask & SWT.MOD1) != 0;
                    if (this.cellDragCTRL) {
                        this.selectedCellsBeforeRangeSelect.clear();
                        this.selectedCellsBeforeRangeSelect.addAll(this.selectedCells);
                    }
                }
                if (!this.cellRowDragSelectionOccuring && this.cellRowSelectedOnLastMouseDown) {
                    this.cellRowDragSelectionOccuring = true;
                    this.setCursor(this.getDisplay().getSystemCursor(2));
                    boolean bl = this.cellDragCTRL = (e.stateMask & SWT.MOD1) != 0;
                    if (this.cellDragCTRL) {
                        this.selectedCellsBeforeRangeSelect.clear();
                        this.selectedCellsBeforeRangeSelect.addAll(this.selectedCells);
                    }
                }
                if (!this.cellColumnDragSelectionOccuring && this.cellColumnSelectedOnLastMouseDown) {
                    this.cellColumnDragSelectionOccuring = true;
                    this.setCursor(this.getDisplay().getSystemCursor(2));
                    boolean bl = this.cellDragCTRL = (e.stateMask & SWT.MOD1) != 0;
                    if (this.cellDragCTRL) {
                        this.selectedCellsBeforeRangeSelect.clear();
                        this.selectedCellsBeforeRangeSelect.addAll(this.selectedCells);
                    }
                }
                int n = ctrlFlag = this.cellDragCTRL ? SWT.MOD1 : 0;
                if (this.cellDragSelectionOccuring && this.handleCellHover(e.x, e.y)) {
                    GridColumn intentColumn = this.hoveringColumn;
                    GridItem intentItem = this.hoveringItem;
                    if (this.hoveringItem == null) {
                        intentItem = e.y > this.headerHeight ? this.getPreviousVisibleItem(null) : this.items.get(0);
                    }
                    if (this.hoveringColumn == null) {
                        if (e.x > this.rowHeaderWidth) {
                            intentColumn = this.getVisibleColumn_DegradeLeft(intentItem, this.displayOrderedColumns.get(this.displayOrderedColumns.size() - 1));
                        } else {
                            GridColumn firstCol = this.displayOrderedColumns.get(0);
                            if (!firstCol.isVisible()) {
                                firstCol = this.getNextVisibleColumn(firstCol);
                            }
                            intentColumn = firstCol;
                        }
                    }
                    this.showColumn(intentColumn);
                    this.showItem(intentItem);
                    selectionEvent = this.updateCellSelection(new Point(intentColumn.index, intentItem.getRowIndex()), ctrlFlag | SWT.MOD2, true, false);
                }
                if (this.cellRowDragSelectionOccuring && this.handleCellHover(e.x, e.y)) {
                    GridItem intentItem = this.hoveringItem;
                    if (this.hoveringItem == null) {
                        intentItem = e.y > this.headerHeight ? this.getPreviousVisibleItem(null) : (this.getTopIndex() > 0 ? this.getPreviousVisibleItem(this.items.get(this.getTopIndex())) : this.items.get(0));
                    }
                    Vector<Point> cells = new Vector<Point>();
                    this.getCells(intentItem, this.focusItem, cells);
                    this.showItem(intentItem);
                    selectionEvent = this.updateCellSelection(cells, ctrlFlag, true, false);
                }
                if (this.cellColumnDragSelectionOccuring && this.handleCellHover(e.x, e.y)) {
                    GridColumn intentCol = this.hoveringColumn;
                    if (intentCol == null) {
                        int cfr_ignored_0 = e.y;
                    }
                    if (intentCol == null) {
                        return;
                    }
                    GridColumn iterCol = intentCol;
                    Vector<Point> newSelected = new Vector<Point>();
                    boolean decreasing = this.displayOrderedColumns.indexOf((Object)iterCol) > this.displayOrderedColumns.indexOf((Object)this.focusColumn);
                    while (true) {
                        this.getCells(iterCol, newSelected);
                        if (iterCol == this.focusColumn) break;
                        if (decreasing) {
                            iterCol = this.getPreviousVisibleColumn(iterCol);
                            continue;
                        }
                        iterCol = this.getNextVisibleColumn(iterCol);
                    }
                    selectionEvent = this.updateCellSelection(newSelected, ctrlFlag, true, false);
                }
            }
        }
        if (selectionEvent != null) {
            selectionEvent.stateMask = e.stateMask;
            selectionEvent.button = e.button;
            selectionEvent.item = this.getItem(new Point(e.x, e.y));
            selectionEvent.x = e.x;
            selectionEvent.y = e.y;
            this.notifyListeners(13, selectionEvent);
        }
    }

    private void handleHovering(int x, int y) {
        this.handleCellHover(x, y);
        if (this.cellSelectionEnabled && this.getData("DragSource") != null && this.handleHoverOnSelectionDragArea(x, y)) {
            return;
        }
        if (this.columnHeadersVisible && this.handleHoverOnColumnResizer(x, y)) {
            return;
        }
        if (this.rowsResizeable && this.rowHeaderVisible && this.handleHoverOnRowResizer(x, y)) {
            return;
        }
    }

    protected void refreshHoverState() {
        Point p = this.getDisplay().map(null, (Control)this, this.getDisplay().getCursorLocation());
        this.handleHovering(p.x, p.y);
    }

    private void onMouseExit(MouseEvent e) {
        this.hoveringItem = null;
        this.hoveringDetail = "";
        this.hoveringColumn = null;
        this.hoveringColumnHeader = null;
        this.hoverColumnGroupHeader = null;
        this.hoveringOverText = false;
        this.hideToolTip();
        this.redraw();
    }

    protected void onKeyDown(Event e) {
        GridColumn impliedFocusColumn;
        if (this.focusColumn == null || this.focusColumn.isDisposed()) {
            if (this.columns.size() == 0) {
                return;
            }
            this.intendedFocusColumn = this.focusColumn = this.getColumn(0);
        }
        if (e.character == '\r' && this.focusItem != null) {
            Event newEvent = new Event();
            newEvent.item = this.focusItem;
            this.notifyListeners(14, newEvent);
            return;
        }
        int attemptExpandCollapse = 0;
        if ((e.character == '-' || !this.cellSelectionEnabled && e.keyCode == 0x1000003) && this.focusItem != null && this.focusItem.isExpanded()) {
            attemptExpandCollapse = 18;
        } else if ((e.character == '+' || !this.cellSelectionEnabled && e.keyCode == 0x1000004) && this.focusItem != null && !this.focusItem.isExpanded()) {
            attemptExpandCollapse = 17;
        }
        if (attemptExpandCollapse != 0 && this.focusItem != null && this.focusItem.hasChildren()) {
            int performExpandCollapse = 0;
            if (this.cellSelectionEnabled && this.focusColumn != null && this.focusColumn.isTree()) {
                performExpandCollapse = attemptExpandCollapse;
            } else if (!this.cellSelectionEnabled) {
                performExpandCollapse = attemptExpandCollapse;
            }
            if (performExpandCollapse == 17) {
                this.focusItem.setExpanded(true);
                this.focusItem.fireEvent(17);
                return;
            }
            if (performExpandCollapse == 18) {
                this.focusItem.setExpanded(false);
                this.focusItem.fireEvent(18);
                return;
            }
        }
        if (e.character == ' ') {
            this.handleSpaceBarDown(e);
        }
        GridItem newSelection = null;
        GridColumn newColumnFocus = null;
        GridItem impliedFocusItem = this.focusItem == null || this.focusItem.isDisposed() ? null : this.focusItem;
        GridColumn gridColumn = impliedFocusColumn = this.focusColumn.isDisposed() ? null : this.focusColumn;
        if (this.cellSelectionEnabled && e.stateMask == SWT.MOD2 && this.shiftSelectionAnchorColumn != null) {
            impliedFocusItem = this.shiftSelectionAnchorItem == null || this.shiftSelectionAnchorItem.isDisposed() ? this.focusItem : this.shiftSelectionAnchorItem;
            impliedFocusColumn = this.shiftSelectionAnchorColumn.isDisposed() ? null : this.shiftSelectionAnchorColumn;
        }
        switch (e.keyCode) {
            case 0x1000004: {
                int index;
                if (this.cellSelectionEnabled) {
                    if (impliedFocusItem != null && impliedFocusColumn != null) {
                        newSelection = impliedFocusItem;
                        index = this.displayOrderedColumns.indexOf((Object)impliedFocusColumn);
                        int jumpAhead = impliedFocusItem.getColumnSpan(impliedFocusColumn.index);
                        ++jumpAhead;
                        while (jumpAhead > 0) {
                            if (++index >= this.displayOrderedColumns.size()) break;
                            if (!this.displayOrderedColumns.get(index).isVisible()) continue;
                            --jumpAhead;
                        }
                        newColumnFocus = index < this.displayOrderedColumns.size() ? this.displayOrderedColumns.get(index) : impliedFocusColumn;
                    }
                    this.intendedFocusColumn = newColumnFocus;
                    break;
                }
                if (impliedFocusItem == null || !impliedFocusItem.hasChildren()) break;
                newSelection = impliedFocusItem.getItem(0);
                break;
            }
            case 0x1000003: {
                int index;
                if (this.cellSelectionEnabled) {
                    if (impliedFocusItem != null && impliedFocusColumn != null) {
                        newSelection = impliedFocusItem;
                        index = this.displayOrderedColumns.indexOf((Object)impliedFocusColumn);
                        if (index != 0) {
                            newColumnFocus = this.displayOrderedColumns.get(index - 1);
                            if ((newColumnFocus = this.getVisibleColumn_DegradeLeft(impliedFocusItem, newColumnFocus)) == null) {
                                newColumnFocus = impliedFocusColumn;
                            }
                        } else {
                            newColumnFocus = impliedFocusColumn;
                        }
                    }
                    this.intendedFocusColumn = newColumnFocus;
                    break;
                }
                if (impliedFocusItem == null || impliedFocusItem.getParentItem() == null) break;
                newSelection = impliedFocusItem.getParentItem();
                break;
            }
            case 0x1000001: {
                if (impliedFocusItem != null) {
                    newSelection = this.getPreviousVisibleItem(impliedFocusItem);
                }
                if (impliedFocusColumn == null) break;
                if (newSelection != null) {
                    newColumnFocus = this.getVisibleColumn_DegradeLeft(newSelection, this.intendedFocusColumn);
                    break;
                }
                newColumnFocus = impliedFocusColumn;
                break;
            }
            case 0x1000002: {
                if (impliedFocusItem != null) {
                    newSelection = this.getNextVisibleItem(impliedFocusItem);
                } else if (this.items.size() > 0) {
                    newSelection = this.items.get(0);
                }
                if (impliedFocusColumn == null) break;
                if (newSelection != null && this.intendedFocusColumn != null) {
                    newColumnFocus = this.getVisibleColumn_DegradeLeft(newSelection, this.intendedFocusColumn);
                    break;
                }
                newColumnFocus = impliedFocusColumn;
                break;
            }
            case 0x1000007: {
                if (!this.cellSelectionEnabled) {
                    if (this.items.size() <= 0) break;
                    newSelection = this.items.get(0);
                    break;
                }
                if (e.stateMask == SWT.MOD1 && this.items.size() > 0) {
                    impliedFocusItem = this.items.get(0);
                }
                newSelection = impliedFocusItem;
                this.intendedFocusColumn = newColumnFocus = this.getVisibleColumn_DegradeRight(newSelection, this.displayOrderedColumns.get(0));
                break;
            }
            case 0x1000008: {
                if (!this.cellSelectionEnabled) {
                    if (this.items.size() <= 0) break;
                    newSelection = this.getPreviousVisibleItem(null);
                    break;
                }
                newSelection = impliedFocusItem;
                newColumnFocus = this.getVisibleColumn_DegradeLeft(newSelection, this.displayOrderedColumns.get(this.displayOrderedColumns.size() - 1));
                break;
            }
            case 0x1000005: {
                int topIndex = this.getTopIndex();
                newSelection = this.items.get(topIndex);
                if (this.focusItem == newSelection) {
                    RowRange range = this.getRowRange(this.getTopIndex(), this.getVisibleGridHeight(), false, true);
                    newSelection = this.items.get(range.startIndex);
                }
                if (impliedFocusColumn == null) break;
                if (newSelection != null && this.intendedFocusColumn != null) {
                    newColumnFocus = this.getVisibleColumn_DegradeLeft(newSelection, this.intendedFocusColumn);
                    break;
                }
                newColumnFocus = impliedFocusColumn;
                break;
            }
            case 0x1000006: {
                GridItem tmpItem;
                int bottomIndex = this.getBottomIndex();
                newSelection = this.items.get(bottomIndex);
                if (!this.isShown(newSelection) && (tmpItem = this.getPreviousVisibleItem(newSelection)) != null) {
                    newSelection = tmpItem;
                }
                if (this.focusItem == newSelection) {
                    RowRange range = this.getRowRange(this.getBottomIndex(), this.getVisibleGridHeight(), true, false);
                    newSelection = this.items.get(range.endIndex);
                }
                if (impliedFocusColumn == null) break;
                if (newSelection != null && this.intendedFocusColumn != null) {
                    newColumnFocus = this.getVisibleColumn_DegradeLeft(newSelection, this.intendedFocusColumn);
                    break;
                }
                newColumnFocus = impliedFocusColumn;
                break;
            }
        }
        if (newSelection == null) {
            return;
        }
        if (this.cellSelectionEnabled) {
            if (e.stateMask != SWT.MOD2) {
                this.focusColumn = newColumnFocus;
            }
            this.showColumn(newColumnFocus);
            if (e.stateMask != SWT.MOD2) {
                this.focusItem = newSelection;
            }
            this.showItem(newSelection);
            if (e.stateMask != SWT.MOD1 || this.isMod1Home(e)) {
                int stateMask = e.stateMask == SWT.MOD1 ? 0 : e.stateMask;
                Event selEvent = this.updateCellSelection(new Point(newColumnFocus.index, newSelection.getRowIndex()), stateMask, false, false);
                if (selEvent != null) {
                    selEvent.stateMask = stateMask;
                    selEvent.character = e.character;
                    selEvent.keyCode = e.keyCode;
                    this.notifyListeners(13, selEvent);
                }
            }
            this.redraw();
        } else {
            Event selectionEvent = null;
            if ((this.selectionType == GridSelectionType.SINGLE || e.stateMask != SWT.MOD1) && (selectionEvent = this.updateSelection(newSelection, e.stateMask)) != null) {
                selectionEvent.stateMask = e.stateMask;
                selectionEvent.character = e.character;
                selectionEvent.keyCode = e.keyCode;
            }
            this.focusItem = newSelection;
            this.showItem(newSelection);
            this.redraw();
            if (selectionEvent != null) {
                this.notifyListeners(13, selectionEvent);
            }
        }
    }

    private boolean isMod1Home(Event e) {
        return e.stateMask == SWT.MOD1 && e.keyCode == 0x1000007;
    }

    private void handleSpaceBarDown(Event event) {
        if (this.focusItem == null) {
            return;
        }
        if (this.selectionEnabled && !this.cellSelectionEnabled && !this.selectedItems.contains((Object)this.focusItem)) {
            this.selectedItems.add(this.focusItem);
            this.redraw();
            Event e = new Event();
            e.item = this.focusItem;
            e.stateMask = event.stateMask;
            e.character = event.character;
            e.keyCode = event.keyCode;
            this.notifyListeners(13, e);
        }
        if (!this.cellSelectionEnabled) {
            boolean checkFirstCol = false;
            boolean first = true;
            for (GridColumn col : this.columns) {
                if (first) {
                    if (!col.isCheck()) break;
                    first = false;
                    checkFirstCol = true;
                    continue;
                }
                if (!col.isCheck()) continue;
                checkFirstCol = false;
                break;
            }
            if (checkFirstCol) {
                this.focusItem.setChecked(!this.focusItem.getChecked());
                this.redraw();
                this.focusItem.fireCheckEvent(0);
            }
        }
    }

    private void onResize() {
        this.scrollValuesObsolete = true;
        this.topIndex = -1;
        this.bottomIndex = -1;
    }

    private void onScrollSelection() {
        this.topIndex = -1;
        this.bottomIndex = -1;
        this.refreshHoverState();
        this.redraw(this.getClientArea().x, this.getClientArea().y, this.getClientArea().width, this.getClientArea().height, false);
    }

    Point getOrigin(GridColumn column, GridItem item) {
        int x = 0;
        if (this.rowHeaderVisible) {
            x += this.rowHeaderWidth;
        }
        x -= this.getHScrollSelectionInPixels();
        for (GridColumn colIter : this.displayOrderedColumns) {
            if (colIter == column) break;
            if (!colIter.isVisible()) continue;
            x += colIter.getWidth();
        }
        int y = 0;
        if (item != null) {
            if (this.columnHeadersVisible) {
                y += this.headerHeight;
            }
            int currIndex = this.getTopIndex();
            int itemIndex = item.getRowIndex();
            if (itemIndex == -1) {
                SWT.error((int)5);
            }
            while (currIndex != itemIndex) {
                GridItem currItem;
                if (currIndex < itemIndex) {
                    currItem = this.items.get(currIndex);
                    if (currItem.isVisible()) {
                        y += currItem.getHeight() + 1;
                    }
                    ++currIndex;
                    continue;
                }
                if (currIndex <= itemIndex || !(currItem = this.items.get(--currIndex)).isVisible()) continue;
                y -= currItem.getHeight() + 1;
            }
        } else if (column.getColumnGroup() != null) {
            y += this.groupHeaderHeight;
        }
        return new Point(x, y);
    }

    private boolean handleCellClick(GridItem item, int x, int y) {
        GridColumn col = this.getColumn(new Point(x, y));
        if (col == null) {
            return false;
        }
        col.getCellRenderer().setBounds(item.getBounds(col.index));
        return col.getCellRenderer().notify(3, new Point(x, y), (Object)item);
    }

    private boolean handleCellHover(int x, int y) {
        String detail = "";
        boolean overText = false;
        GridColumn col = this.getColumn(new Point(x, y));
        GridItem item = x >= this.getClientArea().width - 1 ? this.hoveringItem : (x < this.getClientArea().x ? this.hoveringItem : this.getItem(new Point(x, y)));
        GridColumnGroup hoverColGroup = null;
        GridColumn hoverColHeader = null;
        if (col != null) {
            if (item != null) {
                if (y < this.getClientArea().height - (this.columnFootersVisible ? this.footerHeight : 0)) {
                    col.getCellRenderer().setBounds(item.getBounds(col.index));
                    if (col.getCellRenderer().notify(5, new Point(x, y), (Object)item)) {
                        detail = col.getCellRenderer().getHoverDetail();
                    }
                    if ((textBounds = col.getCellRenderer().getTextBounds(item, false)) != null) {
                        p = new Point(x - col.getCellRenderer().getBounds().x, y - col.getCellRenderer().getBounds().y);
                        overText = textBounds.contains(p);
                    }
                }
            } else if (y < this.headerHeight) {
                if (this.columnGroups.length != 0 && y < this.groupHeaderHeight && col.getColumnGroup() != null) {
                    hoverColGroup = col.getColumnGroup();
                    hoverColGroup.getHeaderRenderer().setBounds(hoverColGroup.getBounds());
                    if (hoverColGroup.getHeaderRenderer().notify(5, new Point(x, y), (Object)hoverColGroup)) {
                        detail = hoverColGroup.getHeaderRenderer().getHoverDetail();
                    }
                    if ((textBounds = hoverColGroup.getHeaderRenderer().getTextBounds((Object)hoverColGroup, false)) != null) {
                        p = new Point(x - hoverColGroup.getHeaderRenderer().getBounds().x, y - hoverColGroup.getHeaderRenderer().getBounds().y);
                        overText = textBounds.contains(p);
                    }
                } else {
                    hoverColHeader = col;
                    col.getHeaderRenderer().setBounds(col.getBounds());
                    if (col.getHeaderRenderer().notify(5, new Point(x, y), (Object)col)) {
                        detail = col.getHeaderRenderer().getHoverDetail();
                    }
                    if ((textBounds = col.getHeaderRenderer().getTextBounds((Object)col, false)) != null) {
                        p = new Point(x - col.getHeaderRenderer().getBounds().x, y - col.getHeaderRenderer().getBounds().y);
                        overText = textBounds.contains(p);
                    }
                }
            }
        }
        boolean hoverChange = false;
        if (this.hoveringItem != item || !this.hoveringDetail.equals(detail) || this.hoveringColumn != col || hoverColGroup != this.hoverColumnGroupHeader || hoverColHeader != this.hoveringColumnHeader) {
            this.hoveringItem = item;
            this.hoveringDetail = detail;
            this.hoveringColumn = col;
            this.hoveringColumnHeader = hoverColHeader;
            this.hoverColumnGroupHeader = hoverColGroup;
            Rectangle clientArea = this.getClientArea();
            this.redraw(clientArea.x, clientArea.y, clientArea.width, clientArea.height, false);
            hoverChange = true;
        }
        if (hoverChange || this.hoveringOverText != overText) {
            this.hoveringOverText = overText;
            if (overText) {
                Rectangle cellBounds = null;
                Rectangle textBounds = null;
                Rectangle preferredTextBounds = null;
                if (this.hoveringItem != null && this.hoveringItem.getToolTipText(col.index) == null && !col.getWordWrap()) {
                    cellBounds = col.getCellRenderer().getBounds();
                    if (cellBounds.x + cellBounds.width > this.getSize().x) {
                        cellBounds.width = this.getSize().x - cellBounds.x;
                    }
                    textBounds = col.getCellRenderer().getTextBounds(item, false);
                    preferredTextBounds = col.getCellRenderer().getTextBounds(item, true);
                } else if (this.hoveringColumnHeader != null && this.hoveringColumnHeader.getHeaderTooltip() == null) {
                    cellBounds = this.hoveringColumnHeader.getHeaderRenderer().getBounds();
                    if (cellBounds.x + cellBounds.width > this.getSize().x) {
                        cellBounds.width = this.getSize().x - cellBounds.x;
                    }
                    textBounds = this.hoveringColumnHeader.getHeaderRenderer().getTextBounds((Object)col, false);
                    preferredTextBounds = this.hoveringColumnHeader.getHeaderRenderer().getTextBounds((Object)col, true);
                } else if (this.hoverColumnGroupHeader != null) {
                    cellBounds = this.hoverColumnGroupHeader.getHeaderRenderer().getBounds();
                    if (cellBounds.x + cellBounds.width > this.getSize().x) {
                        cellBounds.width = this.getSize().x - cellBounds.x;
                    }
                    textBounds = this.hoverColumnGroupHeader.getHeaderRenderer().getTextBounds((Object)this.hoverColumnGroupHeader, false);
                    preferredTextBounds = this.hoverColumnGroupHeader.getHeaderRenderer().getTextBounds((Object)this.hoverColumnGroupHeader, true);
                }
                if (textBounds != null && textBounds.width < preferredTextBounds.width) {
                    this.showToolTip(item, col, this.hoverColumnGroupHeader, new Point(cellBounds.x + textBounds.x, cellBounds.y + textBounds.y));
                    this.setCapture(true);
                    this.inplaceTooltipCapture = true;
                }
            } else {
                this.hideToolTip();
            }
        }
        if (hoverChange) {
            String newTip = null;
            if (this.hoveringItem != null && this.hoveringColumn != null) {
                newTip = this.hoveringItem.getToolTipText(this.hoveringColumn.index);
            } else if (this.hoveringColumn != null && this.hoveringColumnHeader != null) {
                newTip = this.hoveringColumn.getHeaderTooltip();
            }
            if (newTip == null) {
                newTip = this.getToolTipText();
            }
            if (newTip != null && !newTip.equals(this.displayedToolTipText)) {
                this.updateToolTipText(newTip);
            } else if (newTip == null && this.displayedToolTipText != null) {
                this.updateToolTipText(null);
            }
            this.displayedToolTipText = newTip;
        }
        return hoverChange;
    }

    protected void updateToolTipText(String text) {
        super.setToolTipText(text);
    }

    protected void setScrollValuesObsolete() {
        this.scrollValuesObsolete = true;
        this.redraw();
    }

    int newColumn(GridColumn column, int index) {
        int size = this.columns.size();
        if (index == -1) {
            column.index = size;
            this.columns.add(column);
            this.displayOrderedColumns.add(column);
        } else {
            column.index = index;
            this.columns.add(index, column);
            int i = index + 1;
            while (i < size) {
                this.columns.get((int)i).index = i;
                ++i;
            }
            this.displayOrderedColumns.add(index, column);
            this.dataVisualizer.addColumn(index);
            i = 0;
            while (i < size) {
                this.columns.get(i).setColumnIndex(i);
                ++i;
            }
        }
        this.estimate(sizingGC -> {
            this.computeHeaderHeight((GC)sizingGC);
            this.computeFooterHeight((GC)sizingGC);
        });
        this.updatePrimaryCheckColumn();
        for (GridItem item : this.items) {
            item.columnAdded(index);
        }
        this.scrollValuesObsolete = true;
        this.redraw();
        this.clearDisplayOrderedCache();
        return size - 1;
    }

    void removeColumn(GridColumn column) {
        boolean selectionModified = false;
        int index = column.index;
        if (this.cellSelectionEnabled) {
            Vector<Point> removeSelectedCells = new Vector<Point>();
            for (Point cell : this.selectedCells) {
                if (cell.x != index) continue;
                removeSelectedCells.add(cell);
            }
            if (removeSelectedCells.size() > 0) {
                this.selectedCells.removeAll(removeSelectedCells);
                selectionModified = true;
            }
            for (Point cell : this.selectedCells) {
                if (cell.x < index) continue;
                --cell.x;
                selectionModified = true;
            }
        }
        this.columns.remove((Object)column);
        int size = this.columns.size();
        int i = index;
        while (i < size) {
            this.columns.get((int)i).index = i;
            ++i;
        }
        this.displayOrderedColumns.remove((Object)column);
        this.dataVisualizer.clearColumn(index);
        if (this.focusColumn == column) {
            this.focusColumn = null;
        }
        this.updatePrimaryCheckColumn();
        this.scrollValuesObsolete = true;
        this.redraw();
        i = 0;
        for (GridColumn col : this.columns) {
            col.setColumnIndex(i);
            ++i;
        }
        if (selectionModified && !this.disposing) {
            this.updateColumnSelection();
        }
        this.clearDisplayOrderedCache();
    }

    private void updatePrimaryCheckColumn() {
        if ((this.getStyle() & 0x20) == 32) {
            boolean firstCol = true;
            for (GridColumn col : this.columns) {
                col.setTableCheck(firstCol);
                firstCol = false;
            }
        }
    }

    void newRootItem(GridItem item, int index) {
        if (index == -1 || index >= this.rootItems.size()) {
            this.rootItems.add(item);
        } else {
            this.rootItems.add(index, item);
        }
    }

    void removeRootItem(GridItem item) {
        this.rootItems.remove((Object)item);
    }

    int newItem(GridItem item, int index, boolean root) {
        int row = 0;
        if (!this.isTree && item.getParentItem() != null) {
            this.isTree = true;
        }
        if (root && index != -1) {
            index = index >= this.rootItems.size() ? -1 : this.rootItems.get(index).getRowIndex();
        } else if (!root) {
            if (index >= item.getParentItem().getItems().length || index == -1) {
                GridItem rightMostDescendent = item.getParentItem();
                while (rightMostDescendent.getItems().length > 0) {
                    rightMostDescendent = rightMostDescendent.getItems()[rightMostDescendent.getItems().length - 1];
                }
                index = rightMostDescendent.getRowIndex() + 1;
            } else {
                index = item.getParentItem().getItems()[index].getRowIndex();
            }
        }
        if (index == -1) {
            this.items.add(item);
            row = this.items.size() - 1;
        } else {
            this.items.add(index, item);
            row = index;
            int i = index + 1;
            while (i < this.items.size()) {
                this.items.get(i).increaseRow();
                ++i;
            }
        }
        this.estimate(sizingGC -> {
            if (this.items.size() == 1 && !this.userModifiedItemHeight) {
                this.itemHeight = this.computeItemHeight(item, (GC)sizingGC);
                if ((this.getStyle() & 0x10000000) != 0) {
                    item.setHasSetData(false);
                }
            }
            item.initializeHeight(this.itemHeight);
            if (this.isRowHeaderVisible() && this.isAutoWidth()) {
                this.rowHeaderWidth = Math.max(this.rowHeaderWidth, this.rowHeaderRenderer.computeSize((GC)sizingGC, (int)-1, (int)-1, (Object)((Object)((Object)gridItem))).x);
            }
        });
        this.scrollValuesObsolete = true;
        this.topIndex = -1;
        this.bottomIndex = -1;
        ++this.currentVisibleItems;
        this.redraw();
        return row;
    }

    void removeItem(GridItem item) {
        Point[] cells = this.getCells(item);
        boolean selectionModified = false;
        int index = item.getRowIndex();
        this.items.remove((Object)item);
        this.dataVisualizer.clearRow(item);
        if (this.disposing) {
            return;
        }
        int i = index;
        while (i < this.items.size()) {
            this.items.get(i).decreaseRow();
            ++i;
        }
        if (this.selectedItems.remove((Object)item)) {
            selectionModified = true;
        }
        Point[] pointArray = cells;
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            Point cell = pointArray[n2];
            if (this.selectedCells.remove(cell)) {
                selectionModified = true;
            }
            ++n2;
        }
        if (this.focusItem == item) {
            this.focusItem = null;
        }
        this.scrollValuesObsolete = true;
        this.topIndex = -1;
        this.bottomIndex = -1;
        if (item.isVisible()) {
            --this.currentVisibleItems;
        }
        if (selectionModified && !this.disposing) {
            this.updateColumnSelection();
        }
        this.redraw();
        this.updateScrollbars();
    }

    void newColumnGroup(GridColumnGroup group) {
        GridColumnGroup[] newColumnGroups = new GridColumnGroup[this.columnGroups.length + 1];
        System.arraycopy(this.columnGroups, 0, newColumnGroups, 0, this.columnGroups.length);
        newColumnGroups[newColumnGroups.length - 1] = group;
        this.columnGroups = newColumnGroups;
        if (this.columnGroups.length == 1) {
            this.computeHeaderHeight();
        }
        this.scrollValuesObsolete = true;
        this.redraw();
    }

    void removeColumnGroup(GridColumnGroup group) {
        GridColumnGroup[] newColumnGroups = new GridColumnGroup[this.columnGroups.length - 1];
        int newIndex = 0;
        GridColumnGroup[] gridColumnGroupArray = this.columnGroups;
        int n = this.columnGroups.length;
        int n2 = 0;
        while (n2 < n) {
            GridColumnGroup columnGroup = gridColumnGroupArray[n2];
            if (columnGroup != group) {
                newColumnGroups[newIndex] = columnGroup;
                ++newIndex;
            }
            ++n2;
        }
        this.columnGroups = newColumnGroups;
        if (this.columnGroups.length == 0) {
            this.computeHeaderHeight();
        }
        this.scrollValuesObsolete = true;
        this.redraw();
    }

    void updateVisibleItems(int amount) {
        this.currentVisibleItems += amount;
    }

    public GridItem getFocusItem() {
        this.checkWidget();
        return this.focusItem;
    }

    public Point getFocusCell() {
        this.checkWidget();
        if (!this.cellSelectionEnabled) {
            return null;
        }
        int x = -1;
        int y = -1;
        if (this.focusColumn != null) {
            x = this.focusColumn.index;
        }
        if (this.focusItem != null) {
            y = this.focusItem.getRowIndex();
        }
        return new Point(x, y);
    }

    public void setFocusItem(GridItem item) {
        this.checkWidget();
        if (item == null || item.isDisposed() || item.getParent() != this) {
            SWT.error((int)5);
        }
        this.focusItem = item;
    }

    public void setFocusColumn(GridColumn column) {
        this.checkWidget();
        if (column == null || column.isDisposed() || column.getParent() != this || !column.isVisible()) {
            SWT.error((int)5);
        }
        this.focusColumn = column;
        this.intendedFocusColumn = column;
    }

    GridColumn[] getColumnsInOrder() {
        this.checkWidget();
        return this.displayOrderedColumns.toArray(new GridColumn[this.columns.size()]);
    }

    public boolean getColumnScrolling() {
        this.checkWidget();
        return this.columnScrolling;
    }

    public void setColumnScrolling(boolean columnScrolling) {
        this.checkWidget();
        if (this.rowHeaderVisible && !columnScrolling) {
            return;
        }
        this.columnScrolling = columnScrolling;
        this.scrollValuesObsolete = true;
        this.redraw();
    }

    GridColumn getVisibleColumn_DegradeLeft(GridItem item, GridColumn col) {
        int index = this.displayOrderedColumns.indexOf((Object)col);
        GridColumn prevCol = col;
        int i = 0;
        while (!prevCol.isVisible()) {
            if (index - ++i < 0) {
                return null;
            }
            prevCol = this.displayOrderedColumns.get(index - i);
        }
        index = this.displayOrderedColumns.indexOf((Object)prevCol);
        int j = 0;
        while (j < index) {
            GridColumn tempCol = this.displayOrderedColumns.get(j);
            if (tempCol.isVisible() && item.getColumnSpan(tempCol.index) >= index - j) {
                prevCol = tempCol;
                break;
            }
            ++j;
        }
        return prevCol;
    }

    GridColumn getVisibleColumn_DegradeRight(GridItem item, GridColumn col) {
        int index = this.displayOrderedColumns.indexOf((Object)col);
        int i = 0;
        GridColumn nextCol = col;
        while (!nextCol.isVisible()) {
            if (index + ++i == this.displayOrderedColumns.size()) {
                return null;
            }
            nextCol = this.displayOrderedColumns.get(index + i);
        }
        int startIndex = index = this.displayOrderedColumns.indexOf((Object)nextCol);
        while (index > 0) {
            GridColumn prevCol = this.displayOrderedColumns.get(--index);
            if (item.getColumnSpan(prevCol.index) < startIndex - index) continue;
            if (startIndex == this.displayOrderedColumns.size() - 1) {
                return null;
            }
            return this.getVisibleColumn_DegradeRight(item, this.displayOrderedColumns.get(startIndex + 1));
        }
        return nextCol;
    }

    public boolean getCellSelectionEnabled() {
        this.checkWidget();
        return this.cellSelectionEnabled;
    }

    public void setCellSelectionEnabled(boolean cellSelection) {
        this.checkWidget();
        if (!cellSelection) {
            this.selectedCells.clear();
            this.redraw();
        } else {
            if ((this.getStyle() & 4) == 0) {
                this.selectionType = GridSelectionType.MULTI;
            }
            this.selectedItems.clear();
            this.redraw();
        }
        this.cellSelectionEnabled = cellSelection;
    }

    public boolean isCellSelectionEnabled() {
        return this.cellSelectionEnabled;
    }

    public void setCellDragSelectionEnabled(boolean cellDragSelection) {
        this.checkWidget();
        this.cellDragSelectionEnabled = cellDragSelection;
    }

    public boolean isCellDragSelectionEnabled() {
        return this.cellDragSelectionEnabled;
    }

    public void deselectCell(Point cell) {
        this.checkWidget();
        if (cell == null) {
            SWT.error((int)4);
        }
        this.selectedCells.remove(cell);
        this.updateColumnSelection();
        this.redraw();
    }

    public void deselectCells(Point[] cells) {
        Point cell;
        this.checkWidget();
        if (cells == null) {
            SWT.error((int)4);
        }
        Point[] pointArray = cells;
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            cell = pointArray[n2];
            if (cell == null) {
                SWT.error((int)4);
            }
            ++n2;
        }
        pointArray = cells;
        n = cells.length;
        n2 = 0;
        while (n2 < n) {
            cell = pointArray[n2];
            this.selectedCells.remove(cell);
            ++n2;
        }
        this.updateColumnSelection();
        this.redraw();
    }

    public void deselectAllCells() {
        this.checkWidget();
        this.selectedCells.clear();
        this.updateColumnSelection();
        this.redraw();
    }

    public void selectCell(Point cell) {
        this.checkWidget();
        if (!this.cellSelectionEnabled) {
            return;
        }
        if (cell == null) {
            SWT.error((int)4);
        }
        this.addToCellSelection(cell);
        this.updateColumnSelection();
        this.redraw();
    }

    public void selectCells(Point[] cells) {
        Point cell;
        this.checkWidget();
        if (!this.cellSelectionEnabled) {
            return;
        }
        if (cells == null) {
            SWT.error((int)4);
        }
        Point[] pointArray = cells;
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            cell = pointArray[n2];
            if (cell == null) {
                SWT.error((int)4);
            }
            ++n2;
        }
        pointArray = cells;
        n = cells.length;
        n2 = 0;
        while (n2 < n) {
            cell = pointArray[n2];
            this.addToCellSelection(cell);
            ++n2;
        }
        this.updateColumnSelection();
        this.redraw();
    }

    public void selectAllCells() {
        this.checkWidget();
        this.selectAllCellsInternal();
    }

    private Event selectAllCellsInternal() {
        if (!this.cellSelectionEnabled) {
            return this.selectAllRowsInternal();
        }
        if (this.columns.size() == 0) {
            return null;
        }
        if (this.items.size() == 0) {
            return null;
        }
        int index = 0;
        GridColumn column = this.displayOrderedColumns.get(index);
        while (!column.isVisible()) {
            if (++index >= this.columns.size()) {
                return null;
            }
            column = this.displayOrderedColumns.get(index);
        }
        GridColumn oldFocusColumn = this.focusColumn;
        GridItem oldFocusItem = this.focusItem;
        this.focusColumn = column;
        this.focusItem = this.items.get(0);
        GridItem lastItem = this.getPreviousVisibleItem(null);
        GridColumn lastCol = this.getVisibleColumn_DegradeLeft(lastItem, this.displayOrderedColumns.get(this.displayOrderedColumns.size() - 1));
        Event event = this.updateCellSelection(new Point(lastCol.index, lastItem.getRowIndex()), SWT.MOD2, true, false);
        this.focusColumn = oldFocusColumn;
        this.focusItem = oldFocusItem;
        this.updateColumnSelection();
        this.redraw();
        return event;
    }

    private Event selectAllRowsInternal() {
        if (this.cellSelectionEnabled) {
            return this.selectAllCellsInternal();
        }
        if (GridSelectionType.MULTI != this.selectionType) {
            return null;
        }
        if (this.items.size() == 0) {
            return null;
        }
        this.deselectAll();
        GridItem oldFocusItem = this.focusItem;
        GridItem firstItem = this.getItem(this.getTopIndex());
        GridItem lastItem = this.getPreviousVisibleItem(null);
        this.setFocusItem(firstItem);
        this.updateSelection(firstItem, 0);
        Event event = this.updateSelection(lastItem, SWT.MOD2);
        this.setFocusItem(oldFocusItem);
        this.redraw();
        return event;
    }

    public void selectColumn(int col) {
        this.checkWidget();
        Vector<Point> cells = new Vector<Point>();
        this.getCells(this.getColumn(col), cells);
        this.selectCells(cells.toArray(new Point[0]));
    }

    public void selectColumnGroup(int colGroup) {
        this.selectColumnGroup(this.getColumnGroup(colGroup));
    }

    public void selectColumnGroup(GridColumnGroup colGroup) {
        this.checkWidget();
        Vector<Point> cells = new Vector<Point>();
        this.getCells(colGroup, cells);
        this.selectCells(cells.toArray(new Point[0]));
    }

    public void setCellSelection(Point cell) {
        this.checkWidget();
        if (!this.cellSelectionEnabled) {
            return;
        }
        if (cell == null) {
            SWT.error((int)4);
        }
        if (!this.isValidCell(cell)) {
            SWT.error((int)5);
        }
        this.selectedCells.clear();
        this.addToCellSelection(cell);
        this.updateColumnSelection();
        this.redraw();
    }

    public void setCellSelection(Point[] cells) {
        Point cell;
        this.checkWidget();
        if (!this.cellSelectionEnabled) {
            return;
        }
        if (cells == null) {
            SWT.error((int)4);
        }
        Point[] pointArray = cells;
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            cell = pointArray[n2];
            if (cell == null) {
                SWT.error((int)4);
            }
            if (!this.isValidCell(cell)) {
                SWT.error((int)5);
            }
            ++n2;
        }
        this.selectedCells.clear();
        pointArray = cells;
        n = cells.length;
        n2 = 0;
        while (n2 < n) {
            cell = pointArray[n2];
            this.addToCellSelection(cell);
            ++n2;
        }
        this.updateColumnSelection();
        this.redraw();
    }

    public Point[] getCellSelection() {
        this.checkWidget();
        return this.selectedCells.toArray(new Point[this.selectedCells.size()]);
    }

    GridColumn getFocusColumn() {
        return this.focusColumn;
    }

    void updateColumnFocus() {
        if (!this.focusColumn.isVisible()) {
            int index = this.displayOrderedColumns.indexOf((Object)this.focusColumn);
            if (index > 0) {
                GridColumn prev = this.displayOrderedColumns.get(index - 1);
                if ((prev = this.getVisibleColumn_DegradeLeft(this.focusItem, prev)) == null) {
                    prev = this.getVisibleColumn_DegradeRight(this.focusItem, this.focusColumn);
                }
                this.focusColumn = prev;
            } else {
                this.focusColumn = this.getVisibleColumn_DegradeRight(this.focusItem, this.focusColumn);
            }
        }
    }

    private void getCells(GridColumn col, Vector<Point> cells) {
        int colIndex = col.index;
        int columnAtPosition = 0;
        for (GridColumn nextCol : this.displayOrderedColumns) {
            if (!nextCol.isVisible()) continue;
            if (nextCol == col) break;
            ++columnAtPosition;
        }
        GridItem item = null;
        if (this.getItemCount() > 0) {
            item = this.getItem(0);
        }
        while (item != null) {
            int position = -1;
            boolean spanned = false;
            for (GridColumn nextCol : this.displayOrderedColumns) {
                if (!nextCol.isVisible()) continue;
                if (nextCol == col) break;
                int span = item.getColumnSpan(nextCol.index);
                if (-1 + span < columnAtPosition) continue;
                spanned = true;
                break;
            }
            if (!spanned && item.getColumnSpan(colIndex) == 0) {
                cells.add(new Point(colIndex, item.getRowIndex()));
            }
            item = this.getNextVisibleItem(item);
        }
    }

    private void getCells(GridColumnGroup colGroup, Vector<Point> cells) {
        GridColumn[] cols;
        GridColumn[] gridColumnArray = cols = colGroup.getColumns();
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            GridColumn col = gridColumnArray[n2];
            this.getCells(col, cells);
            ++n2;
        }
    }

    private void getCells(GridItem item, Vector<Point> cells) {
        int itemIndex = item.getRowIndex();
        int span = 0;
        for (GridColumn nextCol : this.displayOrderedColumns) {
            if (span > 0) {
                --span;
                continue;
            }
            if (!nextCol.isVisible()) continue;
            span = item.getColumnSpan(nextCol.index);
            cells.add(new Point(nextCol.index, itemIndex));
        }
    }

    private Point[] getCells(GridItem item) {
        Vector<Point> cells = new Vector<Point>();
        int itemIndex = item.getRowIndex();
        int span = 0;
        for (GridColumn nextCol : this.displayOrderedColumns) {
            if (span > 0) {
                --span;
                continue;
            }
            if (!nextCol.isVisible()) continue;
            span = item.getColumnSpan(nextCol.index);
            cells.add(new Point(nextCol.index, itemIndex));
        }
        return cells.toArray(new Point[0]);
    }

    private void getCells(GridItem fromItem, GridItem toItem, Vector<Point> cells) {
        boolean descending = fromItem.getRowIndex() < toItem.getRowIndex();
        GridItem iterItem = toItem;
        while (true) {
            this.getCells(iterItem, cells);
            if (iterItem == fromItem) break;
            if (descending) {
                iterItem = this.getPreviousVisibleItem(iterItem);
                continue;
            }
            iterItem = this.getNextVisibleItem(iterItem);
        }
    }

    private int blend(int v1, int v2, int ratio) {
        return (ratio * v1 + (100 - ratio) * v2) / 100;
    }

    private RGB blend(RGB c1, RGB c2, int ratio) {
        int r = this.blend(c1.red, c2.red, ratio);
        int g = this.blend(c1.green, c2.green, ratio);
        int b = this.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    private Point getSelectionRange(GridItem fromItem, GridColumn fromColumn, GridItem toItem, GridColumn toColumn) {
        Item temp;
        if (this.displayOrderedColumns.indexOf((Object)fromColumn) > this.displayOrderedColumns.indexOf((Object)toColumn)) {
            temp = fromColumn;
            fromColumn = toColumn;
            toColumn = temp;
        }
        if (fromItem.getRowIndex() > toItem.getRowIndex()) {
            temp = fromItem;
            fromItem = toItem;
            toItem = temp;
        }
        boolean firstTime = true;
        GridItem iterItem = fromItem;
        int fromIndex = fromColumn.index;
        int toIndex = toColumn.index;
        do {
            if (!firstTime) {
                iterItem = this.getNextVisibleItem(iterItem);
            } else {
                firstTime = false;
            }
            Point cols = this.getRowSelectionRange(iterItem, fromColumn, toColumn);
            if (cols.x == fromIndex && cols.y == toIndex) continue;
            GridColumn newFrom = this.getColumn(cols.x);
            GridColumn newTo = this.getColumn(cols.y);
            return this.getSelectionRange(fromItem, newFrom, toItem, newTo);
        } while (iterItem != toItem);
        return new Point(fromColumn.index, toColumn.index);
    }

    private Point getRowSelectionRange(GridItem item, GridColumn fromColumn, GridColumn toColumn) {
        int newFrom = fromColumn.index;
        int newTo = toColumn.index;
        int span = 0;
        int spanningColIndex = -1;
        boolean spanningBeyondToCol = false;
        for (GridColumn col : this.displayOrderedColumns) {
            if (!col.isVisible()) {
                if (span <= 0) continue;
                --span;
                continue;
            }
            if (span > 0) {
                if (col == fromColumn) {
                    newFrom = spanningColIndex;
                } else if (col == toColumn && span > 1) {
                    spanningBeyondToCol = true;
                }
                if (spanningBeyondToCol && --span == 0) {
                    newTo = col.index;
                    break;
                }
            } else {
                int index = col.index;
                span = item.getColumnSpan(index);
                if (span > 0) {
                    spanningColIndex = index;
                }
                if (col == toColumn && span > 0) {
                    spanningBeyondToCol = true;
                }
            }
            if (col == toColumn && !spanningBeyondToCol) break;
        }
        return new Point(newFrom, newTo);
    }

    private GridColumn getSpanningColumn(GridItem item, GridColumn column) {
        int span = 0;
        GridColumn spanningCol = null;
        for (GridColumn col : this.displayOrderedColumns) {
            if (col == column) {
                return spanningCol;
            }
            if (span > 0) {
                if (--span != 0) continue;
                spanningCol = null;
                continue;
            }
            span = item.getColumnSpan(col.index);
            if (span <= 0) continue;
            spanningCol = col;
        }
        return spanningCol;
    }

    private boolean isValidCell(Point cell) {
        if (cell.x < 0 || cell.x >= this.columns.size()) {
            return false;
        }
        return cell.y >= 0 && cell.y < this.items.size();
    }

    protected void showToolTip(GridItem item, GridColumn column, GridColumnGroup group, Point location) {
        if (this.inplaceToolTip == null) {
            this.inplaceToolTip = new GridToolTip((Control)this);
        }
        if (group != null) {
            this.inplaceToolTip.setFont(this.getFont());
            this.inplaceToolTip.setText(group.getText());
        } else if (item != null) {
            this.inplaceToolTip.setFont(item.getFont(column.index));
            this.inplaceToolTip.setText(item.getText(column.index));
        } else if (column != null) {
            this.inplaceToolTip.setFont(this.getFont());
            this.inplaceToolTip.setText(column.getText());
        }
        Point p = this.getDisplay().map((Control)this, null, location);
        this.inplaceToolTip.setLocation(p);
        this.inplaceToolTip.setVisible(true);
    }

    protected void hideToolTip() {
        if (this.inplaceToolTip != null) {
            this.inplaceToolTip.setVisible(false);
        }
        if (this.inplaceTooltipCapture) {
            this.setCapture(false);
            this.inplaceTooltipCapture = false;
        }
    }

    void recalculateRowHeaderHeight(GridItem item, int oldHeight, int newHeight) {
        this.checkWidget();
        if (newHeight > this.itemHeight) {
            this.itemHeight = newHeight;
            this.userModifiedItemHeight = false;
            this.hasDifferingHeights = false;
            this.itemHeight = this.computeItemHeight(this.items.get(0));
            for (GridItem item2 : this.items) {
                item2.setHeight(this.itemHeight);
            }
            this.setScrollValuesObsolete();
            this.redraw();
        }
    }

    void recalculateRowHeaderWidth(GridItem item, int oldWidth, int newWidth) {
        if (!this.isAutoWidth()) {
            return;
        }
        if (newWidth > this.rowHeaderWidth) {
            this.rowHeaderWidth = newWidth;
        } else if (newWidth < this.rowHeaderWidth && oldWidth == this.rowHeaderWidth) {
            this.computeRowHeaderWidth(newWidth);
        }
        this.redraw();
    }

    public void setFont(Font font) {
        this.dataVisualizer.setDefaultFont(font);
        this.defaultFont = font;
        super.setFont(font);
    }

    public int getItemHeaderWidth() {
        this.checkWidget();
        if (!this.rowHeaderVisible) {
            return 0;
        }
        return this.rowHeaderWidth;
    }

    public void setItemHeaderWidth(int width) {
        this.checkWidget();
        this.rowHeaderWidth = width;
        this.setAutoWidth(false);
        this.redraw();
    }

    public void setItemCount(int count) {
        this.checkWidget();
        this.setRedraw(false);
        if (count < 0) {
            count = 0;
        }
        if (count < this.items.size()) {
            this.selectedCells.clear();
            int i = this.items.size() - 1;
            while (i >= count) {
                GridItem removed = this.items.remove(i);
                this.rootItems.remove(i);
                this.selectedItems.remove((Object)removed);
                if (removed.isVisible()) {
                    --this.currentVisibleItems;
                }
                removed.disposeOnly();
                --i;
            }
            if (!this.disposing) {
                this.updateColumnSelection();
            }
            this.scrollValuesObsolete = true;
            this.topIndex = -1;
            this.bottomIndex = -1;
        }
        while (count > this.items.size()) {
            new GridItem(this, 0);
        }
        this.setRedraw(true);
    }

    private void initAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getDescription(AccessibleEvent e) {
                int childID = e.childID;
                if (childID >= 0 && childID < Grid.this.items.size()) {
                    Object descrption = "";
                    int i = 0;
                    while (i < Grid.this.columns.size()) {
                        if (i != 0) {
                            descrption = (String)descrption + Grid.this.columns.get(i).getText() + " : ";
                            descrption = (String)descrption + Grid.this.items.get(childID).getText(i) + " ";
                        }
                        ++i;
                    }
                    e.result = descrption;
                }
            }

            public void getName(AccessibleEvent e) {
                int childID = e.childID;
                if (childID >= 0 && childID < Grid.this.items.size()) {
                    e.result = Grid.this.items.get(childID).getText();
                } else if (childID >= Grid.this.items.size() && childID < Grid.this.items.size() + Grid.this.columns.size()) {
                    e.result = Grid.this.columns.get(childID - Grid.this.items.size()).getText();
                } else if (childID >= Grid.this.items.size() + Grid.this.columns.size() && childID < Grid.this.items.size() + Grid.this.columns.size() + Grid.this.columnGroups.length) {
                    e.result = Grid.this.columnGroups[childID - Grid.this.items.size() - Grid.this.columns.size()].getText();
                } else if (childID >= Grid.this.items.size() + Grid.this.columns.size() + Grid.this.columnGroups.length && childID < Grid.this.items.size() + Grid.this.columns.size() + Grid.this.columnGroups.length + Grid.this.columnGroups.length) {
                    e.result = Grid.ACC_TOGGLE_BUTTON_NAME;
                }
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                block7: {
                    int itemCount;
                    Point location;
                    block8: {
                        block6: {
                            location = Grid.this.toControl(e.x, e.y);
                            e.childID = -1;
                            GridItem item = Grid.this.getItem(location);
                            if (item == null) break block6;
                            int i = 0;
                            while (i < Grid.this.getItemCount()) {
                                if (((Object)((Object)item)).equals((Object)Grid.this.getItem(i))) {
                                    e.childID = i;
                                    return;
                                }
                                ++i;
                            }
                            break block7;
                        }
                        GridColumn column = Grid.this.overColumnHeader(location.x, location.y);
                        itemCount = Grid.this.getItemCount();
                        if (column == null) break block8;
                        int i = 0;
                        while (i < Grid.this.getColumns().length) {
                            if (((Object)((Object)column)).equals((Object)Grid.this.getColumn(i))) {
                                e.childID = itemCount + i;
                                return;
                            }
                            ++i;
                        }
                        break block7;
                    }
                    GridColumnGroup columnGroup = Grid.this.overColumnGroupHeader(location.x, location.y);
                    if (columnGroup == null) break block7;
                    int i = 0;
                    while (i < Grid.this.getColumnGroups().length) {
                        if (((Object)((Object)columnGroup)).equals((Object)Grid.this.getColumnGroup(i))) {
                            Rectangle toggle = ((DefaultColumnGroupHeaderRenderer)columnGroup.getHeaderRenderer()).getToggleBounds();
                            e.childID = toggle.contains(location.x, location.y) ? itemCount + Grid.this.getColumns().length + Grid.this.getColumnGroups().length + i : itemCount + Grid.this.getColumns().length + i;
                            return;
                        }
                        ++i;
                    }
                }
            }

            public void getChildCount(AccessibleControlEvent e) {
                if (e.childID == -1) {
                    int length = Grid.this.items.size();
                    if (Grid.this.isTree) {
                        for (GridItem item : Grid.this.items) {
                            if (item.getParentItem() == null) continue;
                            --length;
                        }
                    }
                    e.detail = length;
                }
            }

            public void getChildren(AccessibleControlEvent e) {
                if (e.childID == -1) {
                    int length = Grid.this.items.size();
                    if (Grid.this.isTree) {
                        for (GridItem item : Grid.this.items) {
                            if (item.getParentItem() == null) continue;
                            --length;
                        }
                        Object[] children = new Object[length];
                        int j = 0;
                        int i = 0;
                        while (i < Grid.this.items.size()) {
                            if (Grid.this.items.get(i).getParentItem() == null) {
                                children[j] = i;
                                ++j;
                            }
                            ++i;
                        }
                        e.children = children;
                    } else {
                        Object[] children = new Object[length];
                        int i = 0;
                        while (i < Grid.this.items.size()) {
                            children[i] = i;
                            ++i;
                        }
                        e.children = children;
                    }
                }
            }

            public void getDefaultAction(AccessibleControlEvent e) {
                int childID = e.childID;
                if (childID >= 0 && childID < Grid.this.items.size()) {
                    e.result = Grid.this.getItem(childID).hasChildren() ? (Grid.this.getItem(childID).isExpanded() ? Grid.ACC_ITEM_ACTION_COLLAPSE : Grid.ACC_ITEM_ACTION_EXPAND) : Grid.ACC_ITEM_DEFAULT_ACTION;
                } else if (childID >= Grid.this.items.size() && childID < Grid.this.items.size() + Grid.this.columns.size() + Grid.this.columnGroups.length) {
                    e.result = Grid.ACC_COLUMN_DEFAULT_ACTION;
                } else if (childID >= Grid.this.items.size() + Grid.this.columns.size() + Grid.this.columnGroups.length && childID < Grid.this.items.size() + Grid.this.columns.size() + Grid.this.columnGroups.length + Grid.this.columnGroups.length) {
                    e.result = SWT.getMessage((String)"SWT_Press");
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = Grid.this.getBounds();
                location.x = 0;
                location.y = 0;
                int childID = e.childID;
                if (childID >= 0 && childID < Grid.this.items.size()) {
                    GridItem item = Grid.this.getItem(childID);
                    if (item != null) {
                        Point p = Grid.this.getOrigin(Grid.this.columns.get(0), item);
                        location.y = p.y;
                        location.height = item.getHeight();
                    }
                } else if (childID >= Grid.this.items.size() && childID < Grid.this.items.size() + Grid.this.columns.size()) {
                    GridColumn column = Grid.this.getColumn(childID - Grid.this.items.size());
                    if (column != null) {
                        location.x = Grid.this.getColumnHeaderXPosition(column);
                        location.y = column.getColumnGroup() == null ? 0 : Grid.this.groupHeaderHeight;
                        location.height = Grid.this.headerHeight;
                        location.width = column.getWidth();
                    }
                } else if (childID >= Grid.this.items.size() + Grid.this.columns.size() && childID < Grid.this.items.size() + Grid.this.columns.size() + Grid.this.columnGroups.length) {
                    columnGroup = Grid.this.getColumnGroup(childID - Grid.this.items.size() - Grid.this.columns.size());
                    if (columnGroup != null) {
                        location.y = 0;
                        location.height = Grid.this.groupHeaderHeight;
                        location.x = Grid.this.getColumnHeaderXPosition(columnGroup.getFirstVisibleColumn());
                        int width = 0;
                        int i = 0;
                        while (i < columnGroup.getColumns().length) {
                            if (columnGroup.getColumns()[i].isVisible()) {
                                width += columnGroup.getColumns()[i].getWidth();
                            }
                            ++i;
                        }
                        location.width = width;
                    }
                } else if (childID >= Grid.this.items.size() + Grid.this.columns.size() + Grid.this.columnGroups.length && childID < Grid.this.items.size() + Grid.this.columns.size() + Grid.this.columnGroups.length + Grid.this.columnGroups.length) {
                    columnGroup = Grid.this.getColumnGroup(childID - Grid.this.items.size() - Grid.this.columns.size() - Grid.this.columnGroups.length);
                    location = ((DefaultColumnGroupHeaderRenderer)columnGroup.getHeaderRenderer()).getToggleBounds();
                }
                if (location != null) {
                    Point pt = Grid.this.toDisplay(location.x, location.y);
                    e.x = pt.x;
                    e.y = pt.y;
                    e.width = location.width;
                    e.height = location.height;
                }
            }

            public void getRole(AccessibleControlEvent e) {
                int childID = e.childID;
                if (childID >= 0 && childID < Grid.this.items.size()) {
                    e.detail = Grid.this.isTree ? 36 : 34;
                } else if (childID >= Grid.this.items.size() && childID < Grid.this.items.size() + Grid.this.columns.size() + Grid.this.columnGroups.length) {
                    e.detail = 25;
                } else if (childID >= Grid.this.items.size() + Grid.this.columns.size() + Grid.this.columnGroups.length && childID < Grid.this.items.size() + Grid.this.columns.size() + Grid.this.columnGroups.length + Grid.this.columnGroups.length) {
                    e.detail = 43;
                } else if (childID == -1) {
                    e.detail = Grid.this.isTree ? 35 : 24;
                }
            }

            public void getSelection(AccessibleControlEvent e) {
                e.childID = -2;
                if (Grid.this.selectedItems.size() == 1) {
                    e.childID = Grid.this.selectedItems.get(0).getRowIndex();
                } else if (Grid.this.selectedItems.size() > 1) {
                    e.childID = -3;
                    int length = Grid.this.selectedItems.size();
                    Object[] children = new Object[length];
                    int i = 0;
                    while (i < length) {
                        GridItem item = Grid.this.selectedItems.get(i);
                        children[i] = item.getRowIndex();
                        ++i;
                    }
                    e.children = children;
                }
            }

            public void getState(AccessibleControlEvent e) {
                int childID = e.childID;
                if (childID >= 0 && childID < Grid.this.items.size()) {
                    e.detail = 0x200000;
                    if (Grid.this.getDisplay().getActiveShell() == Grid.this.getParent().getShell()) {
                        e.detail |= 0x100000;
                    }
                    if (Grid.this.selectedItems.contains((Object)Grid.this.getItem(childID))) {
                        e.detail |= 2;
                        if (Grid.this.getDisplay().getActiveShell() == Grid.this.getParent().getShell()) {
                            e.detail |= 4;
                        }
                    }
                    if (Grid.this.getItem(childID).getChecked()) {
                        e.detail |= 0x10;
                    }
                    if (Grid.this.getItem(childID).hasChildren()) {
                        e.detail = Grid.this.getItem(childID).isExpanded() ? (e.detail |= 0x200) : (e.detail |= 0x400);
                    }
                    if (!Grid.this.getItem(childID).isVisible()) {
                        e.detail |= 0x8000;
                    }
                } else if (childID >= Grid.this.items.size() && childID < Grid.this.items.size() + Grid.this.columns.size() + Grid.this.columnGroups.length) {
                    e.detail = 64;
                } else if (childID >= Grid.this.items.size() + Grid.this.columns.size() + Grid.this.columnGroups.length && childID < Grid.this.items.size() + Grid.this.columns.size() + Grid.this.columnGroups.length + Grid.this.columnGroups.length) {
                    e.detail = Grid.this.getColumnGroup(childID - Grid.this.items.size() - Grid.this.columns.size() - Grid.this.columnGroups.length).getExpanded() ? 512 : 1024;
                }
            }

            public void getValue(AccessibleControlEvent e) {
                int childID = e.childID;
                if (childID >= 0 && childID < Grid.this.items.size() && Grid.this.isTree) {
                    e.result = "" + Grid.this.getItem(childID).getLevel();
                }
            }
        });
        this.addListener(13, event -> {
            if (this.selectedItems.size() > 0) {
                accessible.setFocus(this.selectedItems.get(this.selectedItems.size() - 1).getRowIndex());
            }
        });
        this.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                if (Grid.this.getFocusItem() != null) {
                    accessible.setFocus(Grid.this.getFocusItem().getRowIndex());
                }
            }

            public void treeExpanded(TreeEvent e) {
                if (Grid.this.getFocusItem() != null) {
                    accessible.setFocus(Grid.this.getFocusItem().getRowIndex());
                }
            }
        });
    }

    boolean isDisposing() {
        return this.disposing;
    }

    void setHasSpanning(boolean hasSpanning) {
        this.hasSpanning = hasSpanning;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    void imageSetOnItem(int column, GridItem item) {
        if (this.sizeOnEveryItemImageChange) {
            if (item == null || item.getImage(column) == null) {
                return;
            }
            int height = item.getImage((int)column).getBounds().height;
            if (height + 20 > this.itemHeight) {
                height = this.computeItemHeight(item);
                this.setItemHeight(height);
            }
        } else {
            if (this.firstImageSet || this.userModifiedItemHeight) {
                return;
            }
            int height = this.computeItemHeight(item);
            this.setItemHeight(height);
            this.firstImageSet = true;
        }
    }

    private boolean handleHoverOnSelectionDragArea(int x, int y) {
        boolean over = false;
        if (!(this.rowHeaderVisible && x <= this.rowHeaderWidth - 2 || this.columnHeadersVisible && y <= this.headerHeight - 2)) {
            if (this.cellSelectionEnabled) {
                Point p = new Point(x, y);
                Point cell = this.getCell(p);
                over = cell != null && this.isCellSelected(cell);
            } else {
                Point p = new Point(x, y);
                GridItem item = this.getItem(p);
                boolean bl = over = item != null && this.isSelected(item);
            }
        }
        if (over != this.hoveringOnSelectionDragArea) {
            this.hoveringOnSelectionDragArea = over;
        }
        return over;
    }

    void setInsertMark(GridItem item, GridColumn column, boolean before) {
        this.checkWidget();
        if (item != null && item.isDisposed()) {
            SWT.error((int)5);
        }
        if (column != null && column.isDisposed()) {
            SWT.error((int)5);
        }
        this.insertMarkItem = item;
        this.insertMarkColumn = column;
        this.insertMarkBefore = before;
        this.redraw();
    }

    boolean isInDragScrollArea(Point point) {
        int rhw = this.rowHeaderVisible ? this.rowHeaderWidth : 0;
        int chh = this.columnHeadersVisible ? this.headerHeight : 0;
        Rectangle top = new Rectangle(rhw, chh, this.getClientArea().width - rhw, 12);
        Rectangle bottom = new Rectangle(rhw, this.getClientArea().height - 12, this.getClientArea().width - rhw, 12);
        return top.contains(point) || bottom.contains(point);
    }

    public void clear(int index, boolean allChildren) {
        this.checkWidget();
        if (index < 0 || index >= this.items.size()) {
            SWT.error((int)6);
        }
        GridItem item = this.getItem(index);
        item.clear(allChildren);
        this.redraw();
    }

    public void clear(int start, int end, boolean allChildren) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = this.items.size();
        if (start < 0 || start > end || end >= count) {
            SWT.error((int)6);
        }
        int i = start;
        while (i <= end) {
            GridItem item = this.items.get(i);
            item.clear(allChildren);
            ++i;
        }
        this.redraw();
    }

    public void clear(int[] indices, boolean allChildren) {
        this.checkWidget();
        if (indices == null) {
            SWT.error((int)4);
        }
        if (indices.length == 0) {
            return;
        }
        int count = this.items.size();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (index < 0 || index >= count) {
                SWT.error((int)6);
            }
            ++n2;
        }
        nArray = indices;
        n = indices.length;
        n2 = 0;
        while (n2 < n) {
            int indice = nArray[n2];
            GridItem item = this.items.get(indice);
            item.clear(allChildren);
            ++n2;
        }
        this.redraw();
    }

    public void clearAll(boolean allChildren) {
        this.checkWidget();
        if (this.items.size() > 0) {
            this.clear(0, this.items.size() - 1, allChildren);
        }
    }

    public void recalculateHeader() {
        int previous = this.getHeaderHeight();
        this.computeHeaderHeight();
        if (previous != this.getHeaderHeight()) {
            this.scrollValuesObsolete = true;
            this.redraw();
        }
    }

    public GridVisibleRange getVisibleRange() {
        int topIndex = this.getTopIndex();
        int bottomIndex = this.getBottomIndex();
        int startColumnIndex = this.getStartColumnIndex();
        int endColumnIndex = this.getEndColumnIndex();
        GridVisibleRange range = new GridVisibleRange();
        range.items = new GridItem[0];
        range.columns = new GridColumn[0];
        if (topIndex <= bottomIndex && this.items.size() > 0) {
            range.items = new GridItem[bottomIndex - topIndex + 1];
            int i = topIndex;
            while (i <= bottomIndex) {
                range.items[i - topIndex] = this.items.get(i);
                ++i;
            }
        }
        if (startColumnIndex <= endColumnIndex && this.displayOrderedColumns.size() > 0) {
            ArrayList<GridColumn> cols = new ArrayList<GridColumn>();
            int i = startColumnIndex;
            while (i <= endColumnIndex) {
                GridColumn col = this.displayOrderedColumns.get(i);
                if (col.isVisible()) {
                    cols.add(col);
                }
                ++i;
            }
            range.columns = new GridColumn[cols.size()];
            cols.toArray(range.columns);
        }
        return range;
    }

    int getStartColumnIndex() {
        this.checkWidget();
        if (this.startColumnIndex != -1) {
            return this.startColumnIndex;
        }
        if (!this.hScroll.getVisible()) {
            this.startColumnIndex = 0;
        }
        this.startColumnIndex = this.hScroll.getSelection();
        return this.startColumnIndex;
    }

    int getEndColumnIndex() {
        this.checkWidget();
        if (this.endColumnIndex != -1) {
            return this.endColumnIndex;
        }
        if (this.displayOrderedColumns.size() == 0) {
            this.endColumnIndex = 0;
        } else if (this.getVisibleGridWidth() < 1) {
            this.endColumnIndex = this.getStartColumnIndex();
        } else {
            int x = 0;
            x -= this.getHScrollSelectionInPixels();
            if (this.rowHeaderVisible) {
                x += this.rowHeaderWidth;
            }
            int startIndex = this.getStartColumnIndex();
            GridColumn[] columns = new GridColumn[this.displayOrderedColumns.size()];
            this.displayOrderedColumns.toArray(columns);
            int i = startIndex;
            while (i < columns.length) {
                this.endColumnIndex = i;
                GridColumn column = columns[i];
                if (column.isVisible()) {
                    x += column.getWidth();
                }
                if (x > this.getClientArea().width) break;
                ++i;
            }
        }
        this.endColumnIndex = Math.max(0, this.endColumnIndex);
        return this.endColumnIndex;
    }

    void setSizeOnEveryItemImageChange(boolean sizeOnEveryItemImageChange) {
        this.sizeOnEveryItemImageChange = sizeOnEveryItemImageChange;
    }

    public int getRowHeaderWidth() {
        this.checkWidget();
        return this.rowHeaderWidth;
    }

    public void setAutoHeight(boolean enabled) {
        if (this.autoHeight == enabled) {
            return;
        }
        this.checkWidget();
        this.autoHeight = enabled;
        this.setRowsResizeable(false);
        this.redraw();
    }

    public boolean isAutoHeight() {
        return this.autoHeight;
    }

    public void setAutoWidth(boolean enabled) {
        if (this.autoWidth == enabled) {
            return;
        }
        this.checkWidget();
        this.autoWidth = enabled;
        this.redraw();
    }

    public boolean isAutoWidth() {
        return this.autoWidth;
    }

    public void setWordWrapHeader(boolean enabled) {
        if (this.wordWrapRowHeader == enabled) {
            return;
        }
        this.checkWidget();
        this.wordWrapRowHeader = enabled;
        this.redraw();
    }

    public void setForeground(Color color) {
        this.dataVisualizer.setDefaultForeground(color);
        super.setForeground(color);
    }

    public boolean isWordWrapHeader() {
        return this.wordWrapRowHeader;
    }

    public void refreshData() {
        if ((this.getStyle() & 0x10000000) != 0) {
            for (GridItem item : this.items) {
                item.setHasSetData(false);
            }
        }
    }

    public boolean isMoveOnTab() {
        this.checkWidget();
        return this.moveOnTab;
    }

    public void setMoveOnTab(boolean moveOnTab) {
        this.checkWidget();
        this.moveOnTab = moveOnTab;
    }

    private void computeRowHeaderWidth(int minWidth) {
        this.estimate(sizingGC -> {
            int width = this.items.stream().mapToInt(item -> this.rowHeaderRenderer.computeSize((GC)gC, (int)-1, (int)-1, (Object)((Object)((Object)((Object)item)))).x).max().orElse(minWidth);
            this.rowHeaderWidth = width > minWidth ? width : minWidth;
        });
    }

    private int estimateWithResult(ToIntFunction<GC> function) {
        GC gc = new GC((Drawable)this);
        try {
            int n = function.applyAsInt(gc);
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    private void estimate(Consumer<GC> consumer) {
        this.estimateWithResult(gc -> {
            consumer.accept((GC)gc);
            return 0;
        });
    }

    public boolean isFocusOnGrid() {
        this.checkWidget();
        return this.getDisplay().getFocusControl() == this;
    }

    public void setSelectionType(GridSelectionType selectionType) {
        this.checkWidget();
        this.selectionType = selectionType;
    }

    public void addMouseListener(MouseListener sourceListener) {
        this.checkWidget();
        if (sourceListener == null) {
            SWT.error((int)4);
        }
        this.addListener(4, e -> sourceListener.mouseUp(new MouseEvent(e)));
        this.addListener(3, e -> sourceListener.mouseDown(new MouseEvent(e)));
        this.addListener(8, e -> {
            if (e.doit) {
                sourceListener.mouseDoubleClick(new MouseEvent(e));
            }
        });
    }

    public void addListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        if (eventType == 8) {
            super.addListener(8, e -> {
                if (e.doit) {
                    listener.handleEvent(e);
                }
            });
        } else {
            super.addListener(eventType, listener);
        }
    }

    public static class GridVisibleRange {
        private GridItem[] items = new GridItem[0];
        private GridColumn[] columns = new GridColumn[0];

        public GridItem[] getItems() {
            return this.items;
        }

        public GridColumn[] getColumns() {
            return this.columns;
        }
    }

    private static class RowRange {
        public int startIndex;
        public int endIndex;
        public int rows;
        public int height;

        private RowRange() {
        }
    }
}

