/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.gef.policies.ModifiedMoveHandle;
import org.eclipse.fordiac.ide.gef.policies.ModifiedNonResizeableEditPolicy;
import org.eclipse.fordiac.ide.gef.utilities.RequestUtil;
import org.eclipse.fordiac.ide.model.commands.change.SetPositionCommand;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.typelibrary.DeviceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SegmentTypeEntry;
import org.eclipse.fordiac.ide.systemconfiguration.commands.DeviceCreateCommand;
import org.eclipse.fordiac.ide.systemconfiguration.commands.SegmentCreateCommand;
import org.eclipse.fordiac.ide.systemconfiguration.commands.SegmentSetConstraintCommand;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.handles.ResizeHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class SystemConfXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child.getModel() instanceof Segment) {
            return new ResizableEditPolicy(){

                protected List createSelectionHandles() {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(new ResizeHandle(this.getHost(), 16));
                    list.add(new ResizeHandle(this.getHost(), 8));
                    list.add(new ModifiedMoveHandle(this.getHost(), new Insets(0, 2, 0, 2), 20));
                    return list;
                }
            };
        }
        return new ModifiedNonResizeableEditPolicy();
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        if (constraint instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)constraint;
            Rectangle rec = new Rectangle(rectangle);
            Object object = child.getModel();
            if (object instanceof Segment) {
                Segment segment = (Segment)object;
                return new SegmentSetConstraintCommand(segment, rec, request);
            }
            Object object2 = child.getModel();
            if (object2 instanceof PositionableElement) {
                PositionableElement posel = (PositionableElement)object2;
                if (RequestUtil.isMoveRequest((Request)request)) {
                    Point moveDelta = request.getMoveDelta().getScaled(1.0 / this.getZoomManager().getZoom());
                    return new SetPositionCommand(posel, moveDelta.x, moveDelta.y);
                }
            }
        }
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Object object;
        DeviceTypeEntry type;
        if (request == null) {
            return null;
        }
        Object childClass = request.getNewObjectType();
        Rectangle constraint = (Rectangle)this.getConstraintFor(request);
        if (childClass instanceof DeviceTypeEntry) {
            type = (DeviceTypeEntry)request.getNewObjectType();
            object = this.getHost().getModel();
            if (object instanceof SystemConfiguration) {
                SystemConfiguration sysConf = (SystemConfiguration)object;
                return new DeviceCreateCommand(type, sysConf, new Rectangle(constraint.getLocation().x, constraint.getLocation().y, -1, -1));
            }
        }
        if (childClass instanceof SegmentTypeEntry) {
            type = (SegmentTypeEntry)request.getNewObjectType();
            object = this.getHost().getModel();
            if (object instanceof SystemConfiguration) {
                SystemConfiguration sysConf = (SystemConfiguration)object;
                return new SegmentCreateCommand((SegmentTypeEntry)type, sysConf, constraint);
            }
        }
        return null;
    }

    protected Command getAddCommand(Request generic) {
        return null;
    }

    protected ZoomManager getZoomManager() {
        return ((ScalableFreeformRootEditPart)this.getHost().getRoot()).getZoomManager();
    }
}

