/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.change.AbstractChangeAttributeCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;

public class ChangeAttributeTypeCommand
extends AbstractChangeAttributeCommand {
    private final DataType dataType;
    private DataType oldDataType;

    private ChangeAttributeTypeCommand(Attribute attribute, DataType dataType) {
        super(attribute);
        this.dataType = dataType;
    }

    public static ChangeAttributeTypeCommand forTypeName(Attribute attribute, String typeName) {
        TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibraryFromContext((EObject)attribute);
        DataType dataType = (DataType)ImportHelper.resolveImport((String)typeName, (EObject)attribute, arg_0 -> ((DataTypeLibrary)typeLibrary.getDataTypeLibrary()).getTypeIfExists(arg_0), arg_0 -> ((DataTypeLibrary)typeLibrary.getDataTypeLibrary()).getType(arg_0));
        return ChangeAttributeTypeCommand.forDataType(attribute, dataType);
    }

    public static ChangeAttributeTypeCommand forDataType(Attribute attribute, DataType dataType) {
        return new ChangeAttributeTypeCommand(attribute, (DataType)Objects.requireNonNullElse(dataType, IecTypes.ElementaryTypes.STRING));
    }

    public boolean canExecute() {
        return super.canExecute() && this.getAttribute().getAttributeDeclaration() == null;
    }

    @Override
    public void doExecute() {
        this.oldDataType = this.getAttribute().getType();
        this.getAttribute().setType(this.dataType);
    }

    @Override
    public void doUndo() {
        this.getAttribute().setType(this.oldDataType);
    }

    @Override
    public void doRedo() {
        this.getAttribute().setType(this.dataType);
    }
}

