/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.iec61499.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.deployment.DeploymentCoordinator;
import org.eclipse.fordiac.ide.deployment.data.DeviceDeploymentData;
import org.eclipse.fordiac.ide.deployment.data.ResourceDeploymentData;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.iec61499.executors.DynamicTypeLoadDeploymentExecutor;
import org.eclipse.fordiac.ide.deployment.interactors.DeviceManagementInteractorFactory;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.typelibrary.DeviceTypeEntry;
import org.eclipse.fordiac.ide.systemconfiguration.commands.DeviceCreateCommand;
import org.eclipse.fordiac.ide.systemconfiguration.commands.DeviceDeleteCommand;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareDeviceHandler
extends AbstractHandler {
    private DeviceDeploymentData differenceDataDeltaPlus;
    private DeviceDeploymentData differenceDataDeltaMinus;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Device selectedDevice;
        Device onlineDevice;
        if (CompareDeviceHandler.getSelectedDevice(event) != null && (onlineDevice = CompareDeviceHandler.fillDeviceDataFromForte(CompareDeviceHandler.createDeviceForComparison(selectedDevice = CompareDeviceHandler.getSelectedDevice(event)))) != null) {
            DeviceDeleteCommand deleteDeviceCmd;
            onlineDevice.getResource().remove(0);
            if (!onlineDevice.getResource().isEmpty()) {
                try {
                    this.compareDevices(selectedDevice, onlineDevice);
                    this.printDiffInConsole();
                }
                catch (DeploymentException e) {
                    e.printStackTrace();
                }
            }
            if ((deleteDeviceCmd = new DeviceDeleteCommand(onlineDevice)).canExecute()) {
                deleteDeviceCmd.execute();
            }
        }
        return null;
    }

    private void compareDevices(Device offlineDevice, Device onlineDevice) throws DeploymentException {
        DeviceDeploymentData offlineDeviceData = (DeviceDeploymentData)DeploymentCoordinator.createDeploymentdata((Object[])offlineDevice.getResource().toArray()).get(0);
        DeviceDeploymentData onlineDeviceData = (DeviceDeploymentData)DeploymentCoordinator.createDeploymentdata((Object[])onlineDevice.getResource().toArray()).get(0);
        this.differenceDataDeltaPlus = new DeviceDeploymentData(offlineDevice);
        this.differenceDataDeltaMinus = new DeviceDeploymentData(offlineDevice);
        for (ResourceDeploymentData resOfflineData : offlineDeviceData.getResData()) {
            for (ResourceDeploymentData resOnlineData : onlineDeviceData.getResData()) {
                if (resOnlineData.getRes().getName().equals(resOfflineData.getRes().getName())) {
                    ResourceDeploymentData resourceDeltaPlus = new ResourceDeploymentData(resOfflineData.getRes());
                    resourceDeltaPlus.getFbs().clear();
                    resourceDeltaPlus.getConnections().clear();
                    resourceDeltaPlus.getParams().clear();
                    this.differenceDataDeltaPlus.addResourceData(resourceDeltaPlus);
                    ResourceDeploymentData resourceDeltaMinus = new ResourceDeploymentData(resOfflineData.getRes());
                    resourceDeltaMinus.getFbs().clear();
                    resourceDeltaMinus.getConnections().clear();
                    resourceDeltaMinus.getParams().clear();
                    this.differenceDataDeltaMinus.addResourceData(resourceDeltaMinus);
                    this.compareFBs(resOnlineData, resOfflineData);
                    this.compareConnections(resOnlineData, resOfflineData);
                    this.compareParameters(resOnlineData, resOfflineData);
                    continue;
                }
                FordiacLogHelper.logInfo((String)("No Resource: " + resOfflineData.getRes().getName() + " not found online to compare!"));
            }
        }
    }

    private void compareFBs(ResourceDeploymentData offlineResource, ResourceDeploymentData onlineResource) {
        onlineResource.getFbs().forEach(onlineFB -> {
            if (offlineResource.getFbs().stream().noneMatch(offlineFB -> offlineFB.getFb().getName().equals(onlineFB.getFb().getName()) && offlineFB.getPrefix().equals(onlineFB.getPrefix()) && offlineFB.getFb().getType().equals(onlineFB.getFb().getType()))) {
                ((ResourceDeploymentData)this.differenceDataDeltaPlus.getResData().get(this.differenceDataDeltaPlus.getResData().size() - 1)).addFbs(onlineFB);
            }
        });
        offlineResource.getFbs().forEach(offlineFB -> {
            if (onlineResource.getFbs().stream().noneMatch(onlineFB -> onlineFB.getFb().getName().equals(offlineFB.getFb().getName()) && onlineFB.getPrefix().equals(offlineFB.getPrefix()) && onlineFB.getFb().getType().equals(offlineFB.getFb().getType()))) {
                ((ResourceDeploymentData)this.differenceDataDeltaMinus.getResData().get(this.differenceDataDeltaMinus.getResData().size() - 1)).addFbs(offlineFB);
            }
        });
    }

    private void compareConnections(ResourceDeploymentData offlineResource, ResourceDeploymentData onlineResource) {
        onlineResource.getConnections().forEach(onlineCon -> {
            if (offlineResource.getConnections().stream().noneMatch(offlineCon -> offlineCon.destination().getName().equals(onlineCon.destination().getName()) && offlineCon.destinationPrefix().equals(onlineCon.destinationPrefix()) && offlineCon.source().getName().equals(onlineCon.source().getName()) && offlineCon.sourcePrefix().equals(onlineCon.sourcePrefix()))) {
                ((ResourceDeploymentData)this.differenceDataDeltaPlus.getResData().get(this.differenceDataDeltaPlus.getResData().size() - 1)).addConnections(onlineCon);
            }
        });
        offlineResource.getConnections().forEach(offlineCon -> {
            if (onlineResource.getConnections().stream().noneMatch(onlineCon -> onlineCon.destination().getName().equals(offlineCon.destination().getName()) && onlineCon.destinationPrefix().equals(offlineCon.destinationPrefix()) && onlineCon.source().getName().equals(offlineCon.source().getName()) && onlineCon.sourcePrefix().equals(offlineCon.sourcePrefix()))) {
                ((ResourceDeploymentData)this.differenceDataDeltaMinus.getResData().get(this.differenceDataDeltaMinus.getResData().size() - 1)).addConnections(offlineCon);
            }
        });
    }

    private void compareParameters(ResourceDeploymentData offlineResource, ResourceDeploymentData onlineResource) {
        onlineResource.getParams().forEach(onlineParam -> {
            if (offlineResource.getParams().stream().noneMatch(offlineParam -> offlineParam.variable().equals(onlineParam.variable()) && offlineParam.prefix().equals(onlineParam.prefix()))) {
                ((ResourceDeploymentData)this.differenceDataDeltaPlus.getResData().get(this.differenceDataDeltaPlus.getResData().size() - 1)).addParameter(onlineParam);
            }
        });
        offlineResource.getParams().forEach(offlineParam -> {
            if (onlineResource.getParams().stream().noneMatch(onlineParam -> onlineParam.variable().equals(offlineParam.variable()) && onlineParam.prefix().equals(offlineParam.prefix()))) {
                ((ResourceDeploymentData)this.differenceDataDeltaMinus.getResData().get(this.differenceDataDeltaMinus.getResData().size() - 1)).addParameter(offlineParam);
            }
        });
    }

    private static Device getSelectedDevice(ExecutionEvent event) {
        StructuredSelection structuredSelection;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection && !(structuredSelection = (StructuredSelection)selection).toList().isEmpty() && ((StructuredSelection)selection).toList().size() == 1) {
            if (((StructuredSelection)selection).toList().get(0) instanceof EditPart) {
                return (Device)((EditPart)((StructuredSelection)selection).toList().get(0)).getModel();
            }
            if (((StructuredSelection)selection).toList() instanceof Device) {
                return (Device)((StructuredSelection)selection).toList().get(0);
            }
        }
        return null;
    }

    private static Device createDeviceForComparison(Device selectedDevice) {
        DeviceCreateCommand createDeviceCmd = new DeviceCreateCommand((DeviceTypeEntry)selectedDevice.getTypeEntry(), selectedDevice.getSystemConfiguration(), new Rectangle(1, 1, 1, 1));
        if (createDeviceCmd.canExecute()) {
            createDeviceCmd.execute();
            Device newDevice = createDeviceCmd.getDevice();
            newDevice.setProfile("DynamicTypeLoad");
            return newDevice;
        }
        return null;
    }

    private static Device fillDeviceDataFromForte(Device onlineDevice) {
        IDeviceManagementInteractor interactor = DeviceManagementInteractorFactory.INSTANCE.getDeviceManagementInteractor(onlineDevice);
        if (interactor instanceof DynamicTypeLoadDeploymentExecutor) {
            DynamicTypeLoadDeploymentExecutor dynamicTypeLoadInteractor = (DynamicTypeLoadDeploymentExecutor)interactor;
            try {
                try {
                    interactor.connect();
                    dynamicTypeLoadInteractor.queryResourcesWithNetwork(onlineDevice);
                }
                catch (Exception e) {
                    FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                    try {
                        interactor.disconnect();
                    }
                    catch (DeploymentException e2) {
                        FordiacLogHelper.logError((String)e2.getMessage(), (Throwable)e2);
                    }
                }
            }
            finally {
                try {
                    interactor.disconnect();
                }
                catch (DeploymentException e) {
                    FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                }
            }
        }
        return onlineDevice;
    }

    private void printDiffInConsole() {
        this.differenceDataDeltaPlus.getResData().forEach(res -> {
            FordiacLogHelper.logInfo((String)("== Resource: " + res.getRes().getName() + " (online)"));
            res.getFbs().forEach(fb -> FordiacLogHelper.logInfo((String)("++ fb: " + fb.getPrefix() + fb.getFb().getName())));
            res.getConnections().forEach(con -> FordiacLogHelper.logInfo((String)("++ con: " + con.sourcePrefix() + con.source().getName() + " -> " + con.destinationPrefix() + con.destination().getName())));
            res.getParams().forEach(con -> FordiacLogHelper.logInfo((String)("++ param: " + con.prefix() + con.variable().getName())));
        });
        this.differenceDataDeltaMinus.getResData().forEach(res -> {
            FordiacLogHelper.logInfo((String)("== Resource: " + res.getRes().getName() + "(local)"));
            res.getFbs().forEach(fb -> FordiacLogHelper.logInfo((String)("-- fb: " + fb.getPrefix() + fb.getFb().getName())));
            res.getConnections().forEach(con -> FordiacLogHelper.logInfo((String)("-- con: " + con.sourcePrefix() + con.source().getName() + " -> " + con.destinationPrefix() + con.destination().getName())));
            res.getParams().forEach(con -> FordiacLogHelper.logInfo((String)("-- param: " + con.prefix() + con.variable().getName())));
        });
    }
}

