/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.wizards;

import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.model.IdentifierVerifier;
import org.eclipse.fordiac.ide.model.buildpath.Buildpath;
import org.eclipse.fordiac.ide.model.buildpath.util.BuildpathUtil;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.ui.widgets.PackageSelectionProposalProvider;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

public class SaveAsWizardPage
extends WizardNewFileCreationPage {
    private static final String STORE_OPEN_TYPE_ID = "SUBAPP_SECTION.STORE_OPEN_TYPE_ID";
    private static final String STORE_REPLACE_SOURCE_ID = "SUBAPP_SECTION.STORE_REPLACE_SOURCE_ID";
    private boolean openType = true;
    private Composite advancedComposite;
    private int advancedCompositeHeight = -1;
    private Button replaceSourceSubapp;
    private final String fileLabel;
    private final String checkBoxText;
    private final String replaceSourceText;

    private SaveAsWizardPage(String pageName, IStructuredSelection selection, String title, String description, String fileLabel, String checkBoxText, String replaceSourceText) {
        super(pageName, selection);
        this.setTitle(title);
        this.setDescription(description);
        this.setAllowExistingResources(true);
        this.fileLabel = fileLabel;
        this.checkBoxText = checkBoxText;
        this.replaceSourceText = replaceSourceText;
    }

    public boolean getOpenType() {
        return this.openType;
    }

    public String getPackageName() {
        return "";
    }

    public boolean getReplaceSource() {
        return this.replaceSourceSubapp.getSelection();
    }

    protected String getNewFileLabel() {
        return this.fileLabel;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.restoreWidgetValues();
    }

    protected IContainer getSelectedContainer() {
        IPath containerFullPath = this.getContainerFullPath();
        if (containerFullPath != null && containerFullPath.segmentCount() > 0) {
            return containerFullPath.segmentCount() == 1 ? ResourcesPlugin.getWorkspace().getRoot().getProject(containerFullPath.segment(0)) : ResourcesPlugin.getWorkspace().getRoot().getFolder(containerFullPath);
        }
        return null;
    }

    protected TypeLibrary getTypeLibrary() {
        IContainer container = this.getSelectedContainer();
        if (container != null) {
            return TypeLibraryManager.INSTANCE.getTypeLibrary(container.getProject());
        }
        return null;
    }

    protected void createAdvancedControls(Composite parent) {
        if (this.replaceSourceText != null) {
            this.createReplaceSourceEntry(parent);
        }
        super.createAdvancedControls(parent);
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_OPEN_TYPE_ID, this.openType);
            settings.put(STORE_REPLACE_SOURCE_ID, this.replaceSourceSubapp.getSelection());
        }
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.openType = settings.getBoolean(STORE_OPEN_TYPE_ID);
            this.replaceSourceSubapp.setSelection(settings.getBoolean(STORE_REPLACE_SOURCE_ID));
        }
    }

    protected boolean validatePage() {
        Optional errorMessage = IdentifierVerifier.verifyIdentifier((String)super.getFileName());
        if (errorMessage.isPresent()) {
            this.setErrorMessage((String)errorMessage.get());
            return false;
        }
        return super.validatePage();
    }

    protected void handleAdvancedButtonSelect() {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        Composite composite = (Composite)this.getControl();
        if (this.advancedComposite != null) {
            this.advancedComposite.dispose();
            this.advancedComposite = null;
            shell.setSize(shellSize.x, shellSize.y - this.advancedCompositeHeight);
        } else {
            this.advancedComposite = this.createAdvancedGroup(composite);
            if (-1 == this.advancedCompositeHeight) {
                Point groupSize = this.advancedComposite.computeSize(-1, -1, true);
                this.advancedCompositeHeight = groupSize.y;
            }
            shell.setSize(shellSize.x, shellSize.y + this.advancedCompositeHeight);
        }
        super.handleAdvancedButtonSelect();
    }

    private void createReplaceSourceEntry(Composite parent) {
        if (this.replaceSourceText != null) {
            this.replaceSourceSubapp = new Button(parent, 32);
            this.replaceSourceSubapp.setText(this.replaceSourceText);
        }
    }

    private Composite createAdvancedGroup(Composite parent) {
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        Composite groupComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        groupComposite.setLayout((Layout)layout);
        groupComposite.setLayoutData((Object)new GridData(784));
        groupComposite.setFont(font);
        Button openTypeCheckbox = new Button(groupComposite, 32);
        openTypeCheckbox.setText(this.checkBoxText);
        openTypeCheckbox.setSelection(this.openType);
        openTypeCheckbox.addListener(13, ev -> {
            boolean bl = this.openType = openTypeCheckbox.getSelection();
        });
        return groupComposite;
    }

    public static SaveAsWizardPage createSaveAsStructWizardPage(String pageName, IStructuredSelection selection) {
        return new SaveAsWizardPage(pageName, selection, Messages.SaveAsStructWizardPage_WizardPageTitle, Messages.SaveAsStructWizardPage_WizardPageDescription, Messages.SaveAsStructWizardPage_TypeName, Messages.SaveAsSubApplicationTypeAction_WizardPageOpenType, Messages.SaveAsStructWizardPage_ConvertSourceElements);
    }

    public static SaveAsWizardPage createSaveAsSubAppWizardPage(String pageName, IStructuredSelection selection) {
        return new SaveAsSubappWizardPage(pageName, selection, Messages.SaveAsSubApplicationTypeAction_WizardPageTitle, Messages.SaveAsSubApplicationTypeAction_WizardPageDescription, Messages.SaveAsSubApplicationTypeAction_WizardPageNameLabel, Messages.SaveAsSubApplicationTypeAction_WizardPageOpenType, Messages.SaveAsSubappHandler_ReplaceDialogText);
    }

    public static SaveAsWizardPage createSaveAsStructTypeWizardPage(String pageName, IStructuredSelection selection) {
        return new SaveAsWizardPage(pageName, selection, Messages.SaveAsWizardPage_SaveAsStructType_WizardPageTitle, Messages.SaveAsWizardPage_SaveAsStructType_Description, Messages.SaveAsWizardPage_SaveAsStructType_PageName, Messages.SaveAsSubApplicationTypeAction_WizardPageOpenType, null);
    }

    private static class SaveAsSubappWizardPage
    extends SaveAsWizardPage {
        private Text packageNameText;

        public SaveAsSubappWizardPage(String pageName, IStructuredSelection selection, String title, String description, String fileLabel, String checkBoxText, String replaceSourceText) {
            super(pageName, selection, title, description, fileLabel, checkBoxText, replaceSourceText);
        }

        @Override
        public String getPackageName() {
            if (this.packageNameText == null) {
                return super.getPackageName();
            }
            return this.packageNameText.getText();
        }

        private void createPackageNameContainer(Composite parent) {
            Composite packageContainer = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(packageContainer);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)packageContainer);
            Label enterPackageNameLabel = new Label(packageContainer, 0);
            enterPackageNameLabel.setText(Messages.EnterPackageName_Text + ":");
            this.packageNameText = new Text(packageContainer, 2048);
            this.packageNameText.setText(this.getInitialPackageName());
            this.packageNameText.setEnabled(true);
            this.packageNameText.addListener(24, (Listener)this);
            GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, true).hint(250, -1).applyTo((Control)this.packageNameText);
            ContentAssistCommandAdapter packageNameProposalAdapter = new ContentAssistCommandAdapter((Control)this.packageNameText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new PackageSelectionProposalProvider(this::getTypeLibrary), null, null, true);
            packageNameProposalAdapter.setProposalAcceptanceStyle(2);
        }

        private String getInitialPackageName() {
            IContainer container = this.getSelectedContainer();
            if (container != null) {
                TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibrary(container.getProject());
                IPath relativePath = BuildpathUtil.findRelativePath((Buildpath)typeLibrary.getBuildpath(), (IResource)container).orElse(container.getFullPath());
                return Stream.of(relativePath.segments()).collect(Collectors.joining("::"));
            }
            return "";
        }

        @Override
        protected void createAdvancedControls(Composite parent) {
            this.createPackageNameContainer(parent);
            super.createAdvancedControls(parent);
        }

        @Override
        protected boolean validatePage() {
            Optional errorMessage = IdentifierVerifier.verifyPackageName((String)this.getPackageName());
            if (errorMessage.isPresent()) {
                this.setErrorMessage((String)errorMessage.get());
                return false;
            }
            return super.validatePage();
        }
    }
}

