/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.fordiac.ide.application.editparts.InstanceContract;
import org.eclipse.fordiac.ide.gef.figures.BorderedRoundedRectangle;
import org.eclipse.fordiac.ide.gef.figures.RoundedRectangleShadowBorder;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.ui.utils.ContractScanner;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;

public class InstanceContractFigure
extends Figure {
    private static final int PADDING = 4;
    private final FlowPage flowPage;
    private String currentText;
    private final InstanceContract instanceContract;

    public InstanceContractFigure(InstanceContract instanceContract) {
        int top;
        BorderedRoundedRectangle main = new BorderedRoundedRectangle();
        main.setOutline(false);
        main.setCornerDimensions(new Dimension(6, 6));
        main.setBorder((Border)new RoundedRectangleShadowBorder());
        main.setLayoutManager((LayoutManager)new StackLayout());
        this.flowPage = new FlowPage();
        int lineHeight = (int)CoordinateConverter.INSTANCE.getLineHeight();
        int bottom = top = lineHeight / 2;
        if (top + bottom != lineHeight) {
            top += lineHeight - (top + bottom);
        }
        this.flowPage.setBorder((Border)new MarginBorder(top, 4, bottom, 4));
        main.add((IFigure)this.flowPage);
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.add((IFigure)main);
        this.setText(instanceContract.getContract());
        this.instanceContract = instanceContract;
    }

    public void setText(String text) {
        if (text != null && text.equals(this.currentText)) {
            return;
        }
        this.currentText = text;
        Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.fordiac.ide.preferences.diagramFontDefinition");
        this.flowPage.removeAll();
        if (text != null) {
            ContractScanner scan = new ContractScanner(text);
            for (ContractScanner.Token t : scan) {
                TextFlow tf = new TextFlow(t.value());
                switch (t.type()) {
                    case COMMENT: {
                        tf.setForegroundColor(ContractScanner.COMMENT);
                        break;
                    }
                    case KEYWORD: {
                        tf.setForegroundColor(ContractScanner.KEYWORD);
                        tf.setFont(boldFont);
                        break;
                    }
                    default: {
                        tf.setForegroundColor(ContractScanner.NORMAL);
                    }
                }
                this.flowPage.add((IFigure)tf);
            }
        } else {
            this.flowPage.add((IFigure)new TextFlow(""));
        }
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        int w = CoordinateConverter.INSTANCE.iec61499ToScreen(this.instanceContract.getSubApp().getWidth());
        int h = this.flowPage.getPreferredSize((int)w, (int)-1).height;
        return new Dimension(w, h + 8);
    }
}

