/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.insert;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.helpers.ArraySizeHelper;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;

public class InsertVariableCommand
extends Command
implements ScopedCommand {
    private final LibraryElement libraryElement;
    private final VarDeclaration type;
    private VarDeclaration varDecl;
    private final EList<VarDeclaration> list;
    private final int index;

    public InsertVariableCommand(LibraryElement libraryElement, EList<VarDeclaration> list, VarDeclaration type, int index) {
        this.libraryElement = Objects.requireNonNull(libraryElement);
        this.list = Objects.requireNonNull(list);
        this.type = Objects.requireNonNull(type);
        this.index = index;
    }

    public void execute() {
        this.varDecl = LibraryElementFactory.eINSTANCE.createVarDeclaration();
        this.varDecl.setType(this.type.getType());
        this.varDecl.setComment(this.type.getComment());
        ArraySizeHelper.setArraySize((VarDeclaration)this.varDecl, (String)ArraySizeHelper.getArraySize((IInterfaceElement)this.type));
        Value value = LibraryElementFactory.eINSTANCE.createValue();
        Value typeValue = this.type.getValue();
        value.setValue(typeValue == null ? "" : typeValue.getValue());
        this.varDecl.setValue(value);
        this.redo();
        this.varDecl.setName(NameRepository.createUniqueName((INamedElement)this.varDecl, (String)this.type.getName()));
    }

    public void redo() {
        if (this.index > this.list.size()) {
            this.list.add((Object)this.varDecl);
        } else {
            this.list.add(this.index, (Object)this.varDecl);
        }
    }

    public void undo() {
        this.getVariableList().remove((Object)this.varDecl);
    }

    private EList<VarDeclaration> getVariableList() {
        return this.list;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.libraryElement);
    }
}

