/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.variable;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.model.eval.value.FBValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.AbstractVariable;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;

public class FBVariable
extends AbstractVariable<FBValue> {
    private final FBValue value;

    public FBVariable(String name, FBType type) {
        this(name, type, Collections.emptySet());
    }

    public FBVariable(String name, FBType type, String value) {
        this(name, type);
        this.setValue(value);
    }

    public FBVariable(String name, FBType type, Value value) {
        this(name, type);
        this.setValue(value);
    }

    public FBVariable(String name, FBType type, Iterable<Variable<?>> variables) {
        super(name, (LibraryElement)type);
        this.value = new FBValue(type, variables);
    }

    @Override
    public void setValue(Value value) {
        FBValue fbValue;
        if (!(value instanceof FBValue) || (fbValue = (FBValue)value).getType() != this.getType()) {
            throw this.createCastException(value);
        }
        fbValue.getMembers().forEach((name, variable) -> this.value.get((String)name).setValue((Value)variable.getValue()));
    }

    public Map<String, Variable<?>> getMembers() {
        return this.value.getMembers();
    }

    @Override
    public Stream<Variable<?>> getChildren() {
        return this.getMembers().values().stream().sorted(Comparator.comparing(Variable::getName));
    }

    public FBType getType() {
        return (FBType)super.getType();
    }

    @Override
    public FBValue getValue() {
        return this.value;
    }

    protected static IllegalArgumentException createInvalidValueException() {
        return new IllegalArgumentException("Not a valid FB value");
    }
}

