/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.fb;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.EvaluatorFactory;
import org.eclipse.fordiac.ide.model.eval.fb.BaseFBEvaluator;
import org.eclipse.fordiac.ide.model.eval.value.ECStateValue;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.ECStateVariable;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;

public class BasicFBEvaluator
extends BaseFBEvaluator<BasicFBType> {
    private final Map<ECTransition, Evaluator> transitionEvaluators;

    public BasicFBEvaluator(BasicFBType type, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super(type, context, variables, parent);
        this.transitionEvaluators = type.getECC().getECTransition().stream().filter(BasicFBEvaluator::hasConditionExpression).collect(Collectors.toUnmodifiableMap(Function.identity(), this::createECTransitionEvaluator));
    }

    @Override
    public void evaluate(Event event) throws EvaluatorException, InterruptedException {
        ECTransition transition = this.evaluateTransitions(this.getState(), event);
        while (transition != null) {
            this.evaluateState(transition.getDestination());
            transition = this.evaluateTransitions(this.getState(), null);
        }
    }

    private ECTransition evaluateTransitions(ECState state, Event event) throws EvaluatorException, InterruptedException {
        for (ECTransition transition : state.getOutTransitions()) {
            if (!BasicFBEvaluator.matchesConditionEvent(transition, event) || !this.matchesConditionExpression(transition)) continue;
            return transition;
        }
        return null;
    }

    protected static boolean matchesConditionEvent(ECTransition transition, Event event) {
        return transition.getConditionEvent() == null || transition.getConditionEvent() == event;
    }

    protected boolean matchesConditionExpression(ECTransition transition) throws EvaluatorException, InterruptedException {
        return !BasicFBEvaluator.hasConditionExpression(transition) || ValueOperations.asBoolean(this.transitionEvaluators.get(transition).evaluate());
    }

    private void evaluateState(ECState state) throws EvaluatorException, InterruptedException {
        this.setState(state);
        this.trap(state);
        for (ECAction action : state.getECAction()) {
            Event output;
            Algorithm algorithm = action.getAlgorithm();
            if (algorithm != null) {
                this.getAlgorithmEvaluators().get(algorithm).evaluate();
            }
            if ((output = action.getOutput()) != null) {
                this.sendOutputEvent(output);
            }
            this.update(this.getVariables().values());
        }
    }

    public ECState getState() {
        return this.getECStateVariable().getValue().getState();
    }

    public void setState(ECState state) {
        this.getECStateVariable().setValue(new ECStateValue(state));
    }

    protected ECStateVariable getECStateVariable() {
        return (ECStateVariable)this.getContext().getMembers().get("__STATE");
    }

    public Map<ECTransition, Evaluator> getTransitionEvaluators() {
        return this.transitionEvaluators;
    }

    @Override
    public Set<String> getDependencies() {
        return Stream.concat(Stream.of(super.getDependencies()), this.transitionEvaluators.values().stream().map(Evaluator::getDependencies)).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }

    protected static boolean hasConditionExpression(ECTransition transition) {
        return transition.getConditionExpression() != null && !transition.getConditionExpression().isBlank();
    }

    protected Evaluator createECTransitionEvaluator(ECTransition transition) {
        return EvaluatorFactory.createEvaluator(transition, transition.eClass().getInstanceClass().asSubclass(ECTransition.class), this.getContext(), Collections.emptySet(), this);
    }
}

