/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.ecc.commands;

import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.ui.providers.CreationCommand;

public class CreateAlgorithmCommand
extends CreationCommand {
    private static final String DEFAULT_ALGORITHM_NAME = "ALG1";
    private final BasicFBType fbType;
    private STAlgorithm newAlgorithm;
    private Algorithm oldAlgorithm;
    private ECAction action;
    private final int index;
    private final String name;

    public CreateAlgorithmCommand(BasicFBType fbType) {
        this(fbType, fbType.getCallables().size() - 1, null);
    }

    public CreateAlgorithmCommand(BasicFBType fbType, ECAction action) {
        this(fbType);
        this.action = action;
    }

    public CreateAlgorithmCommand(BasicFBType fbType, int index, String name) {
        this.fbType = fbType;
        this.index = index;
        this.name = name != null ? name : DEFAULT_ALGORITHM_NAME;
    }

    public void execute() {
        if (this.action != null) {
            this.oldAlgorithm = this.action.getAlgorithm();
        }
        this.newAlgorithm = LibraryElementFactory.eINSTANCE.createSTAlgorithm();
        this.newAlgorithm.setComment("");
        this.newAlgorithm.setText("");
        this.redo();
        this.newAlgorithm.setName(NameRepository.createUniqueName((INamedElement)this.newAlgorithm, (String)this.name));
    }

    public void undo() {
        if (this.action != null) {
            this.action.setAlgorithm(this.oldAlgorithm);
        }
        this.fbType.getCallables().remove((Object)this.newAlgorithm);
    }

    public void redo() {
        if (this.action != null) {
            this.action.setAlgorithm((Algorithm)this.newAlgorithm);
        }
        this.fbType.getCallables().add(this.index, (Object)this.newAlgorithm);
    }

    public Algorithm getCreatedElement() {
        return this.newAlgorithm;
    }
}

