/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.EventManager;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.FBRuntimeAbstract;
import org.eclipse.fordiac.ide.fb.interpreter.api.BasicFbExecutionTrace;
import org.eclipse.fordiac.ide.fb.interpreter.api.EventManagerFactory;
import org.eclipse.fordiac.ide.fb.interpreter.api.RuntimeFactory;
import org.eclipse.fordiac.ide.fb.interpreter.api.TransactionFactory;
import org.eclipse.fordiac.ide.fb.interpreter.mm.EventManagerUtils;
import org.eclipse.fordiac.ide.fb.interpreter.mm.FBTestRunner;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.Messages;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.SequenceRootEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.editparts.ServiceSequenceEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.helpers.ServiceSequenceSaveAndLoadHelper;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.view.GetCoverageDialog;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class GetCoverageHandler
extends AbstractHandler {
    Map<String, Integer> visitedStates = new HashMap<String, Integer>();
    Map<List<String>, Integer> visitedPaths = new HashMap<List<String>, Integer>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Optional<Object> eventManagerValidity = Optional.empty();
        if (!selection.isEmpty()) {
            this.clearLists();
            for (Object sel : selection) {
                ServiceSequenceEditPart serviceEP;
                EditPart editPart;
                EditPart editPart2 = (EditPart)sel;
                if (editPart2 instanceof SequenceRootEditPart) {
                    SequenceRootEditPart serviceSeqEP = (SequenceRootEditPart)editPart2;
                    for (Object service : serviceSeqEP.getChildren()) {
                        if (!(service instanceof ServiceSequenceEditPart)) continue;
                        ServiceSequenceEditPart serviceEP2 = (ServiceSequenceEditPart)((Object)service);
                        ServiceSequence seq = serviceEP2.getModel();
                        eventManagerValidity = GetCoverageHandler.checkForExistingEventManager(seq, serviceSeqEP.getFBType());
                        this.setCoverageData((EventManager)seq.getEventManager(), seq);
                    }
                    continue;
                }
                EditPart editPart3 = (EditPart)sel;
                if (!(editPart3 instanceof ServiceSequenceEditPart) || !((editPart = (serviceEP = (ServiceSequenceEditPart)editPart3).getParent()) instanceof SequenceRootEditPart)) continue;
                SequenceRootEditPart serviceSeqEP = (SequenceRootEditPart)editPart;
                ServiceSequence seq = serviceEP.getModel();
                eventManagerValidity = GetCoverageHandler.checkForExistingEventManager(seq, serviceSeqEP.getFBType());
                this.setCoverageData((EventManager)seq.getEventManager(), serviceEP.getModel());
            }
        }
        GetCoverageDialog dialog = eventManagerValidity.isEmpty() ? new GetCoverageDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), this.visitedStates, this.visitedPaths) : new MessageDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), Messages.RunServiceSequenceHandler_InconsistencyDetected, null, Messages.RunServiceSequenceHandler_SequenceDoesNotMatchECC + ":\n" + (String)eventManagerValidity.get(), 4, new String[]{"OK"}, 0);
        dialog.open();
        return Status.OK_STATUS;
    }

    private void setCoverageData(EventManager evntMngr, ServiceSequence seq) {
        BasicFbExecutionTrace eccTraceHelper = new BasicFbExecutionTrace((List)evntMngr.getTransactions(), ((BasicFBType)seq.getService().getFBType()).getECC());
        if (this.visitedStates.isEmpty()) {
            eccTraceHelper.getAllPossibleStates().forEach(s -> {
                Integer n = this.visitedStates.put(s.getName(), 0);
            });
        }
        if (this.visitedPaths.isEmpty()) {
            eccTraceHelper.getAllPossiblePaths().forEach(p -> {
                Integer n = this.visitedPaths.put((List<String>)p, 0);
            });
        }
        eccTraceHelper.getAllStatesOfSequence().forEach(s -> {
            Integer n = this.visitedStates.merge(s.getName(), 1, Integer::sum);
        });
        eccTraceHelper.getAllPathsOfSequence().forEach(p -> {
            Integer n = this.visitedPaths.merge((List<String>)p, 1, Integer::sum);
        });
    }

    private static Optional<String> checkForExistingEventManager(ServiceSequence seq, FBType fbType) {
        if (seq.getEventManager() == null) {
            seq.setEventManager((EObject)ServiceSequenceSaveAndLoadHelper.loadEventManagerFromServiceSequenceFile(fbType, seq));
        }
        if (seq.getEventManager() == null) {
            seq.setEventManager((EObject)GetCoverageHandler.executeServiceSequence(seq, fbType));
        }
        return FBTestRunner.checkResults((ServiceSequence)seq, (EventManager)((EventManager)seq.getEventManager()));
    }

    private static EventManager executeServiceSequence(ServiceSequence seq, FBType fb) {
        if (seq.getServiceTransaction().isEmpty()) {
            return null;
        }
        FBType copyFbType = (FBType)EcoreUtil.copy((EObject)fb);
        FBRuntimeAbstract rt = RuntimeFactory.createFrom((FBType)copyFbType);
        RuntimeFactory.setStartState((FBRuntimeAbstract)rt, (String)seq.getStartState());
        List transaction = TransactionFactory.createFrom((FBType)copyFbType, (ServiceSequence)seq, (FBRuntimeAbstract)rt);
        EventManager eventManager = EventManagerFactory.createFrom((List)transaction);
        TransactionFactory.addTraceInfoTo((EList)eventManager.getTransactions());
        EventManagerUtils.process((EventManager)eventManager);
        return eventManager;
    }

    private void clearLists() {
        this.visitedStates.clear();
        this.visitedPaths.clear();
    }
}

