/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.wizards.SaveAsSubappWizard;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class SaveAsSubappTypeHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        for (Object selected : selection.toList()) {
            EditPart ep = (EditPart)selected;
            SubApp subApp = (SubApp)ep.getModel();
            SaveAsSubappTypeHandler.invokeSaveWizard(subApp, editor);
        }
        return Status.OK_STATUS;
    }

    public void setEnabled(Object evaluationContext) {
        ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        this.setBaseEnabled(SaveAsSubappTypeHandler.calculateEnabled(selection));
    }

    private static boolean calculateEnabled(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            for (Object selected : ((IStructuredSelection)selection).toList()) {
                if (selected instanceof EditPart && ((EditPart)selected).getModel() instanceof SubApp) {
                    if (((SubApp)((EditPart)selected).getModel()).getTypeEntry() == null) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private static void invokeSaveWizard(SubApp subApp, IEditorPart editor) {
        SaveAsSubappWizard wizard = new SaveAsSubappWizard(subApp, Messages.SaveAsSubApplicationTypeAction_WizardPageName);
        WizardDialog dialog = new WizardDialog(editor.getSite().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
    }
}

