/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.core.jobs.Job;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;

public final class ItemSeq
extends Seq {
    private final Item[] items;

    private ItemSeq(Item[] items, int size, Type type) {
        super(size, type);
        this.items = items;
    }

    @Override
    public Item itemAt(long index) {
        return this.items[(int)index];
    }

    @Override
    public Value reverse(Job job) {
        int sz = (int)this.size;
        Item[] tmp = new Item[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.items[i];
        }
        return new ItemSeq(tmp, sz, this.type);
    }

    @Override
    public Value shrink(Job job) throws QueryException {
        int i = 0;
        while ((long)i < this.size) {
            this.items[i] = this.items[i].shrink(job);
            ++i;
        }
        this.refineType();
        return this.type.oneOf(AtomType.STRING, AtomType.UNTYPED_ATOMIC, AtomType.INTEGER, AtomType.DOUBLE, AtomType.BOOLEAN) ? this.rebuild(job) : this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj instanceof ItemSeq) {
            ItemSeq seq = (ItemSeq)obj;
            if (!Array.equals(this.items, seq.items)) return false;
            return true;
        } else if (!super.equals(obj)) return false;
        return true;
    }

    public static Value get(Item[] items, int size, Type type) {
        return size == 0 ? Empty.VALUE : (size == 1 ? items[0] : new ItemSeq(items, size, type != null ? type : AtomType.ITEM));
    }
}

