/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.expr;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.gflwor.Let;
import org.basex.query.iter.Iter;
import org.basex.query.up.Updates;
import org.basex.query.up.expr.Copy;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class Transform
extends Copy {
    private final Let[] copies;

    public Transform(InputInfo info, Let[] copies, Expr modify, Expr rtrn) {
        super(info, Types.ITEM_ZM, modify, rtrn);
        this.copies = copies;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        for (Let copy : this.copies) {
            copy.compile(cc);
            copy.exprType.assign(copy.expr);
        }
        return super.compile(cc);
    }

    @Override
    public void checkUp() throws QueryException {
        for (Let copy : this.copies) {
            copy.checkUp();
        }
        super.checkUp();
        this.arg(Transform.target()).checkUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value value(QueryContext qc) throws QueryException {
        Updates updates;
        Updates tmp = qc.updates();
        qc.updates = updates = new Updates(true);
        try {
            for (Let copy : this.copies) {
                Iter iter = copy.expr.iter(qc);
                Item item = iter.next();
                Value error = null;
                if (item == null) {
                    error = Empty.VALUE;
                } else if (!(item instanceof ANode)) {
                    error = item;
                } else {
                    Item item2 = iter.next();
                    if (item2 != null) {
                        error = item.append(item2, qc);
                    }
                }
                if (error != null) {
                    throw QueryError.UPSINGLE_X_X.get(copy.info(), copy.var.name, error);
                }
                item = ((ANode)item).copy(qc);
                qc.set(copy.var, item);
                updates.addData(item.data());
            }
            if (!this.arg(Transform.update()).value(qc).isEmpty()) {
                throw QueryError.UPMODIFY.get(this.info, new Object[0]);
            }
            updates.prepare(qc);
            updates.apply(qc);
        }
        finally {
            qc.updates = tmp;
        }
        return this.arg(Transform.target()).value(qc);
    }

    @Override
    public boolean has(Flag ... flags) {
        return ((Checks<Let>)copy -> copy.has(flags)).any((Let[])this.copies) || Flag.CNS.oneOf(flags) || Flag.UPD.oneOf(flags) && this.arg(Transform.target()).has(Flag.UPD) || super.has(Flag.remove(flags, Flag.UPD));
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        for (Let copy : this.copies) {
            if (copy.inlineable(ic)) continue;
            return false;
        }
        return super.inlineable(ic);
    }

    @Override
    public VarUsage count(Var var) {
        return VarUsage.sum(var, this.copies).plus(super.count(var));
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        boolean changed1 = ic.inline(this.copies);
        boolean changed2 = ic.inline(this.args());
        return changed1 || changed2 ? this.optimize(ic.cc) : null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new Transform(this.info, (Let[])Transform.copyAll((CompileContext)cc, vm, (Expr[])this.copies), this.arg(Transform.update()).copy(cc, vm), this.arg(Transform.target()).copy(cc, vm)));
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return Transform.visitAll(visitor, this.copies) && super.accept(visitor);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (Let copy : this.copies) {
            size += copy.exprSize();
        }
        return size + super.exprSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Transform)) return false;
        Transform tf = (Transform)obj;
        if (!Array.equals(this.copies, tf.copies)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), new Object[]{this.copies, this.args()});
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("copy");
        boolean more = false;
        for (Let copy : this.copies) {
            if (more) {
                qs.token(", ");
            } else {
                more = true;
            }
            qs.token(copy.var.id()).token(":=").token(copy.expr);
        }
        qs.token("modify").token(this.arg(Transform.update())).token("return").token(this.arg(Transform.target()));
    }
}

