/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;

class Icon
extends Component {
    protected Image image;
    private Dimension imageSize;

    public Icon(Image i) {
        this.image = i;
        this.waitForSize();
        this.imageSize = new Dimension(-1, -1);
        this.imageSize.width = i.getWidth(this);
        this.imageSize.height = i.getHeight(this);
    }

    public Icon(String name) {
        Toolkit kit = this.getToolkit();
        this.imageSize = new Dimension(-1, -1);
        this.image = kit.getImage(name);
        this.waitForSize();
        this.imageSize.width = this.image.getWidth(this);
        this.imageSize.height = this.image.getHeight(this);
        this.setName(name);
    }

    public Icon(URL url) {
        Toolkit kit = this.getToolkit();
        this.imageSize = new Dimension(-1, -1);
        this.image = kit.getImage(url);
        this.waitForSize();
        this.imageSize.width = this.image.getWidth(this);
        this.imageSize.height = this.image.getHeight(this);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return this.imageSize;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics g) {
        if (this.image != null) {
            Dimension size = this.getSize();
            g.drawImage(this.image, 0, 0, size.width, size.height, this);
        }
    }

    protected void waitForSize() {
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(this.image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected Dimension getImageSize() {
        return this.imageSize;
    }
}

