/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.ActiveAgentPool;
import com.sun.javatest.agent.AgentManager;
import com.sun.javatest.agent.AgentMonitorToolManager;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.IOException;
import java.util.ListIterator;

public class AgentMonitorCommandManager
extends CommandManager {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(AgentMonitorCommandManager.class);

    @Override
    public HelpTree.Node getHelp() {
        String[] cmds = new String[]{AgentPoolPortCommand.getName(), AgentPoolTimeoutCommand.getName(), StartAgentPoolCommand.getName(), ShowMonitorCommand.getName()};
        return new HelpTree.Node(i18n, "cmgr.help", cmds);
    }

    @Override
    public boolean parseCommand(String cmd, ListIterator argIter, CommandContext ctx) throws Command.Fault {
        if (cmd.equalsIgnoreCase(AgentPoolPortCommand.getName())) {
            ctx.addCommand(new AgentPoolPortCommand(argIter));
            return true;
        }
        if (cmd.equalsIgnoreCase(AgentPoolTimeoutCommand.getName())) {
            ctx.addCommand(new AgentPoolTimeoutCommand(argIter));
            return true;
        }
        if (cmd.equalsIgnoreCase(ShowMonitorCommand.getName())) {
            ctx.addCommand(new ShowMonitorCommand());
            return true;
        }
        if (cmd.equalsIgnoreCase(StartAgentPoolCommand.getName())) {
            ctx.addCommand(new StartAgentPoolCommand(argIter));
            return true;
        }
        return false;
    }

    private static class ShowMonitorCommand
    extends Command {
        static String getName() {
            return "monitorAgent";
        }

        ShowMonitorCommand() {
            super(ShowMonitorCommand.getName());
        }

        @Override
        public int getDesktopMode() {
            return 2;
        }

        @Override
        public void run(CommandContext ctx) {
            Desktop d = ctx.getDesktop();
            AgentMonitorToolManager tm = (AgentMonitorToolManager)d.getToolManager(AgentMonitorToolManager.class);
            tm.startTool();
        }
    }

    private static class StartAgentPoolCommand
    extends Command {
        private AgentPoolPortCommand portSubcommand;
        private AgentPoolTimeoutCommand timeoutSubcommand;

        static String getName() {
            return "startAgentPool";
        }

        StartAgentPoolCommand(ListIterator argIter) throws Command.Fault {
            super(StartAgentPoolCommand.getName());
            while (argIter.hasNext()) {
                String arg = this.nextArg(argIter);
                if (arg.equalsIgnoreCase("-" + AgentPoolPortCommand.getName())) {
                    this.portSubcommand = new AgentPoolPortCommand(argIter);
                    this.addArgs(this.portSubcommand);
                    continue;
                }
                if (arg.equalsIgnoreCase("-" + AgentPoolTimeoutCommand.getName())) {
                    this.timeoutSubcommand = new AgentPoolTimeoutCommand(argIter);
                    this.addArgs(this.timeoutSubcommand);
                    continue;
                }
                this.putbackArg(argIter);
                break;
            }
        }

        @Override
        public void run(CommandContext ctx) throws Command.Fault {
            if (this.portSubcommand != null) {
                this.portSubcommand.run(ctx);
            }
            if (this.timeoutSubcommand != null) {
                this.timeoutSubcommand.run(ctx);
            }
            try {
                AgentManager mgr = AgentManager.access();
                ActiveAgentPool pool = mgr.getActiveAgentPool();
                pool.setListening(true);
            }
            catch (IOException e) {
                AgentManager mgr = AgentManager.access();
                ActiveAgentPool pool = mgr.getActiveAgentPool();
                String p = Integer.toString(pool.getPort());
                throw new Command.Fault((Command)this, i18n, "cmgr.listenOn.err", new Object[]{p, e});
            }
        }

        private void addArgs(Command c) {
            String[] args = c.getArgs();
            for (int i = 1; i < args.length; ++i) {
                this.addArg(args[i]);
            }
        }
    }

    private static class AgentPoolTimeoutCommand
    extends Command {
        private int timeout;

        static String getName() {
            return "agentPoolTimeout";
        }

        AgentPoolTimeoutCommand(ListIterator argIter) throws Command.Fault {
            super(AgentPoolTimeoutCommand.getName());
            if (!argIter.hasNext()) {
                throw new Command.Fault(this, i18n, "cmgr.missingArg.err");
            }
            try {
                this.timeout = Integer.parseInt(this.nextArg(argIter));
            }
            catch (NumberFormatException e) {
                throw new Command.Fault(this, i18n, "cmgr.badNumber.err");
            }
        }

        @Override
        public void run(CommandContext ctx) {
            AgentManager mgr = AgentManager.access();
            ActiveAgentPool pool = mgr.getActiveAgentPool();
            pool.setTimeout(this.timeout * 1000);
        }
    }

    private static class AgentPoolPortCommand
    extends Command {
        private int port;

        static String getName() {
            return "agentPoolPort";
        }

        AgentPoolPortCommand(ListIterator argIter) throws Command.Fault {
            super(AgentPoolPortCommand.getName());
            if (!argIter.hasNext()) {
                throw new Command.Fault(this, i18n, "cmgr.missingArg.err");
            }
            try {
                this.port = Integer.parseInt(this.nextArg(argIter));
            }
            catch (NumberFormatException e) {
                throw new Command.Fault(this, i18n, "cmgr.badNumber.err");
            }
        }

        @Override
        public void run(CommandContext ctx) {
            AgentManager mgr = AgentManager.access();
            ActiveAgentPool pool = mgr.getActiveAgentPool();
            pool.setPort(this.port);
        }
    }
}

