/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.apiCheck;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.StringTokenizer;
import javasoft.sqe.apiCheck.API;
import javasoft.sqe.apiCheck.ClassProcessor;
import javasoft.sqe.apiCheck.Main;
import javasoft.sqe.apiCheck.PackageSet;
import javasoft.sqe.apiCheck.PathLoader;
import javasoft.sqe.apiCheck.PathWalk;
import javasoft.sqe.apiCheck.ReadClasses;
import javasoft.sqe.apiCheck.XClass;
import javasoft.sqe.apiCheck.XClassConstructor;
import javasoft.sqe.apiCheck.XClassField;
import javasoft.sqe.apiCheck.XClassMethod;
import javasoft.sqe.apiCheck.XModifier;
import javasoft.sqe.apiCheck.XProg;
import javasoft.sqe.apiCheck.XTypes;

class ReadReflect
implements ReadClasses {
    XProg prog;
    PathLoader loader;
    boolean valuemode;
    static String stypes = "-boolean-byte-short-int-long-float-double-char-java.lang.String-";

    ReadReflect(boolean v) {
        this.valuemode = v;
    }

    public boolean ReadPath(API api, String classpath, PackageSet packs) {
        long t0 = Main.GetTimer();
        api.xprog = this.prog = new XProg();
        api.props.Add("date", new Date().toString());
        if (classpath == null || classpath.length() == 0) {
            classpath = System.getProperty("java.class.path");
            this.loader = new PathLoader();
            this.loader.OpenPath(classpath);
            System.err.println("&&&& No classpath specified using system property java.class.path");
        } else if (classpath.equals("$") || classpath.equals("@")) {
            classpath = System.getProperty("sun.boot.class.path");
            this.loader = null;
            api.props.Add("version", System.getProperty("java.version"));
            System.err.println("&&&& No classpath specified using system property sun.boot.class.path");
        } else {
            this.loader = new PathLoader();
            this.loader.OpenPath(classpath);
            System.err.println("&&&& Classpath specified by user");
        }
        System.err.println("&&&& Searching for package members in: \"" + classpath + "\"");
        api.props.Add("classpath", classpath);
        if (!packs.IsEmpty()) {
            api.props.Add("package", packs.toString());
        }
        PathWalk path = new PathWalk(packs, new Processor());
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator, false);
        int errs = 0;
        while (st.hasMoreElements()) {
            if (path.Walk((String)st.nextElement())) continue;
            ++errs;
        }
        path.Close();
        this.loader = null;
        this.prog = null;
        Main.PrintTimer("ReadPath " + classpath, t0);
        return errs == 0;
    }

    class Processor
    implements ClassProcessor {
        Class c;
        XClass xclass;

        Processor() {
        }

        public void ProcessClass(String pack, String name, Object src, Object sub) {
            String s = pack == null ? name : pack + name;
            try {
                this.c = Class.forName(s);
            }
            catch (Throwable x) {
                System.err.println("Failed to load class " + s);
                System.err.println(x.getMessage());
                x.printStackTrace(System.out);
                x.printStackTrace(System.err);
            }
            try {
                if (this.c != null) {
                    this.ProcessClass();
                } else {
                    ReadReflect.this.prog.DefineClass(s);
                }
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
            this.c = null;
            this.xclass = null;
        }

        void ProcessClass() {
            Class<?>[] interfs;
            Class xsuper;
            this.xclass = ReadReflect.this.prog.DefineClass(this.c.getName());
            if (this.xclass.defined) {
                System.err.println("Duplicate class \"" + this.xclass.FullName() + "\" - ignored");
                return;
            }
            this.xclass.defined = true;
            this.xclass.modifier = this.GetModifiers(this.c.getModifiers(), this.xclass.home == null ? 1553 : 1567);
            try {
                xsuper = this.c.getSuperclass();
            }
            catch (Throwable x) {
                System.err.println("Failed to get superclass for " + this.xclass.FullName());
                System.err.println(x.getMessage());
                return;
            }
            if (xsuper != null) {
                this.xclass.extend = ReadReflect.this.prog.DefineClass(xsuper.getName());
            }
            try {
                interfs = this.c.getInterfaces();
            }
            catch (Throwable x) {
                System.err.println("Failed to get interfaces for " + this.xclass.FullName());
                System.err.println(x.getMessage());
                return;
            }
            if (interfs != null) {
                for (int i = 0; i < interfs.length; ++i) {
                    this.xclass.implement.Add(ReadReflect.this.prog.DefineClass(interfs[i].getName()));
                }
            }
            this.ProcessClassConstructors();
            this.ProcessClassMethods();
            this.ProcessClassFields();
            this.ProcessClassInners();
        }

        void ProcessClassConstructors() {
            Constructor<?>[] constructors;
            try {
                constructors = this.c.getDeclaredConstructors();
            }
            catch (Throwable x) {
                System.err.println("Failed to get constructors for " + this.xclass.FullName());
                System.err.println(x.getMessage());
                return;
            }
            for (int i = 0; i < constructors.length; ++i) {
                XClassConstructor xconstructor = new XClassConstructor();
                xconstructor.name = constructors[i].getName();
                int k = xconstructor.name.lastIndexOf(46);
                int l = xconstructor.name.lastIndexOf(36);
                if (l > k) {
                    k = l;
                }
                if (k > 0) {
                    xconstructor.name = xconstructor.name.substring(k + 1);
                }
                xconstructor.modifier = this.GetModifiers(constructors[i].getModifiers(), 3391);
                xconstructor.args = this.GetArgs(constructors[i].getParameterTypes());
                xconstructor.xthrows = this.GetArgs(constructors[i].getExceptionTypes());
                xconstructor.Link(this.xclass);
            }
        }

        void ProcessClassMethods() {
            Method[] methods;
            try {
                methods = this.c.getDeclaredMethods();
            }
            catch (Throwable x) {
                System.err.println("Failed to get methods for " + this.xclass.FullName());
                System.err.println(x.getMessage());
                return;
            }
            for (int i = 0; i < methods.length; ++i) {
                XClassMethod xmethod = new XClassMethod();
                if (methods[i].getDeclaringClass() != this.c) continue;
                xmethod.name = methods[i].getName();
                xmethod.modifier = this.GetModifiers(methods[i].getModifiers(), 3391);
                xmethod.type = ReadReflect.this.prog.DefineType(methods[i].getReturnType().getName());
                xmethod.args = this.GetArgs(methods[i].getParameterTypes());
                xmethod.xthrows = this.GetArgs(methods[i].getExceptionTypes());
                xmethod.Link(this.xclass);
            }
        }

        void ProcessClassFields() {
            Field[] fields;
            try {
                fields = this.c.getDeclaredFields();
            }
            catch (Throwable x) {
                System.err.println("Failed to get fields for " + this.xclass.FullName());
                System.err.println(x.getMessage());
                return;
            }
            for (int i = 0; i < fields.length; ++i) {
                XClassField xfield = new XClassField();
                if (fields[i].getDeclaringClass() != this.c) continue;
                Field f = fields[i];
                xfield.name = f.getName();
                xfield.modifier = this.GetModifiers(f.getModifiers(), 223);
                xfield.type = ReadReflect.this.prog.DefineType(f.getType().getName());
                xfield.Link(this.xclass);
                if (!ReadReflect.this.valuemode || !XModifier.IsAnd(xfield.modifier, 24) || stypes.indexOf("-" + xfield.type + "-") == -1) continue;
                try {
                    f.setAccessible(true);
                    xfield.value = f.get(null);
                    continue;
                }
                catch (IllegalAccessException x) {
                    xfield.value = null;
                }
            }
        }

        void ProcessClassInners() {
            Class<?>[] classes;
            try {
                classes = this.c.getDeclaredClasses();
            }
            catch (Throwable x) {
                System.err.println("Failed to get inner classes for " + this.xclass.FullName());
                System.err.println(x.getMessage());
                return;
            }
            for (int i = 0; i < classes.length; ++i) {
                XClass xClass = ReadReflect.this.prog.DefineClass(classes[i].getName());
            }
        }

        int GetModifiers(int mod, int allowed) {
            int x = 0;
            StringTokenizer st = new StringTokenizer(Modifier.toString(mod), " ", false);
            while (st.hasMoreElements()) {
                x |= XModifier.ConvertNew((String)st.nextElement());
            }
            if ((x & ~allowed) != 0) {
                System.err.println("not allowed modifier(s): \"" + XModifier.toString(x & ~allowed) + "\"");
            }
            return x & allowed;
        }

        XTypes GetArgs(Class[] pars) {
            XTypes tt = new XTypes(pars.length);
            for (int i = 0; i < pars.length; ++i) {
                tt.Add(ReadReflect.this.prog.DefineType(pars[i].getName()));
            }
            return tt;
        }
    }
}

