/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.apiCheck;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class PackageList {
    private static final String COMMENT_CHAR = "#";
    private static final String BACKUP_EXT = ".bak";
    private File packageFile;
    private File sigFile;
    private String additionalPackageName;
    private Set packageNames = new TreeSet();

    public PackageList(String packageFileName) throws Exception {
        this.packageFile = new File(packageFileName);
        if (!this.packageFile.exists() || !this.packageFile.isFile()) {
            throw new FileNotFoundException(packageFileName);
        }
        this.extractExistingPackageNames();
    }

    public PackageList(String packageName, String sigFileName, String packageFileName) throws Exception {
        this.additionalPackageName = packageName;
        this.sigFile = new File(sigFileName);
        if (!this.sigFile.exists() || !this.sigFile.isFile()) {
            throw new FileNotFoundException(sigFileName);
        }
        this.packageFile = new File(packageFileName);
        if (this.packageFile.exists() && this.packageFile.isFile()) {
            this.extractExistingPackageNames();
            this.removeExistingPackage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractExistingPackageNames() throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(this.packageFile));
        String line = null;
        String trimLine = null;
        try {
            while ((line = in.readLine()) != null) {
                trimLine = line.trim();
                if (this.isComment(trimLine) || trimLine.equals("")) continue;
                this.packageNames.add(trimLine);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
    }

    private boolean isComment(String line) {
        if (line == null) {
            return false;
        }
        return line.startsWith(COMMENT_CHAR);
    }

    private void removeExistingPackage() {
        String delPackage = this.additionalPackageName;
        String packageName = null;
        ArrayList<String> delPkgs = new ArrayList<String>();
        Iterator i = this.packageNames.iterator();
        while (i.hasNext()) {
            packageName = (String)i.next();
            if (!packageName.startsWith(delPackage)) continue;
            delPkgs.add(packageName);
        }
        for (int i2 = 0; i2 < delPkgs.size(); ++i2) {
            packageName = (String)delPkgs.get(i2);
            this.packageNames.remove(packageName);
            System.out.println("PackageList.removeExistingPackage() \"" + packageName + "\"");
        }
    }

    public void writePkgListFile() throws Exception {
        this.readPkgsFromSigFile();
        this.removePkgFile();
        this.writePkgFile();
    }

    private String parsePackageName(String packageLine) throws Exception {
        StringTokenizer tokens = new StringTokenizer(packageLine);
        if (tokens.countTokens() != 2) {
            throw new Exception("PackageList.parsePackageName() - Error: badly formed package name \"" + packageLine + "\" expected \"package <package-name>;\"");
        }
        String packageToken = tokens.nextToken();
        String packageName = tokens.nextToken();
        if (packageName.endsWith(";")) {
            packageName = packageName.substring(0, packageName.length() - 1);
        }
        return packageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPkgsFromSigFile() throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(this.sigFile));
        String line = null;
        String trimLine = null;
        try {
            while ((line = in.readLine()) != null) {
                trimLine = line.trim();
                if (!trimLine.startsWith("package ") || !trimLine.endsWith(";")) continue;
                this.packageNames.add(this.parsePackageName(trimLine));
            }
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
    }

    private void removePkgFile() throws Exception {
        File backupPkgFile = new File(this.packageFile.getPath() + BACKUP_EXT);
        if (backupPkgFile.exists() && backupPkgFile.isFile()) {
            backupPkgFile.delete();
        }
        if (this.packageFile.isFile() && this.packageFile.exists()) {
            File copyPackageFile = new File(this.packageFile.getPath());
            copyPackageFile.renameTo(backupPkgFile);
        }
    }

    private void writeHeader(BufferedWriter out) throws Exception {
        out.write("##");
        out.newLine();
        out.write("# This file contains a list of all the packages");
        out.newLine();
        out.write("# contained in the signature files for this");
        out.newLine();
        out.write("# deliverable.  This file is used to exclude valid");
        out.newLine();
        out.write("# sub-packages from being verified when their");
        out.newLine();
        out.write("# parent package's signature is checked.");
        out.newLine();
        out.write("##");
        out.newLine();
        out.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePkgFile() throws Exception {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(this.packageFile));
            this.writeHeader(out);
            Iterator i = this.packageNames.iterator();
            while (i.hasNext()) {
                String packageName = (String)i.next();
                out.write(packageName);
                out.newLine();
                System.out.println("PackageList.writePkgFile() \"" + packageName + "\"");
            }
        }
        finally {
            out.close();
        }
    }

    public String[] getSubPackages(String pkgName) {
        ArrayList<String> result = new ArrayList<String>();
        String subPackageName = pkgName + ".";
        Iterator i = this.packageNames.iterator();
        while (i.hasNext()) {
            String packageName = (String)i.next();
            if (!packageName.startsWith(subPackageName)) continue;
            result.add(packageName);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getSubPackagesFormatted(String pkgName) {
        StringBuffer formattedResult = new StringBuffer();
        String[] result = this.getSubPackages(pkgName);
        for (int i = 0; i < result.length; ++i) {
            formattedResult.append(result[i]);
            if (i >= result.length - 1) continue;
            formattedResult.append("+");
        }
        return formattedResult.toString();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("\n\n*** Creating package list file ***\n\n");
        PackageList list = new PackageList("javax.ejb", "/home/ryano/cts-tools-master/tools/api-check/test/javax.ejb.sig_2.1", "/home/ryano/cts-tools-master/tools/api-check/test/pkg-list.txt");
        list.writePkgListFile();
        System.out.println("\n\n*** Reading sub-packages from package list file ***\n\n");
        PackageList readList = new PackageList("/home/ryano/cts-tools-master/tools/api-check/test/pkg-list.txt");
        System.out.println(Arrays.asList(readList.getSubPackages("javax.ejb")));
        System.out.println(readList.getSubPackagesFormatted("javax.ejb"));
    }
}

