/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ScrapeFailedSmokeTests
extends Task {
    protected static final String NL = System.getProperty("line.separator", "\n");
    protected File smokelog;
    protected String property;

    public void setSmokelog(File smokelog) {
        this.smokelog = smokelog;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void execute() throws BuildException {
        this.checkPreconditions();
        this.processLog();
    }

    protected void checkPreconditions() throws BuildException {
        if (this.smokelog == null) {
            throw new BuildException("Error, \"smokelog\" attribute must be specified");
        }
        if (!this.smokelog.isFile()) {
            throw new BuildException("Error, smoke log file \"" + this.smokelog + "\" does not exist");
        }
        if (this.property == null || this.property.length() == 0) {
            throw new BuildException("Error, \"property\" attribute must be specified");
        }
    }

    protected void processLog() throws BuildException {
        BufferedReader in = null;
        String line = null;
        StringBuffer failedTestList = new StringBuffer();
        try {
            in = new BufferedReader(new FileReader(this.smokelog));
            while ((line = in.readLine()) != null) {
                String result = this.checkLine(line);
                if (result == null) continue;
                failedTestList.append(result + NL + NL);
            }
            this.project.setProperty(this.property, failedTestList.toString());
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ee) {}
        }
    }

    protected String checkLine(String line) {
        String result = null;
        String searchString = "[java] FAILED";
        int index = line.indexOf(searchString);
        if (index != -1) {
            result = line;
        }
        return result;
    }
}

