/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.common;

import com.sun.ts.lib.util.TestUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class MyBufferedWriter
extends BufferedWriter {
    private boolean throwIOException;

    public MyBufferedWriter(Writer out) {
        super(out);
    }

    public MyBufferedWriter(Writer out, int sz) {
        super(out, sz);
    }

    public MyBufferedWriter(Writer out, int sz, boolean throwIOException) {
        super(out, sz);
        this.throwIOException = throwIOException;
    }

    private void checkToTripIOException() throws IOException {
        if (this.throwIOException) {
            TestUtil.logMsg((String)"*** tripping an IOException ***");
            throw new IOException("tripping an IOException");
        }
    }

    public void setThrowIOException(boolean throwIOException) {
        this.throwIOException = throwIOException;
    }

    @Override
    public void write(int c) throws IOException {
        this.checkToTripIOException();
        super.write(c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.checkToTripIOException();
        super.write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int offset, int length) throws IOException {
        this.checkToTripIOException();
        super.write(cbuf, offset, length);
    }

    @Override
    public void write(String str) throws IOException {
        this.checkToTripIOException();
        super.write(str);
    }

    @Override
    public void write(String str, int offset, int length) throws IOException {
        this.checkToTripIOException();
        super.write(str, offset, length);
    }

    @Override
    public void close() throws IOException {
        this.checkToTripIOException();
        super.close();
    }

    @Override
    public void flush() throws IOException {
        this.checkToTripIOException();
        super.flush();
    }
}

