/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.singleton.dependson.common;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import jakarta.ejb.Singleton;
import jakarta.ejb.Startup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Startup
@Singleton
public class HistoryBean {
    private Map<String, List<Integer>> instanceIdsMap = new HashMap<String, List<Integer>>();
    private Map<String, Long> creationTimeMillisMap = new HashMap<String, Long>();

    public List<Integer> getInstanceIdsByBeanName(String beanName) {
        return this.instanceIdsMap.get(beanName);
    }

    public void addInstanceIdForBeanName(String beanName, int i, Object beanInstance) {
        List<Integer> ids = this.instanceIdsMap.get(beanName);
        if (ids == null) {
            ids = new ArrayList<Integer>();
            this.instanceIdsMap.put(beanName, ids);
        }
        ids.add(i);
        Helper.getLogger().info(String.format("Adding instanceId %d for beanName %s by beanInstance %s", i, beanName, beanInstance));
    }

    public long getCreationTimeMillisByBeanName(String beanName) {
        return this.creationTimeMillisMap.get(beanName);
    }

    public void addCreationTimeMillisForBeanName(String beanName, long t, Object beanInstance) {
        if (this.creationTimeMillisMap.containsKey(beanName)) {
            throw new IllegalStateException("creationTimeMillis for beanName " + beanName + " already exists, which was added by another instance.");
        }
        this.creationTimeMillisMap.put(beanName, t);
        Helper.getLogger().info(String.format("Adding creationTimeMillis %d for beanName %s by beanInstance %s", t, beanName, beanInstance));
    }
}

