/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jstl.spec.xml.xconditional.xif;

import com.sun.ts.tests.jstl.common.client.AbstractUrlClient;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@Tags(value={@Tag(value="jstl"), @Tag(value="platform"), @Tag(value="web")})
@ExtendWith(value={ArquillianExtension.class})
public class JSTLClientIT
extends AbstractUrlClient {
    public static String packagePath = JSTLClientIT.class.getPackageName().replace(".", "/");

    public JSTLClientIT() {
        this.setContextRoot("/jstl_xml_xif_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jstl_xml_xif_web.war");
        archive.setWebXML(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/jstl_xml_xif_web.xml"));
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeIfInvalidScopeTest.jsp")), "negativeIfInvalidScopeTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeIfScopeVarTest.jsp")), "negativeIfScopeVarTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeIfSelectFailureTest.jsp")), "negativeIfSelectFailureTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/negativeIfSelectReqAttrTest.jsp")), "negativeIfSelectReqAttrTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveIfScopeTest.jsp")), "positiveIfScopeTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveIfSelectTest.jsp")), "positiveIfSelectTest.jsp");
        archive.add((Asset)new UrlAsset(JSTLClientIT.class.getClassLoader().getResource(packagePath + "/positiveIfVarTest.jsp")), "positiveIfVarTest.jsp");
        archive.addAsLibrary((Archive)JSTLClientIT.getCommonJarArchive());
        return archive;
    }

    @Test
    public void positiveIfSelectTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveIfSelectTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveIfSelectTest");
        this.invoke();
    }

    @Test
    public void positiveIfVarTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveIfVarTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveIfVarTest");
        this.invoke();
    }

    @Test
    public void positiveIfScopeTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/positiveIfScopeTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "positiveIfScopeTest");
        this.invoke();
    }

    @Test
    public void negativeIfInvalidScopeTest() throws Exception {
        TEST_PROPS.setProperty("testname", "negativeIfInvalidScopeTest");
        TEST_PROPS.setProperty("request", "negativeIfInvalidScopeTest.jsp");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void negativeIfSelectReqAttrTest() throws Exception {
        TEST_PROPS.setProperty("testname", "negativeIfSelectReqAttrTest");
        TEST_PROPS.setProperty("request", "negativeIfSelectReqAttrTest.jsp");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void negativeIfScopeVarTest() throws Exception {
        TEST_PROPS.setProperty("testname", "negativeIfScopeVarTest");
        TEST_PROPS.setProperty("request", "negativeIfScopeVarTest.jsp");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void negativeIfSelectFailureTest() throws Exception {
        InputStream gfStream = JSTLClientIT.class.getClassLoader().getResourceAsStream(packagePath + "/negativeIfSelectFailureTest.gf");
        this.setGoldenFileStream(gfStream);
        TEST_PROPS.setProperty("standard", "negativeIfSelectFailureTest");
        this.invoke();
    }
}

