/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox.mdcomplete;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSConnectionImpl;
import com.sun.ts.tests.common.connector.whitebox.TSEISDataSource;
import com.sun.ts.tests.common.connector.whitebox.TSManagedConnection;
import com.sun.ts.tests.common.connector.whitebox.Util;
import jakarta.resource.Referenceable;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConfigProperty;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.EISSystemException;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.ResourceAdapterAssociation;
import jakarta.resource.spi.TransactionSupport;
import jakarta.resource.spi.security.PasswordCredential;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Set;
import javax.naming.Reference;
import javax.security.auth.Subject;

public class MDCompleteMCF
implements ManagedConnectionFactory,
ResourceAdapterAssociation,
TransactionSupport,
Serializable,
Referenceable {
    private Reference reference;
    private ResourceAdapter resourceAdapter;
    private int count;
    private String TSRValue;
    private String password;
    private String user;
    private String userName;
    @ConfigProperty(description={"String value"}, ignore=false)
    String factoryName = "MDCompleteMCF";

    public MDCompleteMCF() {
        ConnectorStatus.getConnectorStatus().logState("MDCompleteMCF constructor");
    }

    public TransactionSupport.TransactionSupportLevel getTransactionSupport() {
        String str = "MDCompleteMCF.getTransactionSupport called";
        ConnectorStatus.getConnectorStatus().logState(str);
        this.debug(str);
        return TransactionSupport.TransactionSupportLevel.NoTransaction;
    }

    public void setFactoryName(String name) {
        this.debug("MDCompleteMCF.setFactoryName");
        String str = "MDCompleteMCF factoryname=" + name;
        this.debug(str);
        this.factoryName = name;
    }

    public String getFactoryName() {
        this.debug("MDCompleteMCF.getFactoryName");
        return this.factoryName;
    }

    public String getUser() {
        this.debug("MDCompleteMCF.getUser() returning:  " + this.user);
        return this.user;
    }

    public void setUser(String val) {
        this.debug("MDCompleteMCF.setUser() with val = " + val);
        this.user = val;
    }

    public String getUserName() {
        this.debug("MDCompleteMCF.getUserName() returning:  " + this.userName);
        return this.userName;
    }

    public void setUserName(String val) {
        this.debug("MDCompleteMCF.setUserName() with val = " + val);
        this.userName = val;
    }

    public String getPassword() {
        this.debug("MDCompleteMCF.getPassword() returning:  " + this.password);
        return this.password;
    }

    public void setPassword(String val) {
        this.debug("MDCompleteMCF.setPassword() with val = " + val);
        this.password = val;
    }

    public String getTSRValue() {
        this.debug("MDCompleteMCF.getTSRValue");
        return this.TSRValue;
    }

    public void setTSRValue(String name) {
        this.debug("MDCompleteMCF.setTSRValue");
        this.TSRValue = name;
    }

    public void lookupTSR(String lookup) {
        this.debug("MDCompleteMCF.lookupTSR");
        try {
            TSNamingContext ncxt = new TSNamingContext();
            String newStr = "java:".concat(lookup);
            Object obj = ncxt.lookup(newStr);
            if (obj != null) {
                this.debug("TSR Lookup Successful");
            } else {
                this.debug("TSR Null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        ConnectorStatus.getConnectorStatus().logAPI("MDCompleteMCF.createConnectionFactory", "cxManager", "TSEISDataSource");
        return new TSEISDataSource(this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        ConnectorStatus.getConnectorStatus().logAPI("MDCompleteMCF.createConnectionFactory", "", "TSEISDataSource");
        return new TSEISDataSource(this, null);
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        ++this.count;
        String newStr1 = new String("MDCompleteMCF setResourceAdapter " + this.count);
        this.debug(newStr1);
        this.resourceAdapter = ra;
        ConnectorStatus.getConnectorStatus().logState(newStr1);
    }

    public ResourceAdapter getResourceAdapter() {
        this.debug("MDCompleteMCF.getResource");
        return this.resourceAdapter;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        try {
            ConnectorStatus.getConnectorStatus().logAPI("MDCompleteMCF.createManagedConnection", "subject|info", "TSManagedConnection");
            TSConnection con = null;
            PasswordCredential pc = Util.getPasswordCredential(this, subject, info);
            if (pc == null) {
                this.debug("MDCompleteMCF.createManagedConnection():  pc == null");
                con = new TSConnectionImpl().getConnection();
            } else {
                this.debug("MDCompleteMCF.createManagedConnection():  pc != null");
                this.setUser(pc.getUserName());
                this.setUserName(pc.getUserName());
                this.setPassword(new String(pc.getPassword()));
                con = new TSConnectionImpl().getConnection(pc.getUserName(), pc.getPassword());
            }
            TSManagedConnection mcon = new TSManagedConnection(this, pc, null, con, false, true);
            return mcon;
        }
        catch (Exception ex) {
            EISSystemException re = new EISSystemException("Exception: " + ex.getMessage());
            re.initCause((Throwable)ex);
            throw re;
        }
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        ConnectorStatus.getConnectorStatus().logAPI("MDCompleteMCF.matchManagedConnection", "connectionSet|subject|info", "TSEISDataSource");
        PasswordCredential pc = Util.getPasswordCredential(this, subject, info);
        for (Object obj : connectionSet) {
            if (!(obj instanceof TSManagedConnection)) continue;
            TSManagedConnection mc = (TSManagedConnection)obj;
            ManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
            if (!Util.isPasswordCredentialEqual(mc.getPasswordCredential(), pc) || !mcf.equals((Object)this)) continue;
            return mc;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        ConnectorStatus.getConnectorStatus().logAPI("MDCompleteMCF.setLogWriter", "out", "");
    }

    public PrintWriter getLogWriter() throws ResourceException {
        ConnectorStatus.getConnectorStatus().logAPI("MDCompleteMCF.getLogWriter", "", "");
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MDCompleteMCF)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        MDCompleteMCF that = (MDCompleteMCF)obj;
        if (this.reference != null && !this.reference.equals(that.getReference())) {
            return false;
        }
        if (this.reference == null && that.getReference() != null) {
            return false;
        }
        if (this.resourceAdapter != null && !this.resourceAdapter.equals(that.getResourceAdapter())) {
            return false;
        }
        if (this.resourceAdapter == null && that.getResourceAdapter() != null) {
            return false;
        }
        if (this.count != that.getCount()) {
            return false;
        }
        if (!Util.isEqual(this.password, that.getPassword())) {
            return false;
        }
        if (!Util.isEqual(this.user, that.getUser())) {
            return false;
        }
        if (!Util.isEqual(this.userName, that.getUserName())) {
            return false;
        }
        if (!Util.isEqual(this.TSRValue, that.getTSRValue())) {
            return false;
        }
        return Util.isEqual(this.factoryName, that.getFactoryName());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public Reference getReference() {
        Reference ref = this.reference;
        return ref;
    }

    public void setReference(Reference ref) {
        this.reference = ref;
    }

    public void debug(String out) {
        Debug.trace("MDCompleteMCF:  " + out);
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int val) {
        this.count = val;
    }
}

