/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.nestedembedding;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.nestedembedding.A;
import ee.jakarta.tck.persistence.core.nestedembedding.Address;
import ee.jakarta.tck.persistence.core.nestedembedding.B;
import ee.jakarta.tck.persistence.core.nestedembedding.ZipCode;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void NE1XMTest1() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            this.logTrace("New instances");
            ZipCode z1 = new ZipCode("01801", "1234");
            ZipCode z2 = new ZipCode("01803", "1234");
            Address addr1 = new Address("1 Network Drive", "Burlington", "MA");
            Address addr2 = new Address("Some Address", "Boston", "MA");
            addr1.setZipCode(z1);
            addr2.setZipCode(z2);
            B b1 = new B("1", "b1", 1);
            b1.setAddress(addr1);
            B b2 = new B("2", "b2", 1);
            b2.setAddress(addr2);
            B b3 = new B("3", "b3", 1);
            b3.setAddress(addr1);
            B b4 = new B("4", "b4", 1);
            b4.setAddress(addr2);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("1", "bean1", 1, v1);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            this.clearCache();
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            if (newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                B newB = this.getBFromCollection(newCol, b1);
                if (newB != null) {
                    if (newB.getAddress().getStreet().equals("1 Network Drive") && newB.getAddress().getCity().equals("Burlington") && newB.getAddress().getState().equals("MA") && newB.getAddress().getZipCode().getZip().equals("01801") && newB.getAddress().getZipCode().getPlusFour().equals("1234")) {
                        pass = true;
                        this.logTrace("verified nested embedded class contents ");
                    } else {
                        this.logErr("Expected address:" + addr1.toString());
                        this.logErr("actual address:" + newB.getAddress().toString());
                    }
                } else {
                    this.logErr("b not found in Collection");
                }
            } else {
                this.logErr("Collection did not contain all entries:");
                if (newCol.contains(b1)) {
                    this.logTrace("found b1");
                } else {
                    this.logErr("b1 NOT FOUND");
                }
                if (newCol.contains(b2)) {
                    this.logTrace("found b2");
                } else {
                    this.logErr("b2 NOT FOUND");
                }
                if (newCol.contains(b3)) {
                    this.logTrace("found b3");
                } else {
                    this.logErr("b3 NOT FOUND");
                }
                if (newCol.contains(b4)) {
                    this.logTrace("found b4");
                } else {
                    this.logErr("b4 NOT FOUND");
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("cascadeAll1XMTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void NE1XMTest2() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            this.logTrace("New instances");
            ZipCode z1 = new ZipCode("01801", "1234");
            ZipCode z2 = new ZipCode("01803", "1234");
            Address addr1 = new Address("1 Network Drive", "Burlington", "MA");
            Address addr2 = new Address("Some Address", "Boston", "MA");
            addr1.setZipCode(z1);
            addr2.setZipCode(z2);
            B b1 = new B("1", "b1", 1);
            b1.setAddress(addr1);
            B b2 = new B("2", "b2", 1);
            b2.setAddress(addr2);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            A aRef = new A("1", "bean1", 1, v1);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            this.clearCache();
            A newA = this.findA("1");
            if (newA != null) {
                Collection newCol = aRef.getBCol();
                B newB = (B)this.getEntityManager().createQuery("Select b from B b where b.address.zipcode.zip='01801'").getSingleResult();
                if (newB != null) {
                    this.logTrace("newB:" + newB.toString());
                    if (newCol.contains(newB)) {
                        this.logTrace("b contains the searched embeddable Address");
                        pass = true;
                    } else {
                        this.logErr("Expected:" + newCol.toString() + ", actual:" + newB.toString());
                    }
                } else {
                    this.logErr("newB is null");
                }
            } else {
                this.logErr("newA is null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("NE1XMTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void NE1XMTest3() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            this.logTrace("New instances");
            ZipCode z1 = new ZipCode("01801", "1234");
            ZipCode z2 = new ZipCode("01803", "1234");
            Address addr1 = new Address("1 Network Drive", "Burlington", "MA");
            Address addr2 = new Address("Some Address", "Boston", "MA");
            addr1.setZipCode(z1);
            addr2.setZipCode(z2);
            B b1 = new B("1", "b1", 1);
            b1.setAddress(addr1);
            B b2 = new B("2", "b2", 1);
            b2.setAddress(addr2);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            A aRef = new A("1", "bean1", 1, v1);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            this.clearCache();
            A newA = this.findA("1");
            if (newA != null) {
                Collection newCol = aRef.getBCol();
                B newB = (B)this.getEntityManager().createQuery("Select b from B b where b.address.street='1 Network Drive'").getSingleResult();
                if (newB != null) {
                    if (newCol.contains(newB)) {
                        this.logTrace("b contains the searched embeddable Address");
                        pass = true;
                    } else {
                        this.logErr("Expected:" + newCol.toString() + ", actual:" + newB.toString());
                    }
                } else {
                    this.logErr("newB is null");
                }
            } else {
                this.logErr("newA is null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                this.logErr("Unexpected exception rolling back TX:", fe);
            }
        }
        if (!pass) {
            throw new Exception("NE1XMTest3 failed");
        }
    }

    private void createA(A a) {
        this.logTrace("Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityTransaction().commit();
    }

    private A findA(String id) {
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private void createB(B b) {
        this.logTrace("Entered createB method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)b);
        this.getEntityTransaction().commit();
    }

    private B findB(String id) {
        return (B)this.getEntityManager().find(B.class, (Object)id);
    }

    private List findByName(String name) {
        this.logTrace("Entered findByName method");
        return this.getEntityManager().createQuery("select a from A a where a.name = :name").setParameter("name", (Object)name).getResultList();
    }

    private boolean getInstanceStatus(Object o) {
        this.logTrace("Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    private void dumpCollectionDataA(Collection c) {
        this.logTrace("collection Data");
        this.logTrace("---------------");
        this.logTrace("- size=" + c.size());
        Iterator i = c.iterator();
        int elem = 1;
        while (i.hasNext()) {
            A v = (A)i.next();
            this.logTrace("- Element #" + elem++);
            this.logTrace("  id=" + v.getAId() + ", name=" + v.getAName() + ", value=" + v.getAValue());
        }
    }

    private void dumpCollectionDataB(Collection c) {
        this.logTrace("collection Data");
        this.logTrace("---------------");
        this.logTrace("- size=" + c.size());
        Iterator i = c.iterator();
        int elem = 1;
        while (i.hasNext()) {
            B v = (B)i.next();
            this.logTrace("- Element #" + elem++);
            this.logTrace("  id=" + v.getBId() + ", name=" + v.getBName() + ", value=" + v.getBValue());
        }
    }

    public B getBFromCollection(Collection c, B b) {
        this.logTrace("getBFromCollection");
        B resultB = null;
        if (c.size() != 0) {
            for (B newB : c) {
                if (newB.getBId().equals(b.getBId()) && newB.getBName().equals(b.getBName()) && newB.getBValue() == b.getBValue()) {
                    this.logTrace("Found B in Collection");
                    resultB = newB;
                    return resultB;
                }
                this.logTrace("b not found in Collection");
            }
        }
        return resultB;
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM ANE_1XM_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BNE_1XM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

