/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedExecutorService.resourcedef;

import ee.jakarta.tck.concurrent.common.context.IntContext;
import ee.jakarta.tck.concurrent.common.context.StringContext;
import jakarta.enterprise.concurrent.Asynchronous;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Exchanger;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ApplicationScoped
public class AppBean {
    private static final long MAX_WAIT_SECONDS = TimeUnit.MINUTES.toSeconds(2L);

    @Asynchronous(executor="java:module/concurrent/ExecutorB")
    public CompletionStage<String> addStringContextAndWait(BlockingQueue<String> queue, CountDownLatch blocker) {
        String s = StringContext.get();
        try {
            queue.add(s);
            blocker.await(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            return Asynchronous.Result.complete((Object)s);
        }
        catch (Exception x) {
            throw new CompletionException(x);
        }
    }

    @Asynchronous
    public void exchange(Exchanger<String> exchanger, String value) {
        try {
            exchanger.exchange(value, MAX_WAIT_SECONDS, TimeUnit.SECONDS);
        }
        catch (InterruptedException | TimeoutException x) {
            throw new CompletionException(x);
        }
    }

    @Asynchronous(executor="java:app/concurrent/ExecutorA")
    public CompletableFuture<Integer> waitAndGetIntContext(Semaphore started, CountDownLatch blocker) {
        started.release(1);
        CompletableFuture future = Asynchronous.Result.getFuture();
        try {
            while (!future.isDone() && !blocker.await(300L, TimeUnit.MILLISECONDS)) {
                System.out.println(Thread.currentThread().getName() + ": waitAndGetIntContext awaiting signal from caller");
            }
            future.complete(IntContext.get());
        }
        catch (Exception x) {
            future.completeExceptionally(x);
        }
        return future;
    }
}

