/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.common;

import ee.jakarta.tck.concurrent.framework.TestConstants;
import ee.jakarta.tck.concurrent.framework.TestUtil;
import java.time.Duration;
import java.util.concurrent.Callable;

public class CommonTasks {
    public static final String SIMPLE_RETURN_STRING = "ok";

    public static class SimpleArgCallable
    implements Callable {
        private int value = -1;

        public SimpleArgCallable(int arg) {
            this.value = arg;
        }

        public Integer call() {
            try {
                TestUtil.sleep(TestConstants.PollInterval);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this.value;
        }
    }

    public static class SimpleRunnable
    implements Runnable {
        @Override
        public void run() {
            try {
                TestUtil.sleep(TestConstants.PollInterval);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class SimpleCallable
    implements Callable {
        private long waitTime = 0L;

        public SimpleCallable() {
        }

        public SimpleCallable(long argWaitTime) {
            this.waitTime = argWaitTime;
        }

        public String call() {
            try {
                if (this.waitTime != 0L) {
                    TestUtil.sleep(Duration.ofMillis(this.waitTime));
                } else {
                    TestUtil.sleep(TestConstants.PollInterval);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return CommonTasks.SIMPLE_RETURN_STRING;
        }
    }
}

