/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.errormarker;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.errormarker.ErrorMarkerBuilder;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerFBNElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public final class FordiacMarkerHelper {
    public static final Object FAMILY_FORDIAC_MARKER = new Object();

    public static String getLocation(EObject object) {
        if (object instanceof INamedElement) {
            INamedElement namedElement = (INamedElement)object;
            return namedElement.getQualifiedName();
        }
        if (object != null) {
            return FordiacMarkerHelper.getLocation(object.eContainer(), object.eContainingFeature());
        }
        return "";
    }

    public static String getLocation(EObject object, EStructuralFeature feature) {
        if (feature != null) {
            return FordiacMarkerHelper.getLocation(object) + "/" + feature.getName();
        }
        return FordiacMarkerHelper.getLocation(object);
    }

    public static URI getTargetUri(IResource resource, EObject object) {
        if (object != null) {
            URI uri = EcoreUtil.getURI((EObject)object);
            if (uri.isRelative() && resource != null) {
                return URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true).appendFragment(uri.fragment());
            }
            return uri;
        }
        return null;
    }

    public static String getTargetUriString(IResource resource, EObject object) {
        URI uri = FordiacMarkerHelper.getTargetUri(resource, object);
        if (uri != null) {
            return uri.toString();
        }
        return null;
    }

    public static Object[] getDiagnosticData(EObject object, String ... data) {
        return FordiacMarkerHelper.getDiagnosticData(object, null, data);
    }

    public static Object[] getDiagnosticData(EObject object, EStructuralFeature feature, String ... data) {
        if (object == null) {
            return data;
        }
        return Stream.concat(Stream.of(object, FordiacMarkerHelper.getLocation(object), FordiacMarkerHelper.getTargetUriString(null, object), EcoreUtil.getURI((EObject)object.eClass()).toString(), feature != null ? EcoreUtil.getURI((EObject)feature).toString() : null), Stream.of(data)).toArray();
    }

    public static EObject getDiagnosticTarget(Diagnostic diagnostic) {
        Object e;
        List data = diagnostic.getData();
        if (data != null && !data.isEmpty() && (e = data.get(0)) instanceof EObject) {
            EObject target = (EObject)e;
            return target;
        }
        return null;
    }

    public static Map<String, Object> getDiagnosticAttributes(Diagnostic diagnostic) {
        List data;
        if ("org.eclipse.fordiac.ide.model.libraryElement".equals(diagnostic.getSource()) && (data = diagnostic.getData()) != null && data.size() >= 5) {
            if (data.get(4) != null) {
                return Map.of("org.eclipse.fordiac.ide.model.iec61499.code", diagnostic.getCode(), "org.eclipse.fordiac.ide.model.iec61499.source", diagnostic.getSource(), "location", data.get(1), "org.eclipse.fordiac.ide.model.iec61499.targetUri", data.get(2), "org.eclipse.fordiac.ide.model.iec61499.targetType", data.get(3), "org.eclipse.fordiac.ide.model.iec61499.targetFeature", data.get(4), "org.eclipse.fordiac.ide.model.iec61499.data", data.subList(5, data.size()).stream().map(Object::toString).collect(Collectors.joining("\u0000")));
            }
            return Map.of("org.eclipse.fordiac.ide.model.iec61499.code", diagnostic.getCode(), "org.eclipse.fordiac.ide.model.iec61499.source", diagnostic.getSource(), "location", data.get(1), "org.eclipse.fordiac.ide.model.iec61499.targetUri", data.get(2), "org.eclipse.fordiac.ide.model.iec61499.targetType", data.get(3), "org.eclipse.fordiac.ide.model.iec61499.data", data.subList(5, data.size()).stream().map(Object::toString).collect(Collectors.joining("\u0000")));
        }
        return Map.of("org.eclipse.fordiac.ide.model.iec61499.code", diagnostic.getCode(), "org.eclipse.fordiac.ide.model.iec61499.source", diagnostic.getSource());
    }

    public static void createMarkers(final IResource resource, final List<ErrorMarkerBuilder> builders) {
        if (resource != null && resource.isAccessible()) {
            ISchedulingRule currentRule = Job.getJobManager().currentRule();
            if (currentRule != null && currentRule.contains((ISchedulingRule)resource) && !resource.getWorkspace().isTreeLocked()) {
                FordiacMarkerHelper.createMarkersInWorkspace(resource, builders);
            } else {
                WorkspaceJob job = new WorkspaceJob("Create error markers on resource: " + resource.getName()){

                    public IStatus runInWorkspace(IProgressMonitor monitor) {
                        FordiacMarkerHelper.createMarkersInWorkspace(resource, builders);
                        return Status.OK_STATUS;
                    }

                    public boolean belongsTo(Object family) {
                        return family == FAMILY_FORDIAC_MARKER;
                    }
                };
                job.setUser(false);
                job.setSystem(true);
                job.setPriority(50);
                job.setRule((ISchedulingRule)resource);
                job.schedule();
            }
        }
    }

    private static void createMarkersInWorkspace(IResource resource, List<ErrorMarkerBuilder> builders) {
        try {
            for (ErrorMarkerBuilder builder : builders) {
                builder.createMarker(resource);
            }
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)"Could not create error markers", (Throwable)e);
        }
    }

    public static void updateMarkers(final IResource resource, final String type, final List<ErrorMarkerBuilder> builders, boolean force) {
        if (resource != null && resource.isAccessible() && (force || FordiacMarkerHelper.errorMarkersNeedsUpdate(resource, type, builders))) {
            ISchedulingRule currentRule = Job.getJobManager().currentRule();
            if (currentRule != null && currentRule.contains((ISchedulingRule)resource) && !resource.getWorkspace().isTreeLocked()) {
                FordiacMarkerHelper.updateMarkersInWorkspace(resource, type, builders);
            } else {
                WorkspaceJob job = new WorkspaceJob("Update error markers on resource: " + resource.getName()){

                    public IStatus runInWorkspace(IProgressMonitor monitor) {
                        FordiacMarkerHelper.updateMarkersInWorkspace(resource, type, builders);
                        return Status.OK_STATUS;
                    }

                    public boolean belongsTo(Object family) {
                        return family == FAMILY_FORDIAC_MARKER;
                    }
                };
                job.setUser(false);
                job.setSystem(true);
                job.setPriority(50);
                job.setRule((ISchedulingRule)resource);
                job.schedule();
            }
        }
    }

    private static void updateMarkersInWorkspace(IResource resource, String type, List<ErrorMarkerBuilder> builders) {
        try {
            resource.deleteMarkers(type, true, 2);
            for (ErrorMarkerBuilder builder : builders) {
                builder.createMarker(resource);
            }
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)("Could not update error markers on resource: " + resource.getName()), (Throwable)e);
        }
    }

    public static FBNetworkElement createTypeErrorMarkerFB(String typeFbElement, TypeLibrary typeLibrary, EClass typeClass) {
        ErrorMarkerFBNElement errorFb = FordiacMarkerHelper.createErrorMarkerFB(typeFbElement);
        TypeEntry entry = typeLibrary.createErrorTypeEntry(typeFbElement, typeClass);
        errorFb.setTypeEntry(entry);
        return errorFb;
    }

    public static ErrorMarkerFBNElement createErrorMarkerFB(String name) {
        ErrorMarkerFBNElement createErrorMarkerFBNElement = LibraryElementFactory.eINSTANCE.createErrorMarkerFBNElement();
        createErrorMarkerFBNElement.setName(name);
        createErrorMarkerFBNElement.setInterface(LibraryElementFactory.eINSTANCE.createInterfaceList());
        Position position = LibraryElementFactory.eINSTANCE.createPosition();
        position.setX(0.0);
        position.setY(0.0);
        createErrorMarkerFBNElement.setPosition(position);
        return createErrorMarkerFBNElement;
    }

    public static void createAttributeErrorMarker(Attribute attribute, TypeLibrary typeLib) {
        TypeEntry typeEntry = typeLib.createErrorTypeEntry(attribute.getName(), LibraryElementPackage.eINSTANCE.getAttributeDeclaration());
        AttributeDeclaration aDecl = (AttributeDeclaration)typeEntry.getType();
        attribute.setAttributeDeclaration(aDecl);
        attribute.setType(aDecl.getType());
    }

    private static boolean errorMarkersNeedsUpdate(IResource resource, String type, List<ErrorMarkerBuilder> builders) {
        try {
            return !builders.isEmpty() || resource.findMarkers(type, true, 2).length != 0;
        }
        catch (CoreException e) {
            FordiacLogHelper.logWarning((String)("Couldn't determine marker state of resoruce: " + resource.getName()), (Exception)((Object)e));
            return false;
        }
    }

    private FordiacMarkerHelper() {
        throw new UnsupportedOperationException("FordiacMarkerHelper should not be instantiated");
    }
}

